/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import junit.framework.TestCase;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.ParseErrorCollector;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class PositiveParserTest
extends TestCase {
    private String inputURL;
    private String outputURL;
    private String baseURL;
    private RDFParser targetParser;
    private RDFParser ntriplesParser;
    protected IRI testUri;

    public PositiveParserTest(IRI testUri, String testName, String inputURL, String outputURL, String baseURL, RDFParser targetParser, RDFParser ntriplesParser) throws MalformedURLException {
        super(testName);
        this.testUri = testUri;
        this.inputURL = inputURL;
        if (outputURL != null) {
            this.outputURL = outputURL;
        }
        this.baseURL = baseURL;
        this.targetParser = targetParser;
        this.ntriplesParser = ntriplesParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Exception {
        LinkedHashSet inputCollection = new LinkedHashSet();
        StatementCollector inputCollector = new StatementCollector(inputCollection);
        this.targetParser.setRDFHandler((RDFHandler)inputCollector);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.inputURL);
        PositiveParserTest.assertNotNull((String)("Test resource was not found: inputURL=" + this.inputURL), (Object)in);
        System.err.println("test: " + this.inputURL);
        ParseErrorCollector el = new ParseErrorCollector();
        this.targetParser.setParseErrorListener((ParseErrorListener)el);
        try {
            this.targetParser.parse(in, this.baseURL);
        }
        finally {
            in.close();
            if (!el.getFatalErrors().isEmpty()) {
                System.err.println("[Turtle] Input file had fatal parsing errors: ");
                System.err.println(el.getFatalErrors());
            }
            if (!el.getErrors().isEmpty()) {
                System.err.println("[Turtle] Input file had parsing errors: ");
                System.err.println(el.getErrors());
            }
            if (!el.getWarnings().isEmpty()) {
                System.err.println("[Turtle] Input file had parsing warnings: ");
                System.err.println(el.getWarnings());
            }
        }
        if (this.outputURL != null) {
            this.ntriplesParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            LinkedHashSet outputCollection = new LinkedHashSet();
            StatementCollector outputCollector = new StatementCollector(outputCollection);
            this.ntriplesParser.setRDFHandler((RDFHandler)outputCollector);
            in = ((Object)((Object)this)).getClass().getResourceAsStream(this.outputURL);
            try {
                this.ntriplesParser.parse(in, this.baseURL);
            }
            finally {
                in.close();
            }
            if (!Models.isomorphic(inputCollection, outputCollection)) {
                System.err.println("===models not equal===");
                System.err.println("Expected: " + outputCollection);
                System.err.println("Actual  : " + inputCollection);
                System.err.println("======================");
                PositiveParserTest.fail((String)"models not equal");
            }
        }
    }
}

