/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesParserSettings;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ParserConfigTest {
    @Test
    public final void testParserConfig() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertFalse((boolean)testConfig.isSet(BasicParserSettings.PRESERVE_BNODE_IDS));
        Assert.assertFalse((boolean)((Boolean)testConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS)));
        Assert.assertFalse((boolean)testConfig.isPreserveBNodeIDs());
        testConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        Assert.assertTrue((boolean)testConfig.isSet(BasicParserSettings.PRESERVE_BNODE_IDS));
        Assert.assertTrue((boolean)((Boolean)testConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS)));
        Assert.assertTrue((boolean)testConfig.isPreserveBNodeIDs());
        testConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, null);
        Assert.assertFalse((boolean)((Boolean)testConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS)));
        Assert.assertFalse((boolean)testConfig.isPreserveBNodeIDs());
    }

    @Test
    public final void testParserConfigSameAsDefaults() {
        ParserConfig testConfig = new ParserConfig(true, true, false, RDFParser.DatatypeHandling.VERIFY);
        Assert.assertTrue((boolean)testConfig.isSet(BasicParserSettings.PRESERVE_BNODE_IDS));
        Assert.assertFalse((boolean)((Boolean)testConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS)));
        Assert.assertFalse((boolean)testConfig.isPreserveBNodeIDs());
    }

    @Test
    public final void testParserConfigNonDefaults() {
        ParserConfig testConfig = new ParserConfig(false, false, true, RDFParser.DatatypeHandling.IGNORE);
        Assert.assertTrue((boolean)testConfig.isSet(BasicParserSettings.PRESERVE_BNODE_IDS));
        Assert.assertTrue((boolean)((Boolean)testConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS)));
        Assert.assertTrue((boolean)testConfig.isPreserveBNodeIDs());
    }

    @Ignore(value="TODO: Implement me")
    @Test
    public final void testParserConfigBooleanBooleanBooleanDatatypeHandling() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public final void testUseDefaults() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertNotNull((Object)testConfig.getNonFatalErrors());
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().isEmpty());
        testConfig.addNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS);
        Assert.assertFalse((boolean)testConfig.getNonFatalErrors().isEmpty());
        Assert.assertTrue((boolean)testConfig.isNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS));
        testConfig.useDefaults();
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().isEmpty());
        Assert.assertFalse((boolean)testConfig.isNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS));
    }

    @Test
    public final void testSetNonFatalErrors() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertNotNull((Object)testConfig.getNonFatalErrors());
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().isEmpty());
        testConfig.addNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS);
        Assert.assertFalse((boolean)testConfig.getNonFatalErrors().isEmpty());
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().contains(BasicParserSettings.PRESERVE_BNODE_IDS));
        Assert.assertFalse((boolean)testConfig.getNonFatalErrors().contains(BasicParserSettings.VERIFY_DATATYPE_VALUES));
        testConfig.setNonFatalErrors(Collections.singleton(BasicParserSettings.VERIFY_DATATYPE_VALUES));
        Assert.assertNotNull((Object)testConfig.getNonFatalErrors());
        Assert.assertFalse((boolean)testConfig.getNonFatalErrors().isEmpty());
        Assert.assertFalse((boolean)testConfig.getNonFatalErrors().contains(BasicParserSettings.PRESERVE_BNODE_IDS));
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().contains(BasicParserSettings.VERIFY_DATATYPE_VALUES));
        testConfig.setNonFatalErrors(new HashSet());
        Assert.assertNotNull((Object)testConfig.getNonFatalErrors());
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().isEmpty());
    }

    @Test
    public final void testAddNonFatalError() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().isEmpty());
        testConfig.addNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS);
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().contains(BasicParserSettings.PRESERVE_BNODE_IDS));
    }

    @Test
    public final void testIsNonFatalError() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().isEmpty());
        Assert.assertFalse((boolean)testConfig.isNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS));
        testConfig.addNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS);
        Assert.assertTrue((boolean)testConfig.isNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS));
    }

    @Test
    public final void testGetNonFatalErrors() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertTrue((boolean)testConfig.getNonFatalErrors().isEmpty());
        testConfig.addNonFatalError(BasicParserSettings.PRESERVE_BNODE_IDS);
        Assert.assertFalse((boolean)testConfig.getNonFatalErrors().isEmpty());
    }

    @Test
    public final void testVerifyData() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertTrue((boolean)testConfig.verifyData());
        testConfig.set(BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)false);
        Assert.assertFalse((boolean)testConfig.verifyData());
    }

    @Test
    public final void testStopAtFirstError() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertTrue((boolean)testConfig.stopAtFirstError());
        testConfig.addNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        Assert.assertFalse((boolean)testConfig.stopAtFirstError());
    }

    @Test
    public final void testIsPreserveBNodeIDs() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertFalse((boolean)testConfig.isPreserveBNodeIDs());
        testConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        Assert.assertTrue((boolean)testConfig.isPreserveBNodeIDs());
    }

    @Test
    public final void testDatatypeHandling() {
        ParserConfig testConfig = new ParserConfig();
        try {
            testConfig.datatypeHandling();
            Assert.fail((String)"Did not receive expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public final void testGet() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertTrue((boolean)((Boolean)testConfig.get(BasicParserSettings.VERIFY_RELATIVE_URIS)));
        testConfig.set(BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)false);
        Assert.assertFalse((boolean)((Boolean)testConfig.get(BasicParserSettings.VERIFY_RELATIVE_URIS)));
    }

    @Test
    public final void testSet() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertFalse((boolean)testConfig.isSet(BasicParserSettings.VERIFY_RELATIVE_URIS));
        testConfig.set(BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)false);
        Assert.assertTrue((boolean)testConfig.isSet(BasicParserSettings.VERIFY_RELATIVE_URIS));
    }

    @Test
    public final void testIsSet() {
        ParserConfig testConfig = new ParserConfig();
        Assert.assertFalse((boolean)testConfig.isSet(BasicParserSettings.PRESERVE_BNODE_IDS));
        testConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        Assert.assertTrue((boolean)testConfig.isSet(BasicParserSettings.PRESERVE_BNODE_IDS));
    }
}

