/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.DOAP;
import org.eclipse.rdf4j.model.vocabulary.EARL;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.NegativeParserTest;
import org.eclipse.rdf4j.rio.PositiveParserTest;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarlReport {
    public static final IRI ANSELL = SimpleValueFactory.getInstance().createIRI("https://github.com/ansell");
    public static final IRI BROEKSTRA = SimpleValueFactory.getInstance().createIRI("https://bitbucket.org/jeenbroekstra");
    protected Repository earlRepository;
    protected ValueFactory vf;
    protected RepositoryConnection con;
    protected Resource projectNode;
    protected Resource asserterNode;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(TestSuite nextTestSuite, IRI nextAsserterNode, IRI specURI) throws Exception {
        this.asserterNode = nextAsserterNode;
        this.earlRepository = new SailRepository((Sail)new MemoryStore());
        this.earlRepository.initialize();
        this.vf = this.earlRepository.getValueFactory();
        this.con = this.earlRepository.getConnection();
        this.con.begin();
        this.con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.con.setNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.con.setNamespace("doap", "http://usefulinc.com/ns/doap#");
        this.con.setNamespace("earl", "http://www.w3.org/ns/earl#");
        this.con.setNamespace("dcterms", "http://purl.org/dc/terms/");
        this.projectNode = this.vf.createIRI("http://www.openrdf.org/#sesame");
        BNode releaseNode = this.vf.createBNode();
        this.con.add(this.projectNode, RDF.TYPE, (Value)DOAP.PROJECT, new Resource[0]);
        this.con.add(this.projectNode, RDF.TYPE, (Value)EARL.TEST_SUBJECT, new Resource[0]);
        this.con.add(this.projectNode, RDF.TYPE, (Value)EARL.SOFTWARE, new Resource[0]);
        this.con.add(this.projectNode, DOAP.NAME, (Value)this.vf.createLiteral("OpenRDF Sesame"), new Resource[0]);
        this.con.add(this.projectNode, DCTERMS.TITLE, (Value)this.vf.createLiteral("OpenRDF Sesame"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.HOMEPAGE, (Value)this.vf.createIRI("http://www.openrdf.org/#sesame"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.LICENSE, (Value)this.vf.createIRI("https://bitbucket.org/openrdf/sesame/src/master/core/LICENSE.txt"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.DESCRIPTION, (Value)this.vf.createLiteral("Sesame is an extensible Java framework for storing, querying and inferencing for RDF."), new Resource[0]);
        this.con.add(this.projectNode, DOAP.CREATED, (Value)this.vf.createLiteral("2004-03-25", XMLSchema.DATE), new Resource[0]);
        this.con.add(this.projectNode, DOAP.PROGRAMMING_LANGUAGE, (Value)this.vf.createLiteral("Java"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.IMPLEMENTS, (Value)specURI, new Resource[0]);
        this.con.add(this.projectNode, DOAP.DOWNLOAD_PAGE, (Value)this.vf.createIRI("http://sourceforge.net/projects/sesame/files/"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.MAILING_LIST, (Value)this.vf.createIRI("http://lists.sourceforge.net/lists/listinfo/sesame-general"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.BUG_DATABASE, (Value)this.vf.createIRI("https://openrdf.atlassian.net/browse/SES"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.BLOG, (Value)this.vf.createIRI("http://www.openrdf.org/news.jsp"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.DEVELOPER, (Value)ANSELL, new Resource[0]);
        this.con.add(this.projectNode, DOAP.DEVELOPER, (Value)BROEKSTRA, new Resource[0]);
        this.con.add((Resource)ANSELL, RDF.TYPE, (Value)EARL.ASSERTOR, new Resource[0]);
        this.con.add((Resource)ANSELL, RDF.TYPE, (Value)FOAF.PERSON, new Resource[0]);
        this.con.add((Resource)ANSELL, FOAF.NAME, (Value)this.vf.createLiteral("Peter Ansell"), new Resource[0]);
        this.con.add((Resource)BROEKSTRA, RDF.TYPE, (Value)EARL.ASSERTOR, new Resource[0]);
        this.con.add((Resource)BROEKSTRA, RDF.TYPE, (Value)FOAF.PERSON, new Resource[0]);
        this.con.add((Resource)BROEKSTRA, FOAF.NAME, (Value)this.vf.createLiteral("Jeen Broekstra"), new Resource[0]);
        this.con.add(this.projectNode, DOAP.RELEASE, (Value)releaseNode, new Resource[0]);
        this.con.add((Resource)releaseNode, RDF.TYPE, (Value)DOAP.VERSION, new Resource[0]);
        this.con.add((Resource)releaseNode, DOAP.NAME, (Value)this.vf.createLiteral("Sesame 2.8.0"), new Resource[0]);
        SimpleDateFormat xsdDataFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currentDate = xsdDataFormat.format(new Date());
        this.con.add((Resource)releaseNode, DOAP.CREATED, (Value)this.vf.createLiteral(currentDate, XMLSchema.DATE), new Resource[0]);
        TestResult testResult = new TestResult();
        EarlTestListener listener = new EarlTestListener();
        testResult.addListener((TestListener)listener);
        this.logger.info("running EARL tests..");
        nextTestSuite.run(testResult);
        this.logger.info("tests complete, generating EARL report...");
        this.con.commit();
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)RDFFormat.TURTLE).orElseThrow(Rio.unsupportedFormat((RDFFormat)RDFFormat.TURTLE));
        File outFile = File.createTempFile("sesame-earl-compliance", "." + RDFFormat.TURTLE.getDefaultFileExtension());
        try (FileOutputStream out = new FileOutputStream(outFile);){
            this.con.export((RDFHandler)factory.getWriter((OutputStream)out), new Resource[0]);
        }
        this.con.close();
        this.earlRepository.shutDown();
        this.logger.info("EARL output written to " + outFile);
        System.out.println("EARL output written to " + outFile);
    }

    protected class EarlTestListener
    implements TestListener {
        private int errorCount;
        private int failureCount;

        protected EarlTestListener() {
        }

        public void startTest(Test test) {
            this.failureCount = 0;
            this.errorCount = 0;
        }

        public void endTest(Test test) {
            IRI testURI = null;
            boolean didIgnoreFailure = false;
            if (test instanceof PositiveParserTest) {
                testURI = ((PositiveParserTest)test).testUri;
            } else if (test instanceof NegativeParserTest) {
                testURI = ((NegativeParserTest)test).testUri;
                didIgnoreFailure = ((NegativeParserTest)test).didIgnoreFailure;
            } else {
                throw new RuntimeException("Unexpected test type: " + test.getClass());
            }
            System.out.println("testURI: " + testURI.stringValue());
            try {
                BNode testNode = EarlReport.this.vf.createBNode();
                BNode resultNode = EarlReport.this.vf.createBNode();
                EarlReport.this.con.add((Resource)testNode, RDF.TYPE, (Value)EARL.ASSERTION, new Resource[0]);
                EarlReport.this.con.add((Resource)testNode, EARL.ASSERTEDBY, (Value)EarlReport.this.asserterNode, new Resource[0]);
                EarlReport.this.con.add((Resource)testNode, EARL.MODE, (Value)EARL.AUTOMATIC, new Resource[0]);
                EarlReport.this.con.add((Resource)testNode, EARL.SUBJECT, (Value)EarlReport.this.projectNode, new Resource[0]);
                EarlReport.this.con.add((Resource)testNode, EARL.TEST, (Value)testURI, new Resource[0]);
                EarlReport.this.con.add((Resource)testNode, EARL.RESULT, (Value)resultNode, new Resource[0]);
                EarlReport.this.con.add((Resource)resultNode, RDF.TYPE, (Value)EARL.TESTRESULT, new Resource[0]);
                if (didIgnoreFailure) {
                    EarlReport.this.con.add((Resource)resultNode, EARL.OUTCOME, (Value)EARL.NOTTESTED, new Resource[0]);
                } else if (this.errorCount > 0 || this.failureCount > 0) {
                    EarlReport.this.con.add((Resource)resultNode, EARL.OUTCOME, (Value)EARL.FAIL, new Resource[0]);
                } else {
                    EarlReport.this.con.add((Resource)resultNode, EARL.OUTCOME, (Value)EARL.PASS, new Resource[0]);
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }

        public void addError(Test test, Throwable t) {
            ++this.errorCount;
        }

        public void addFailure(Test test, AssertionFailedError error) {
            ++this.failureCount;
        }
    }
}

