/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.turtle;

import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.FailureMode;
import org.eclipse.rdf4j.rio.NegativeParserTest;
import org.eclipse.rdf4j.rio.PositiveParserTest;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public abstract class TurtleParserTestCase {
    protected static String TESTS_W3C_BASE_URL = "http://www.w3.org/2013/TurtleTests/";
    private static String TEST_W3C_FILE_BASE_PATH = "/testcases/turtle/tests-ttl-w3c-20131121/";
    private static String TEST_W3C_MANIFEST_URL = TEST_W3C_FILE_BASE_PATH + "manifest.ttl";
    private static String TEST_W3C_MANIFEST_URI_BASE = "http://www.w3.org/2013/TurtleTests/manifest.ttl#";
    private static String TEST_W3C_TEST_URI_BASE = "http://www.w3.org/2013/TurtleTests/";
    private static String NTRIPLES_TEST_URL = "http://www.w3.org/2000/10/rdf-tests/rdfcore/ntriples/test.nt";
    private static String NTRIPLES_TEST_FILE = "/testcases/ntriples/test.nt";
    private static String TURTLE_NTRIPLES_FILE_BASE_PATH = "/testcases/turtle/tests-nt/";
    private static String TURTLE_NTRIPLES_MANIFEST_URL = "/testcases/turtle/tests-nt/manifest.ttl";
    private static String TURTLE_NTRIPLES_MANIFEST_URI_BASE = "https://dvcs.w3.org/hg/rdf/raw-file/default/rdf-turtle/tests-nt/manifest.ttl#";
    private static String TURTLE_NTRIPLES_TEST_URI_BASE = "https://dvcs.w3.org/hg/rdf/raw-file/default/rdf-turtle/tests-nt/";

    public TestSuite createTestSuite() throws Exception {
        TestSuite suite = new TestSuite(TurtleParserTestCase.class.getName());
        SailRepository w3cRepository = new SailRepository((Sail)new MemoryStore());
        w3cRepository.initialize();
        RepositoryConnection w3cCon = w3cRepository.getConnection();
        InputStream inputStream = this.getClass().getResourceAsStream(TEST_W3C_MANIFEST_URL);
        w3cCon.add(inputStream, TEST_W3C_MANIFEST_URI_BASE, RDFFormat.TURTLE, new Resource[0]);
        this.parsePositiveTurtleSyntaxTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
        this.parseNegativeTurtleSyntaxTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
        this.parsePositiveTurtleEvalTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
        this.parseNegativeTurtleEvalTests(suite, TEST_W3C_FILE_BASE_PATH, TESTS_W3C_BASE_URL, TEST_W3C_TEST_URI_BASE, w3cCon);
        w3cCon.close();
        w3cRepository.shutDown();
        return suite;
    }

    private void parsePositiveTurtleSyntaxTests(TestSuite suite, String fileBasePath, String testBaseUrl, String testLocationBaseUri, RepositoryConnection con) throws Exception {
        StringBuilder positiveQuery = new StringBuilder();
        positiveQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveQuery.append(" WHERE { \n");
        positiveQuery.append("     ?test a rdft:TestTurtlePositiveSyntax . ");
        positiveQuery.append("     ?test mf:name ?testName . ");
        positiveQuery.append("     ?test mf:action ?inputURL . ");
        positiveQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), testLocationBaseUri);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new PositiveParserTest(nextTestUri, nextTestName, nextInputURL, null, nextBaseUrl, this.createTurtleParser(), this.createNTriplesParser()));
        }
        queryResult.close();
    }

    private void parseNegativeTurtleSyntaxTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) throws Exception {
        StringBuilder negativeQuery = new StringBuilder();
        negativeQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        negativeQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        negativeQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        negativeQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        negativeQuery.append(" WHERE { \n");
        negativeQuery.append("     ?test a rdft:TestTurtleNegativeSyntax . ");
        negativeQuery.append("     ?test mf:name ?testName . ");
        negativeQuery.append("     ?test mf:action ?inputURL . ");
        negativeQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, negativeQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new NegativeParserTest(nextTestUri, nextTestName, nextInputURL, nextBaseUrl, this.createTurtleParser(), FailureMode.IGNORE_FAILURE));
        }
        queryResult.close();
    }

    private void parsePositiveTurtleEvalTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) throws Exception {
        StringBuilder positiveEvalQuery = new StringBuilder();
        positiveEvalQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveEvalQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveEvalQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveEvalQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveEvalQuery.append(" WHERE { \n");
        positiveEvalQuery.append("     ?test a rdft:TestTurtleEval . ");
        positiveEvalQuery.append("     ?test mf:name ?testName . ");
        positiveEvalQuery.append("     ?test mf:action ?inputURL . ");
        positiveEvalQuery.append("     ?test mf:result ?outputURL . ");
        positiveEvalQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveEvalQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextOutputURL = fileBasePath + this.removeBase(((IRI)bindingSet.getValue("outputURL")).toString(), manifestBaseUrl);
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new PositiveParserTest(nextTestUri, nextTestName, nextInputURL, nextOutputURL, nextBaseUrl, this.createTurtleParser(), this.createNTriplesParser()));
        }
        queryResult.close();
    }

    private void parseNegativeTurtleEvalTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) throws Exception {
        StringBuilder negativeEvalQuery = new StringBuilder();
        negativeEvalQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        negativeEvalQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        negativeEvalQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        negativeEvalQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        negativeEvalQuery.append(" WHERE { \n");
        negativeEvalQuery.append("     ?test a rdft:TestTurtleNegativeEval . ");
        negativeEvalQuery.append("     ?test mf:name ?testName . ");
        negativeEvalQuery.append("     ?test mf:action ?inputURL . ");
        negativeEvalQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, negativeEvalQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new NegativeParserTest(nextTestUri, nextTestName, nextInputURL, nextBaseUrl, this.createTurtleParser(), FailureMode.IGNORE_FAILURE));
        }
        queryResult.close();
    }

    private void parsePositiveNTriplesSyntaxTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) throws Exception {
        StringBuilder positiveQuery = new StringBuilder();
        positiveQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        positiveQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        positiveQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        positiveQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        positiveQuery.append(" WHERE { \n");
        positiveQuery.append("     ?test a rdft:TestNTriplesPositiveSyntax . ");
        positiveQuery.append("     ?test mf:name ?testName . ");
        positiveQuery.append("     ?test mf:action ?inputURL . ");
        positiveQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, positiveQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new PositiveParserTest(nextTestUri, nextTestName, nextInputURL, null, nextBaseUrl, this.createNTriplesParser(), this.createNTriplesParser()));
        }
        queryResult.close();
    }

    private void parseNegativeNTriplesSyntaxTests(TestSuite suite, String fileBasePath, String testBaseUrl, String manifestBaseUrl, RepositoryConnection con) throws Exception {
        StringBuilder negativeQuery = new StringBuilder();
        negativeQuery.append(" PREFIX mf:   <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n");
        negativeQuery.append(" PREFIX qt:   <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
        negativeQuery.append(" PREFIX rdft: <http://www.w3.org/ns/rdftest#>\n");
        negativeQuery.append(" SELECT ?test ?testName ?inputURL ?outputURL \n");
        negativeQuery.append(" WHERE { \n");
        negativeQuery.append("     ?test a rdft:TestNTriplesNegativeSyntax . ");
        negativeQuery.append("     ?test mf:name ?testName . ");
        negativeQuery.append("     ?test mf:action ?inputURL . ");
        negativeQuery.append(" }");
        TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SPARQL, negativeQuery.toString()).evaluate();
        while (queryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)queryResult.next();
            IRI nextTestUri = (IRI)bindingSet.getValue("test");
            String nextTestName = ((Literal)bindingSet.getValue("testName")).getLabel();
            String nextTestFile = this.removeBase(((IRI)bindingSet.getValue("inputURL")).toString(), manifestBaseUrl);
            String nextInputURL = fileBasePath + nextTestFile;
            String nextBaseUrl = testBaseUrl + nextTestFile;
            suite.addTest((Test)new NegativeParserTest(nextTestUri, nextTestName, nextInputURL, nextBaseUrl, this.createNTriplesParser(), FailureMode.IGNORE_FAILURE));
        }
        queryResult.close();
    }

    protected abstract RDFParser createTurtleParser();

    protected abstract RDFParser createNTriplesParser();

    private String removeBase(String baseUrl, String redundantBaseUrl) {
        if (baseUrl.startsWith(redundantBaseUrl)) {
            return baseUrl.substring(redundantBaseUrl.length());
        }
        return baseUrl;
    }
}

