/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ntriples;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.NTriplesParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractNTriplesParserUnitTest {
    private static String NTRIPLES_TEST_URL = "http://www.w3.org/2000/10/rdf-tests/rdfcore/ntriples/test.nt";
    private static String NTRIPLES_TEST_FILE = "/testcases/ntriples/test.nt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNTriplesFile() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        ntriplesParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        try (InputStream in = this.getClass().getResourceAsStream(NTRIPLES_TEST_FILE);){
            ntriplesParser.parse(in, NTRIPLES_TEST_URL);
        }
        Assert.assertEquals((long)30L, (long)model.size());
        Assert.assertEquals((long)28L, (long)model.subjects().size());
        Assert.assertEquals((long)1L, (long)model.predicates().size());
        Assert.assertEquals((long)23L, (long)model.objects().size());
    }

    @Test
    public void testExceptionHandlingWithDefaultSettings() throws Exception {
        String data = "invalid nt";
        RDFParser ntriplesParser = this.createRDFParser();
        ntriplesParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        try {
            ntriplesParser.parse((Reader)new StringReader(data), NTRIPLES_TEST_URL);
            Assert.fail((String)"expected RDFParseException due to invalid data");
        }
        catch (RDFParseException expected) {
            Assert.assertEquals((long)expected.getLineNumber(), (long)1L);
        }
    }

    @Test
    public void testExceptionHandlingWithStopAtFirstError() throws Exception {
        String data = "invalid nt";
        RDFParser ntriplesParser = this.createRDFParser();
        ntriplesParser.getParserConfig().set(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)Boolean.FALSE);
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        try {
            ntriplesParser.parse((Reader)new StringReader(data), NTRIPLES_TEST_URL);
            Assert.fail((String)"expected RDFParseException due to invalid data");
        }
        catch (RDFParseException expected) {
            Assert.assertEquals((long)expected.getLineNumber(), (long)1L);
        }
    }

    @Test
    public void testExceptionHandlingWithoutStopAtFirstError() throws Exception {
        String data = "invalid nt";
        RDFParser ntriplesParser = this.createRDFParser();
        ntriplesParser.getParserConfig().addNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        ntriplesParser.getParserConfig().set(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)Boolean.TRUE);
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader(data), NTRIPLES_TEST_URL);
        Assert.assertEquals((long)0L, (long)model.size());
        Assert.assertEquals((long)0L, (long)model.subjects().size());
        Assert.assertEquals((long)0L, (long)model.predicates().size());
        Assert.assertEquals((long)0L, (long)model.objects().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionHandlingParsingNTriplesIntoMemoryStore() throws Exception {
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        repo.initialize();
        RepositoryConnection conn = repo.getConnection();
        try {
            conn.getParserConfig().set(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)Boolean.FALSE);
            String data = "invalid nt";
            conn.add((Reader)new StringReader(data), "http://example/", RDFFormat.NTRIPLES, new Resource[0]);
            Assert.fail((String)"expected RDFParseException due to invalid data");
        }
        catch (RDFParseException rDFParseException) {
        }
        finally {
            conn.close();
            repo.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionHandlingParsingNTriplesIntoMemoryStoreWithoutStopAtFirstError() throws Exception {
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        repo.initialize();
        RepositoryConnection conn = repo.getConnection();
        try {
            conn.getParserConfig().addNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            conn.getParserConfig().set(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)Boolean.TRUE);
            String data = "invalid nt";
            conn.add((Reader)new StringReader(data), "http://example/", RDFFormat.NTRIPLES, new Resource[0]);
            Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        }
        finally {
            conn.close();
            repo.shutDown();
        }
    }

    @Test
    public void testEscapes() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> \" \\t \\b \\n \\r \\f \\\" \\' \\\\ \" . "), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)" \t \b \n \r \f \" ' \\ ", (Object)((Literal)model.objectLiteral().get()).getLabel());
    }

    @Test
    public void testEndOfLineCommentNoSpace() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> .#endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testEndOfLineCommentWithSpaceBefore() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> . #endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testEndOfLineCommentWithSpaceAfter() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> .# endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testEndOfLineCommentWithSpaceBoth() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> . # endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testEndOfLineCommentsNoSpace() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> .#endoflinecomment\n<urn:test:subject> <urn:test:predicate> <urn:test:secondobject> . # endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)2L, (long)model.size());
    }

    @Test
    public void testEndOfLineCommentsWithSpaceBefore() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> . #endoflinecomment\n<urn:test:subject> <urn:test:predicate> <urn:test:secondobject> . # endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)2L, (long)model.size());
    }

    @Test
    public void testEndOfLineCommentsWithSpaceAfter() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> .# endoflinecomment\n<urn:test:subject> <urn:test:predicate> <urn:test:secondobject> . # endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)2L, (long)model.size());
    }

    @Test
    public void testEndOfLineCommentsWithSpaceBoth() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> . # endoflinecomment\n<urn:test:subject> <urn:test:predicate> <urn:test:secondobject> . # endoflinecomment\n"), "http://example/");
        Assert.assertEquals((long)2L, (long)model.size());
    }

    @Test
    public void testEndOfLineEmptyCommentNoSpace() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> .#\n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testEndOfLineEmptyCommentWithSpaceBefore() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> . #\n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testEndOfLineEmptyCommentWithSpaceAfter() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> .# \n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testEndOfLineEmptyCommentWithSpaceBoth() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("<urn:test:subject> <urn:test:predicate> <urn:test:object> . # \n"), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"urn:test:object", model.objectString().get());
    }

    @Test
    public void testBlankNodeIdentifiersRDF11() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        ntriplesParser.parse((Reader)new StringReader("_:123 <urn:test:predicate> _:456 ."), "http://example/");
        Assert.assertEquals((long)1L, (long)model.size());
    }

    @Test
    public void testSupportedSettings() throws Exception {
        Assert.assertEquals((long)12L, (long)this.createRDFParser().getSupportedSettings().size());
    }

    @Test
    public void testUriWithSpaceShouldFailToParse() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        String nt = "<http://example/ space> <http://example/p> <http://example/o> .";
        try {
            ntriplesParser.parse((Reader)new StringReader(nt), NTRIPLES_TEST_URL);
            Assert.fail((String)"Should have failed to parse invalid N-Triples uri with space");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)model.size());
        Assert.assertEquals((long)0L, (long)model.subjects().size());
        Assert.assertEquals((long)0L, (long)model.predicates().size());
        Assert.assertEquals((long)0L, (long)model.objects().size());
    }

    @Test
    public void testUriWithEscapeCharactersShouldFailToParse() throws Exception {
        RDFParser ntriplesParser = this.createRDFParser();
        LinkedHashModel model = new LinkedHashModel();
        ntriplesParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        String nt = "<http://example/\\n> <http://example/p> <http://example/o> .";
        try {
            ntriplesParser.parse((Reader)new StringReader(nt), NTRIPLES_TEST_URL);
            Assert.fail((String)"Should have failed to parse invalid N-Triples uri with space");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)model.size());
        Assert.assertEquals((long)0L, (long)model.subjects().size());
        Assert.assertEquals((long)0L, (long)model.predicates().size());
        Assert.assertEquals((long)0L, (long)model.objects().size());
    }

    protected abstract RDFParser createRDFParser();
}

