/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.EARL;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.model.vocabulary.SKOS;
import org.eclipse.rdf4j.model.vocabulary.SP;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserFactory;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class RDFWriterTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private static final Random prng = new SecureRandom();
    protected RDFWriterFactory rdfWriterFactory;
    protected RDFParserFactory rdfParserFactory;
    protected ValueFactory vf;
    private BNode bnode;
    private BNode bnodeEmpty;
    private BNode bnodeSingleLetter;
    private BNode bnodeDuplicateLetter;
    private BNode bnodeNumeric;
    private BNode bnodeDashes;
    private BNode bnodeSpecialChars;
    private BNode bnodeSingleUseSubject;
    private BNode bnodeSingleUseObject;
    private BNode bnodeUseAcrossContextsSubject;
    private BNode bnodeUseAcrossContextsSubjectAndObject;
    private BNode bnodeUseAcrossContextsObject;
    private IRI uri1;
    private IRI uri2;
    private IRI uri3;
    private IRI uri4;
    private IRI uri5;
    private Literal plainLit;
    private Literal dtLit;
    private Literal langLit;
    private Literal litWithNewlineAtEnd;
    private Literal litWithNewlineAtStart;
    private Literal litWithMultipleNewlines;
    private Literal litWithSingleQuotes;
    private Literal litWithDoubleQuotes;
    private Literal litBigPlaceholder;
    private String exNs;
    private List<Resource> potentialSubjects;
    private List<Value> potentialObjects;
    private List<IRI> potentialPredicates;

    protected RDFWriterTest(RDFWriterFactory writerF, RDFParserFactory parserF) {
        int i;
        this.rdfWriterFactory = writerF;
        this.rdfParserFactory = parserF;
        this.vf = SimpleValueFactory.getInstance();
        this.exNs = "http://example.org/";
        this.bnode = this.vf.createBNode("anon");
        this.bnodeEmpty = this.vf.createBNode("");
        this.bnodeSingleLetter = this.vf.createBNode("a");
        this.bnodeDuplicateLetter = this.vf.createBNode("aa");
        this.bnodeNumeric = this.vf.createBNode("123");
        this.bnodeDashes = this.vf.createBNode("a-b");
        this.bnodeSpecialChars = this.vf.createBNode("$%^&*()!@#$a-b<>?\"'[]{}|\\");
        this.bnodeSingleUseSubject = this.vf.createBNode("bnodeSingleUseSubject");
        this.bnodeSingleUseObject = this.vf.createBNode("bnodeSingleUseObject");
        this.bnodeUseAcrossContextsSubject = this.vf.createBNode("bnodeUseAcrossContextsSubject");
        this.bnodeUseAcrossContextsSubjectAndObject = this.vf.createBNode("bnodeUseAcrossContextsSubjectAndObject");
        this.bnodeUseAcrossContextsObject = this.vf.createBNode("bnodeUseAcrossContextsObject");
        this.uri1 = this.vf.createIRI(this.exNs, "uri1");
        this.uri2 = this.vf.createIRI(this.exNs, "uri2");
        this.uri3 = this.vf.createIRI(this.exNs, "uri3.");
        this.uri4 = this.vf.createIRI(this.exNs, "uri4#me");
        this.uri5 = this.vf.createIRI(this.exNs, "uri5/you");
        this.plainLit = this.vf.createLiteral("plain");
        this.dtLit = this.vf.createLiteral(1);
        this.langLit = this.vf.createLiteral("test", "en");
        this.litWithNewlineAtEnd = this.vf.createLiteral("literal with newline at end\n");
        this.litWithNewlineAtStart = this.vf.createLiteral("\nliteral with newline at start");
        this.litWithMultipleNewlines = this.vf.createLiteral("\nliteral \nwith newline at start\n");
        this.litWithSingleQuotes = this.vf.createLiteral("'''some single quote text''' - abc");
        this.litWithDoubleQuotes = this.vf.createLiteral("\"\"\"some double quote text\"\"\" - abc");
        this.litBigPlaceholder = this.vf.createLiteral(prng.nextDouble());
        this.potentialSubjects = new ArrayList<Resource>();
        this.potentialSubjects.add((Resource)this.bnode);
        this.potentialSubjects.add((Resource)this.bnodeEmpty);
        this.potentialSubjects.add((Resource)this.bnodeSingleLetter);
        this.potentialSubjects.add((Resource)this.bnodeDuplicateLetter);
        this.potentialSubjects.add((Resource)this.bnodeNumeric);
        this.potentialSubjects.add((Resource)this.bnodeDashes);
        this.potentialSubjects.add((Resource)this.bnodeSpecialChars);
        this.potentialSubjects.add((Resource)this.uri1);
        this.potentialSubjects.add((Resource)this.uri2);
        this.potentialSubjects.add((Resource)this.uri3);
        this.potentialSubjects.add((Resource)this.uri4);
        this.potentialSubjects.add((Resource)this.uri5);
        for (i = 0; i < 50; ++i) {
            this.potentialSubjects.add((Resource)this.vf.createBNode());
        }
        for (i = 0; i < 50; ++i) {
            this.potentialSubjects.add((Resource)this.vf.createBNode(Integer.toHexString(i)));
        }
        for (i = 1; i < 50; ++i) {
            this.potentialSubjects.add((Resource)this.vf.createBNode("a" + Integer.toHexString(i).toUpperCase()));
        }
        for (i = 1; i < 50; ++i) {
            this.potentialSubjects.add((Resource)this.vf.createBNode("a" + Integer.toHexString(i).toLowerCase()));
        }
        for (i = 0; i < 200; ++i) {
            this.potentialSubjects.add((Resource)this.vf.createIRI(this.exNs + Integer.toHexString(i) + "/a" + Integer.toOctalString(i % 133)));
        }
        Collections.shuffle(this.potentialSubjects, prng);
        this.potentialObjects = new ArrayList<Value>();
        this.potentialObjects.addAll(this.potentialSubjects);
        this.potentialObjects.add((Value)this.plainLit);
        this.potentialObjects.add((Value)this.dtLit);
        this.potentialObjects.add((Value)this.langLit);
        if (!this.rdfParserFactory.getRDFFormat().equals((Object)RDFFormat.RDFXML)) {
            this.potentialObjects.add((Value)this.litWithNewlineAtEnd);
            this.potentialObjects.add((Value)this.litWithNewlineAtStart);
            this.potentialObjects.add((Value)this.litWithMultipleNewlines);
        }
        this.potentialObjects.add((Value)this.litWithSingleQuotes);
        this.potentialObjects.add((Value)this.litWithDoubleQuotes);
        this.potentialObjects.add((Value)this.litBigPlaceholder);
        Collections.shuffle(this.potentialObjects, prng);
        this.potentialPredicates = new ArrayList<IRI>();
        this.potentialPredicates.add(RDF.TYPE);
        this.potentialPredicates.add(RDF.NIL);
        this.potentialPredicates.add(RDF.FIRST);
        this.potentialPredicates.add(RDF.REST);
        this.potentialPredicates.add(SKOS.ALT_LABEL);
        this.potentialPredicates.add(SKOS.PREF_LABEL);
        this.potentialPredicates.add(SKOS.BROADER_TRANSITIVE);
        this.potentialPredicates.add(OWL.ONTOLOGY);
        this.potentialPredicates.add(OWL.ONEOF);
        this.potentialPredicates.add(DC.TITLE);
        this.potentialPredicates.add(DCTERMS.ACCESS_RIGHTS);
        this.potentialPredicates.add(FOAF.KNOWS);
        this.potentialPredicates.add(EARL.SUBJECT);
        this.potentialPredicates.add(RDFS.LABEL);
        this.potentialPredicates.add(SP.DEFAULT_PROPERTY);
        this.potentialPredicates.add(SP.TEXT_PROPERTY);
        this.potentialPredicates.add(SP.BIND_CLASS);
        this.potentialPredicates.add(SP.DOCUMENT_PROPERTY);
        this.potentialPredicates.add(SPIN.LABEL_TEMPLATE_PROPERTY);
        this.potentialPredicates.add(SESAME.DIRECTTYPE);
        Collections.shuffle(this.potentialPredicates, prng);
    }

    protected void setupWriterConfig(WriterConfig config) {
    }

    protected void setupParserConfig(ParserConfig config) {
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        config.set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
    }

    protected void write(Model model, OutputStream writer) throws RDFHandlerException {
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter(writer);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        Rio.write((Iterable)model, (RDFHandler)rdfWriter);
    }

    protected Model parse(InputStream reader, String baseURI) throws RDFParseException, RDFHandlerException, IOException {
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel result = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)result));
        rdfParser.parse(reader, baseURI);
        return result;
    }

    @Test
    public void testRoundTripWithXSDString() throws RDFHandlerException, IOException, RDFParseException {
        this.roundTrip(true);
    }

    @Test
    public void testRoundTripWithoutXSDString() throws RDFHandlerException, IOException, RDFParseException {
        this.roundTrip(false);
    }

    private void roundTrip(boolean serialiseXSDString) throws RDFHandlerException, IOException, RDFParseException {
        this.testRoundTripInternal(false);
    }

    @Test
    public void testRoundTripPreserveBNodeIds() throws Exception {
        this.testRoundTripInternal(true);
    }

    private void testRoundTripInternal(boolean preserveBNodeIds) throws RDFHandlerException, IOException, RDFParseException {
        Statement st1 = this.vf.createStatement((Resource)this.bnode, this.uri1, (Value)this.plainLit);
        Statement st2 = this.vf.createStatement((Resource)this.bnodeEmpty, this.uri1, (Value)this.plainLit);
        Statement st3 = this.vf.createStatement((Resource)this.bnodeNumeric, this.uri1, (Value)this.plainLit);
        Statement st4 = this.vf.createStatement((Resource)this.bnodeDashes, this.uri1, (Value)this.plainLit);
        Statement st5 = this.vf.createStatement((Resource)this.bnodeSpecialChars, this.uri1, (Value)this.plainLit);
        Statement st6 = this.vf.createStatement((Resource)this.uri2, this.uri1, (Value)this.bnode);
        Statement st7 = this.vf.createStatement((Resource)this.uri2, this.uri1, (Value)this.bnodeEmpty);
        Statement st8 = this.vf.createStatement((Resource)this.uri2, this.uri1, (Value)this.bnodeNumeric);
        Statement st9 = this.vf.createStatement((Resource)this.uri2, this.uri1, (Value)this.bnodeDashes);
        Statement st10 = this.vf.createStatement((Resource)this.uri2, this.uri1, (Value)this.bnodeSpecialChars);
        Statement st11 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.langLit, (Resource)this.uri2);
        Statement st12 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.dtLit);
        Statement st13 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.litWithNewlineAtEnd);
        Statement st14 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.litWithNewlineAtStart);
        Statement st15 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.litWithMultipleNewlines);
        Statement st16 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.litWithSingleQuotes);
        Statement st17 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.litWithDoubleQuotes);
        Statement st18 = this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.uri3);
        Statement st19 = this.vf.createStatement((Resource)this.uri2, this.uri3, (Value)this.uri1);
        Statement st20 = this.vf.createStatement((Resource)this.uri3, this.uri1, (Value)this.uri2);
        Statement st21 = this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri4, (Value)this.uri5);
        Statement st22 = this.vf.createStatement((Resource)this.uri4, this.uri5, (Value)this.bnodeSingleUseObject);
        Statement st23 = this.vf.createStatement((Resource)this.bnodeUseAcrossContextsSubject, this.uri4, (Value)this.uri3, (Resource)this.uri1);
        Statement st24 = this.vf.createStatement((Resource)this.bnodeUseAcrossContextsSubject, this.uri4, (Value)this.uri3, (Resource)this.uri2);
        Statement st25 = this.vf.createStatement((Resource)this.bnodeUseAcrossContextsSubjectAndObject, this.uri5, (Value)this.uri4, (Resource)this.uri1);
        Statement st26 = this.vf.createStatement((Resource)this.uri4, this.uri3, (Value)this.bnodeUseAcrossContextsSubjectAndObject, (Resource)this.uri3);
        Statement st27 = this.vf.createStatement((Resource)this.uri3, this.uri4, (Value)this.bnodeUseAcrossContextsObject, (Resource)this.uri1);
        Statement st28 = this.vf.createStatement((Resource)this.uri3, this.uri4, (Value)this.bnodeUseAcrossContextsObject, (Resource)this.uri2);
        Statement st29 = this.vf.createStatement((Resource)this.uri5, this.uri4, (Value)this.uri1, (Resource)this.bnodeSpecialChars);
        Statement st30 = this.vf.createStatement((Resource)this.uri5, this.uri4, (Value)this.uri2, (Resource)this.bnodeSpecialChars);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)out);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.startRDF();
        rdfWriter.handleStatement(st1);
        rdfWriter.handleStatement(st2);
        rdfWriter.handleStatement(st3);
        rdfWriter.handleStatement(st4);
        rdfWriter.handleStatement(st5);
        rdfWriter.handleStatement(st6);
        rdfWriter.handleStatement(st7);
        rdfWriter.handleStatement(st8);
        rdfWriter.handleStatement(st9);
        rdfWriter.handleStatement(st10);
        rdfWriter.handleStatement(st11);
        rdfWriter.handleStatement(st12);
        rdfWriter.handleStatement(st13);
        rdfWriter.handleStatement(st14);
        rdfWriter.handleStatement(st15);
        rdfWriter.handleStatement(st16);
        rdfWriter.handleStatement(st17);
        rdfWriter.handleStatement(st18);
        rdfWriter.handleStatement(st19);
        rdfWriter.handleStatement(st20);
        rdfWriter.handleStatement(st21);
        rdfWriter.handleStatement(st22);
        rdfWriter.handleStatement(st23);
        rdfWriter.handleStatement(st24);
        rdfWriter.handleStatement(st25);
        rdfWriter.handleStatement(st26);
        rdfWriter.handleStatement(st27);
        rdfWriter.handleStatement(st28);
        rdfWriter.handleStatement(st29);
        rdfWriter.handleStatement(st30);
        rdfWriter.endRDF();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        if (preserveBNodeIds) {
            rdfParser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        }
        rdfParser.setValueFactory(this.vf);
        LinkedHashModel model = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
        rdfParser.parse((InputStream)in, "foo:bar");
        if (rdfParser.getRDFFormat().supportsContexts()) {
            Assert.assertEquals((String)("Unexpected number of statements, found " + model.size()), (long)30L, (long)model.size());
        } else {
            Assert.assertEquals((String)("Unexpected number of statements, found " + model.size()), (long)28L, (long)model.size());
        }
        if (rdfParser.getRDFFormat().supportsNamespaces()) {
            Assert.assertTrue((String)("Expected at least one namespace, found" + model.getNamespaces().size()), (model.getNamespaces().size() >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.exNs, (Object)((Namespace)model.getNamespace("ex").get()).getName());
        }
        Assert.assertEquals((String)"Unexpected number of statements with blank node subjects", (long)5L, (long)model.filter(null, this.uri1, (Value)this.plainLit, new Resource[0]).size());
        Assert.assertEquals((String)"Unexpected number of statements with blank node objects", (long)5L, (long)model.filter((Resource)this.uri2, this.uri1, null, new Resource[0]).size());
        if (rdfParser.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((String)"missing statement with language literal and context: st11", (boolean)model.contains((Object)st11));
        } else {
            Assert.assertTrue((String)"missing statement with language literal: st11", (boolean)model.contains((Object)this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.langLit)));
        }
        Assert.assertTrue((String)"missing statement with datatype: st12", (boolean)model.contains((Object)st12));
        if (rdfParser.getRDFFormat().equals((Object)RDFFormat.RDFXML)) {
            System.out.println("FIXME: SES-879: RDFXML Parser does not preserve literals starting or ending in newline character");
        } else {
            Assert.assertTrue((String)"missing statement with literal ending with newline: st13", (boolean)model.contains((Object)st13));
            Assert.assertTrue((String)"missing statement with literal starting with newline: st14", (boolean)model.contains((Object)st14));
            Assert.assertTrue((String)"missing statement with literal containing multiple newlines: st15", (boolean)model.contains((Object)st15));
        }
        Assert.assertTrue((String)"missing statement with single quotes: st16", (boolean)model.contains((Object)st16));
        Assert.assertTrue((String)"missing statement with double quotes: st17", (boolean)model.contains((Object)st17));
        Assert.assertTrue((String)"missing statement with object URI ending in period: st18", (boolean)model.contains((Object)st18));
        Assert.assertTrue((String)"missing statement with predicate URI ending in period: st19", (boolean)model.contains((Object)st19));
        Assert.assertTrue((String)"missing statement with subject URI ending in period: st20", (boolean)model.contains((Object)st20));
        Assert.assertEquals((String)"missing statement with blank node single use subject: st21", (long)1L, (long)model.filter(null, this.uri4, (Value)this.uri5, new Resource[0]).size());
        Assert.assertEquals((String)"missing statement with blank node single use object: st22", (long)1L, (long)model.filter((Resource)this.uri4, this.uri5, null, new Resource[0]).size());
        Model st23Statements = model.filter(null, this.uri4, (Value)this.uri3, new Resource[0]);
        if (rdfParser.getRDFFormat().supportsContexts()) {
            Assert.assertEquals((String)"missing statement with blank node use: st23/st24", (long)2L, (long)st23Statements.size());
            Set st23Contexts = st23Statements.contexts();
            Assert.assertTrue((boolean)st23Contexts.contains(this.uri1));
            Assert.assertTrue((boolean)st23Contexts.contains(this.uri2));
        } else {
            Assert.assertEquals((String)"missing statement with blank node use: st23/st24", (long)1L, (long)st23Statements.size());
        }
        Assert.assertEquals((String)"missing statement with blank node use subject and object: st25", (long)1L, (long)model.filter(null, this.uri5, (Value)this.uri4, new Resource[0]).size());
        Assert.assertEquals((String)"missing statement with blank node use subject and object: st26", (long)1L, (long)model.filter((Resource)this.uri4, this.uri3, null, new Resource[0]).size());
        Model st27Statements = model.filter((Resource)this.uri3, this.uri4, null, new Resource[0]);
        if (rdfParser.getRDFFormat().supportsContexts()) {
            Assert.assertEquals((String)"missing statement with blank node use: object: st27/st28", (long)2L, (long)st27Statements.size());
            Set st27Contexts = st27Statements.contexts();
            Assert.assertTrue((boolean)st27Contexts.contains(this.uri1));
            Assert.assertTrue((boolean)st27Contexts.contains(this.uri2));
        } else {
            Assert.assertEquals((String)"missing statement with blank node use: object: st27/st28", (long)1L, (long)st27Statements.size());
        }
        if (rdfParser.getRDFFormat().supportsContexts()) {
            Set st29Contexts = model.filter((Resource)this.uri5, this.uri4, (Value)this.uri1, new Resource[0]).contexts();
            Assert.assertEquals((String)"Unexpected number of contexts containing blank node context statement", (long)1L, (long)st29Contexts.size());
            Assert.assertNotNull((String)"missing statements with blank node context: st29", st29Contexts.iterator().next());
            Set st30Contexts = model.filter((Resource)this.uri5, this.uri4, (Value)this.uri2, new Resource[0]).contexts();
            Assert.assertEquals((String)"Unexpected number of contexts containing blank node context statement", (long)1L, (long)st30Contexts.size());
            Assert.assertNotNull((String)"missing statements with blank node context: st30", st30Contexts.iterator().next());
            Assert.assertEquals((String)"Context for two blank node statements was not the same", st29Contexts.iterator().next(), st30Contexts.iterator().next());
            Assert.assertEquals((String)"Unexpected number of statements in the blank node context", (long)2L, (long)model.filter(null, null, null, new Resource[]{(Resource)st29Contexts.iterator().next()}).size());
            Assert.assertEquals((String)"Unexpected number of statements in the blank node context", (long)2L, (long)model.filter(null, null, null, new Resource[]{(Resource)st30Contexts.iterator().next()}).size());
        } else {
            Assert.assertEquals((String)"missing statement with blank node context in non-quads format: st29", (long)1L, (long)model.filter((Resource)this.uri5, this.uri4, (Value)this.uri1, new Resource[0]).size());
            Assert.assertEquals((String)"missing statement with blank node context in non-quads format: st30", (long)1L, (long)model.filter((Resource)this.uri5, this.uri4, (Value)this.uri2, new Resource[0]).size());
        }
    }

    @Test
    public void testPrefixRedefinition() throws RDFHandlerException, RDFParseException, IOException {
        String ns1 = "a:";
        String ns2 = "b:";
        String ns3 = "c:";
        IRI uri1 = this.vf.createIRI(ns1, "r1");
        IRI uri2 = this.vf.createIRI(ns2, "r2");
        IRI uri3 = this.vf.createIRI(ns3, "r3");
        Statement st = this.vf.createStatement((Resource)uri1, uri2, (Value)uri3);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)out);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.handleNamespace("", ns1);
        rdfWriter.handleNamespace("", ns2);
        rdfWriter.handleNamespace("", ns3);
        rdfWriter.startRDF();
        rdfWriter.handleStatement(st);
        rdfWriter.endRDF();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        rdfParser.setValueFactory(this.vf);
        StatementCollector stCollector = new StatementCollector();
        rdfParser.setRDFHandler((RDFHandler)stCollector);
        rdfParser.parse((InputStream)in, "foo:bar");
        Collection statements = stCollector.getStatements();
        Assert.assertEquals((String)"Unexpected number of statements", (long)1L, (long)statements.size());
        Statement parsedSt = (Statement)statements.iterator().next();
        Assert.assertEquals((String)"Written and parsed statements are not equal", (Object)st, (Object)parsedSt);
    }

    @Test
    public void testIllegalPrefix() throws RDFHandlerException, RDFParseException, IOException {
        String ns1 = "a:";
        String ns2 = "b:";
        String ns3 = "c:";
        IRI uri1 = this.vf.createIRI(ns1, "r1");
        IRI uri2 = this.vf.createIRI(ns2, "r2");
        IRI uri3 = this.vf.createIRI(ns3, "r3");
        Statement st = this.vf.createStatement((Resource)uri1, uri2, (Value)uri3);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)out);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.handleNamespace("1", ns1);
        rdfWriter.handleNamespace("_", ns2);
        rdfWriter.handleNamespace("a%", ns3);
        rdfWriter.startRDF();
        rdfWriter.handleStatement(st);
        rdfWriter.endRDF();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        rdfParser.setValueFactory(this.vf);
        StatementCollector stCollector = new StatementCollector();
        rdfParser.setRDFHandler((RDFHandler)stCollector);
        rdfParser.parse((InputStream)in, "foo:bar");
        Collection statements = stCollector.getStatements();
        Assert.assertEquals((String)"Unexpected number of statements", (long)1L, (long)statements.size());
        Statement parsedSt = (Statement)statements.iterator().next();
        Assert.assertEquals((String)"Written and parsed statements are not equal", (Object)st, (Object)parsedSt);
    }

    @Test
    public void testDefaultNamespace() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)out);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.handleNamespace("", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rdfWriter.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.vf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#"), RDF.TYPE, (Value)OWL.ONTOLOGY));
        rdfWriter.endRDF();
    }

    @Test
    public void testSES2030BNodeCollisionsPreserveBNodeIds() throws Exception {
        this.testSES2030BNodeCollisionsInternal(true);
    }

    @Test
    public void testSES2030BNodeCollisions() throws Exception {
        this.testSES2030BNodeCollisionsInternal(false);
    }

    private void testSES2030BNodeCollisionsInternal(boolean preserveBNodeIDs) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)output);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        int count = 18;
        for (int i = 0; i < count; ++i) {
            BNode bNode2 = this.vf.createBNode("a" + Integer.toHexString(i).toUpperCase());
            rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)bNode2));
        }
        rdfWriter.endRDF();
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        if (preserveBNodeIDs) {
            rdfParser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        }
        LinkedHashModel parsedModel = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedModel));
        rdfParser.parse((InputStream)new ByteArrayInputStream(output.toByteArray()), "");
        if (count != parsedModel.size()) {
            Rio.write((Iterable)parsedModel, (OutputStream)System.out, (RDFFormat)RDFFormat.NQUADS);
        }
        Assert.assertEquals((long)count, (long)parsedModel.size());
    }

    @Test
    public void testPerformance() throws Exception {
        this.testPerformanceInternal(true);
    }

    @Test
    public void testPerformanceNoHandling() throws Exception {
        this.testPerformanceInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPerformanceInternal(boolean storeParsedStatements) throws Exception {
        LinkedHashModel model = new LinkedHashModel();
        for (int i = 0; i < 10000; ++i) {
            Value obj = this.potentialObjects.get(prng.nextInt(this.potentialObjects.size()));
            if (obj == this.litBigPlaceholder) {
                StringBuffer big = new StringBuffer();
                int len = 25000 + prng.nextInt(5000);
                for (int j = 0; j < len; ++j) {
                    big.append((char)(32 + prng.nextInt(90)));
                }
                obj = this.vf.createLiteral(big.toString());
            }
            model.add(this.potentialSubjects.get(prng.nextInt(this.potentialSubjects.size())), this.potentialPredicates.get(prng.nextInt(this.potentialPredicates.size())), obj, new Resource[0]);
        }
        System.out.println("Test class: " + this.getClass().getName());
        System.out.println("Test statements size: " + model.size() + " (" + this.rdfWriterFactory.getRDFFormat() + ")");
        Assert.assertFalse((String)"Did not generate any test statements", (boolean)model.isEmpty());
        File testFile = this.tempDir.newFile("performancetest." + this.rdfWriterFactory.getRDFFormat().getDefaultFileExtension());
        try (FileOutputStream out = new FileOutputStream(testFile);){
            long startWrite = System.currentTimeMillis();
            RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)out);
            this.setupWriterConfig(rdfWriter.getWriterConfig());
            rdfWriter.handleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            rdfWriter.handleNamespace("skos", "http://www.w3.org/2004/02/skos/core#");
            rdfWriter.handleNamespace("foaf", "http://xmlns.com/foaf/0.1/");
            rdfWriter.handleNamespace("earl", "http://www.w3.org/ns/earl#");
            rdfWriter.handleNamespace("ex", this.exNs);
            rdfWriter.startRDF();
            for (Statement nextSt : model) {
                rdfWriter.handleStatement(nextSt);
            }
            rdfWriter.endRDF();
            long endWrite = System.currentTimeMillis();
            System.out.println("Write took: " + (endWrite - startWrite) + " ms (" + this.rdfWriterFactory.getRDFFormat() + ")");
            System.out.println("File size (bytes): " + testFile.length());
        }
        try (FileInputStream in = new FileInputStream(testFile);){
            RDFParser rdfParser = this.rdfParserFactory.getParser();
            this.setupParserConfig(rdfParser.getParserConfig());
            rdfParser.setValueFactory(this.vf);
            LinkedHashModel parsedModel = new LinkedHashModel();
            if (storeParsedStatements) {
                rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedModel));
            }
            long startParse = System.currentTimeMillis();
            rdfParser.parse((InputStream)in, "foo:bar");
            long endParse = System.currentTimeMillis();
            System.out.println("Parse took: " + (endParse - startParse) + " ms (" + this.rdfParserFactory.getRDFFormat() + ")");
            if (storeParsedStatements) {
                if (model.size() != parsedModel.size() && model.size() < 1000) {
                    boolean originalIsSubset = Models.isSubset((Set)model, (Set)parsedModel);
                    boolean parsedIsSubset = Models.isSubset((Set)parsedModel, (Set)model);
                    System.out.println("originalIsSubset=" + originalIsSubset);
                    System.out.println("parsedIsSubset=" + parsedIsSubset);
                    System.out.println("Written statements=>");
                    IOUtils.writeLines((Collection)IOUtils.readLines((InputStream)new FileInputStream(testFile)), (String)"\n", (OutputStream)System.out);
                    System.out.println("Parsed statements=>");
                    Rio.write((Iterable)parsedModel, (OutputStream)System.out, (RDFFormat)RDFFormat.NQUADS);
                }
                Assert.assertEquals((String)("Unexpected number of statements, expected " + model.size() + " found " + parsedModel.size()), (long)model.size(), (long)parsedModel.size());
                if (rdfParser.getRDFFormat().supportsNamespaces()) {
                    Assert.assertTrue((String)("Expected at least 5 namespaces, found " + parsedModel.getNamespaces().size()), (parsedModel.getNamespaces().size() >= 5 ? 1 : 0) != 0);
                    Assert.assertEquals((Object)this.exNs, (Object)((Namespace)parsedModel.getNamespace("ex").get()).getName());
                }
            }
        }
    }

    @Test
    public void testWriteSingleStatementNoBNodesNoContext() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1)));
    }

    @Test
    public void testWriteSingleStatementNoBNodesSingleContextIRI() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1)));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1)));
        }
    }

    @Test
    public void testWriteSingleStatementNoBNodesSingleContextBnode() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
    }

    @Test
    public void testWriteSingleStatementSubjectBNodeNoContext() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteSingleStatementSubjectBNodeSingleContextIRI() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}).size());
        } else {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteSingleStatementSubjectBNodeSingleContextBNode() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsSubjectBNodeSinglePredicateNoContext() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1));
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri2));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsSubjectBNodeSinglePredicateSingleContextIRI() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri2, (Resource)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}).size());
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[]{this.uri1}).size());
        } else {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[0]).size());
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsSubjectBNodeSinglePredicateSingleContextBNode() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri2, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteSingleStatementNoBNodesNoContextWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1)));
    }

    @Test
    public void testWriteSingleStatementNoBNodesSingleContextIRIWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1)));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1)));
        }
    }

    @Test
    public void testWriteSingleStatementNoBNodesSingleContextBnodeWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
    }

    @Test
    public void testWriteSingleStatementSubjectBNodeNoContextWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteSingleStatementSubjectBNodeSingleContextIRIWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}).size());
        } else {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteSingleStatementSubjectBNodeSingleContextBNodeWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsSubjectBNodeSinglePredicateNoContextWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1));
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri2));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsSubjectBNodeSinglePredicateSingleContextIRIWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri2, (Resource)this.uri1));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}).size());
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[]{this.uri1}).size());
        } else {
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
            Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[0]).size());
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsSubjectBNodeSinglePredicateSingleContextBNodeWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        input.add((Object)this.vf.createStatement((Resource)this.bnodeSingleUseSubject, this.uri1, (Value)this.uri2, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri1, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter(null, this.uri1, (Value)this.uri2, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.subjects().size());
        Assert.assertTrue((boolean)(parsedOutput.subjects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsObjectBNodeSinglePredicateSingleContextBNodeWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.bnodeSingleUseObject, (Resource)this.bnode));
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri2, (Value)this.bnodeSingleUseObject, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter((Resource)this.uri1, this.uri1, null, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.filter((Resource)this.uri1, this.uri2, null, new Resource[0]).size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.objects().size());
        Assert.assertTrue((boolean)(parsedOutput.objects().iterator().next() instanceof BNode));
    }

    @Test
    public void testWriteTwoStatementsObjectBNodeSinglePredicateSingleContextBNodeReusedWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.bnodeSingleUseObject, (Resource)this.bnode));
        input.add((Object)this.vf.createStatement((Resource)this.bnode, this.uri2, (Value)this.bnodeSingleUseObject, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Model doubleBNodeStatement = parsedOutput.filter((Resource)this.uri1, this.uri1, null, new Resource[0]);
        Assert.assertEquals((long)1L, (long)doubleBNodeStatement.size());
        Model tripleBNodeStatement = parsedOutput.filter(null, this.uri2, null, new Resource[0]);
        Assert.assertEquals((long)1L, (long)tripleBNodeStatement.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.objects().size());
        Assert.assertTrue((boolean)(parsedOutput.objects().iterator().next() instanceof BNode));
        Assert.assertTrue((boolean)(tripleBNodeStatement.subjects().iterator().next() instanceof BNode));
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertEquals(tripleBNodeStatement.subjects().iterator().next(), doubleBNodeStatement.contexts().iterator().next());
        }
    }

    @Test
    public void testWriteOneStatementsObjectBNodeSinglePredicateSingleContextBNodeReusedWithNamespace() throws Exception {
        LinkedHashModel input = new LinkedHashModel();
        input.setNamespace("ex", this.exNs);
        input.add((Object)this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.bnode, (Resource)this.bnode));
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        this.write((Model)input, outputWriter);
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        Model parsedOutput = this.parse(inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Model doubleBNodeStatement = parsedOutput.filter((Resource)this.uri1, this.uri1, null, new Resource[0]);
        Assert.assertEquals((long)1L, (long)doubleBNodeStatement.size());
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)(parsedOutput.contexts().iterator().next() instanceof BNode));
        }
        Assert.assertEquals((long)1L, (long)parsedOutput.objects().size());
        Assert.assertTrue((boolean)(parsedOutput.objects().iterator().next() instanceof BNode));
        Assert.assertTrue((boolean)(doubleBNodeStatement.objects().iterator().next() instanceof BNode));
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertEquals(doubleBNodeStatement.objects().iterator().next(), doubleBNodeStatement.contexts().iterator().next());
        }
    }

    @Test
    public void testWriteCommentURIContext() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentURIContextURI() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.uri1));
        rdfWriter.endRDF();
        System.out.println(outputWriter.toString());
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentBNodeContext() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
    }

    @Test
    public void testWriteCommentBNodeContextBNode() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.bnode));
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
    }

    @Test
    public void testWriteCommentURIContextWithNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentURIContextURIWithNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.uri1));
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentBNodeContextWithNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
    }

    @Test
    public void testWriteCommentBNodeContextBNodeWithNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.bnode));
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
    }

    @Test
    public void testWriteCommentURIContextBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentURIContextURIBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.uri1));
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentBNodeContextBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
    }

    @Test
    public void testWriteCommentBNodeContextBNodeBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.bnode));
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
    }

    @Test
    public void testWriteCommentURIContextWithNamespaceBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentURIContextURIWithNamespaceBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.uri1));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.uri1));
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        if (this.rdfWriterFactory.getRDFFormat().supportsContexts()) {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[]{this.uri1}));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[]{this.uri1}));
        } else {
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
            Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        }
    }

    @Test
    public void testWriteCommentBNodeContextWithNamespaceBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)1L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
    }

    @Test
    public void testWriteCommentBNodeContextBNodeWithNamespaceBeforeNamespace() throws Exception {
        ByteArrayOutputStream outputWriter = new ByteArrayOutputStream();
        RDFWriter rdfWriter = this.rdfWriterFactory.getWriter((OutputStream)outputWriter);
        this.setupWriterConfig(rdfWriter.getWriterConfig());
        rdfWriter.startRDF();
        rdfWriter.handleNamespace("ex", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri1, (Resource)this.bnode));
        rdfWriter.handleComment("This comment should not screw up parsing");
        rdfWriter.handleNamespace("ex1", this.exNs);
        rdfWriter.handleStatement(this.vf.createStatement((Resource)this.uri1, this.uri1, (Value)this.uri2, (Resource)this.bnode));
        rdfWriter.endRDF();
        ByteArrayInputStream inputReader = new ByteArrayInputStream(outputWriter.toByteArray());
        RDFParser rdfParser = this.rdfParserFactory.getParser();
        this.setupParserConfig(rdfParser.getParserConfig());
        LinkedHashModel parsedOutput = new LinkedHashModel();
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)parsedOutput));
        rdfParser.parse((InputStream)inputReader, "");
        Assert.assertEquals((long)2L, (long)parsedOutput.size());
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri1, new Resource[0]));
        Assert.assertTrue((boolean)parsedOutput.contains((Resource)this.uri1, this.uri1, (Value)this.uri2, new Resource[0]));
        Assert.assertEquals((long)1L, (long)parsedOutput.contexts().size());
    }
}

