/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.ParseErrorCollector;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParserHandlingTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BASE_URI = "urn:test:base:";
    private static final String UNKNOWN_DATATYPE_VALUE = "test unknown datatype literal value";
    private static final IRI UNKNOWN_DATATYPE_URI = SimpleValueFactory.getInstance().createIRI("urn:test:unknowndatatype");
    private static final String KNOWN_DATATYPE_VALUE = "31415926";
    private static final IRI KNOWN_DATATYPE_URI = XMLSchema.INTEGER;
    private static final String UNKNOWN_LANGUAGE_VALUE = "xsdfsawreaewraew";
    private static final String UNKNOWN_LANGUAGE_TAG = "fakelanguage123";
    private static final String KNOWN_LANGUAGE_VALUE = "G'day mate";
    private static final String KNOWN_LANGUAGE_TAG = "en-AU";
    private final ValueFactory vf = SimpleValueFactory.getInstance();
    private RDFParser testParser;
    private ParseErrorCollector testListener;
    private Model testStatements;

    protected abstract InputStream getUnknownDatatypeStream(Model var1) throws Exception;

    protected abstract InputStream getKnownDatatypeStream(Model var1) throws Exception;

    protected abstract InputStream getUnknownLanguageStream(Model var1) throws Exception;

    protected abstract InputStream getKnownLanguageStream(Model var1) throws Exception;

    protected abstract RDFParser getParser();

    @Before
    public void setUp() throws Exception {
        this.testParser = this.getParser();
        this.testParser.setValueFactory(this.vf);
        this.testListener = new ParseErrorCollector();
        this.testStatements = new LinkedHashModel();
        this.testParser.setParseErrorListener((ParseErrorListener)this.testListener);
        this.testParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)this.testStatements));
    }

    @After
    public void tearDown() throws Exception {
        this.testListener.reset();
        this.testListener = null;
        this.testStatements.clear();
        this.testStatements = null;
        this.testParser = null;
    }

    @Test
    public final void testUnknownDatatypeNoMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeNoMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeNoMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeNoMessageNoFailCase4() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeNoMessageNoFailCase5() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        this.testParser.getParserConfig().setNonFatalErrors(new HashSet());
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeWithMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 1, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeWithMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 1, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeWithMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        this.testParser.getParserConfig().setNonFatalErrors(Collections.singleton(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES));
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 1, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownDatatypeWithMessageWithFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_DATATYPE_VALUE, UNKNOWN_DATATYPE_URI);
        InputStream input = this.getUnknownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        try {
            this.testParser.parse(input, BASE_URI);
            Assert.fail((String)"Did not receive expected exception");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
        this.assertErrorListener(0, 1, 0);
        this.assertModel((Model)new LinkedHashModel());
    }

    @Test
    public final void testKnownDatatypeNoMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeNoMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeNoMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeNoMessageNoFailCase4() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeNoMessageNoFailCase5() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        this.testParser.getParserConfig().setNonFatalErrors(new HashSet());
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeWithMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeWithMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeWithMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        this.testParser.getParserConfig().setNonFatalErrors(Collections.singleton(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES));
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownDatatypeWithMessageWhereUnknownWouldFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_DATATYPE_VALUE, KNOWN_DATATYPE_URI);
        InputStream input = this.getKnownDatatypeStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageNoMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageNoMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageNoMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)false);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageNoMessageNoFailCase4() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)false);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageNoMessageNoFailCase5() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)false);
        this.testParser.getParserConfig().setNonFatalErrors(new HashSet());
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageWithMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 1, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageWithMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 1, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageWithMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.getParserConfig().setNonFatalErrors(Collections.singleton(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES));
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 1, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testUnknownLanguageWithMessageWithFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(UNKNOWN_LANGUAGE_VALUE, UNKNOWN_LANGUAGE_TAG);
        InputStream input = this.getUnknownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        try {
            this.testParser.parse(input, BASE_URI);
            Assert.fail((String)"Did not receive expected exception");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
        this.assertErrorListener(0, 1, 0);
        this.assertModel((Model)new LinkedHashModel());
    }

    @Test
    public final void testKnownLanguageNoMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageNoMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageNoMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)false);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageNoMessageNoFailCase4() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)false);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageNoMessageNoFailCase5() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)false);
        this.testParser.getParserConfig().setNonFatalErrors(new HashSet());
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageWithMessageNoFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageWithMessageNoFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().useDefaults();
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageWithMessageNoFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.getParserConfig().setNonFatalErrors(Collections.singleton(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES));
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageWithMessageWhereUnknownWouldFailCase1() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG);
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageWithMessageWhereUnknownWouldFailCase2() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG.toUpperCase(Locale.ENGLISH));
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    @Test
    public final void testKnownLanguageWithMessageWhereUnknownWouldFailCase3() throws Exception {
        Model expectedModel = this.getTestModel(KNOWN_LANGUAGE_VALUE, KNOWN_LANGUAGE_TAG.toLowerCase(Locale.ENGLISH));
        InputStream input = this.getKnownLanguageStream(expectedModel);
        this.testParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)true);
        this.testParser.parse(input, BASE_URI);
        this.assertErrorListener(0, 0, 0);
        this.assertModel(expectedModel);
    }

    private void assertModel(Model expectedModel) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Expected: {}", (Object)expectedModel);
            this.logger.trace("Actual: {}", (Object)this.testStatements);
        }
        Assert.assertTrue((String)"Did not find expected statements", (boolean)Models.isomorphic((Iterable)expectedModel, (Iterable)this.testStatements));
    }

    private void assertErrorListener(int expectedWarnings, int expectedErrors, int expectedFatalErrors) {
        Assert.assertEquals((String)"Unexpected number of fatal errors", (long)expectedFatalErrors, (long)this.testListener.getFatalErrors().size());
        Assert.assertEquals((String)"Unexpected number of errors", (long)expectedErrors, (long)this.testListener.getErrors().size());
        Assert.assertEquals((String)"Unexpected number of warnings", (long)expectedWarnings, (long)this.testListener.getWarnings().size());
    }

    private final Model getTestModel(String datatypeValue, IRI datatypeURI) {
        LinkedHashModel result = new LinkedHashModel();
        result.add((Object)this.vf.createStatement((Resource)this.vf.createBNode(), DC.DESCRIPTION, (Value)this.vf.createLiteral(datatypeValue, datatypeURI)));
        return result;
    }

    private final Model getTestModel(String languageValue, String languageTag) {
        LinkedHashModel result = new LinkedHashModel();
        result.add((Object)this.vf.createStatement((Resource)this.vf.createBNode(), RDFS.COMMENT, (Value)this.vf.createLiteral(languageValue, languageTag)));
        return result;
    }
}

