/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ndjsonld.legacy;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.BufferedGroupingRDFHandler;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.eclipse.rdf4j.rio.jsonld.legacy.JSONLDWriter;

public class NDJSONLDWriter
extends AbstractRDFWriter {
    private final BufferedGroupingRDFHandler bufferedGroupingRDFHandler;
    private final LinkedHashMap<String, String> namespacesBuffer = new LinkedHashMap();

    public NDJSONLDWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public NDJSONLDWriter(Writer writer) {
        this(writer, null);
    }

    public NDJSONLDWriter(OutputStream out, String baseURI) {
        this(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)), baseURI);
    }

    public NDJSONLDWriter(final Writer writer, final String baseURI) {
        this.bufferedGroupingRDFHandler = new BufferedGroupingRDFHandler(new RDFHandler[0]){

            protected void processBuffer() throws RDFHandlerException {
                for (Resource context : this.getBufferedStatements().contexts()) {
                    for (Resource subject : this.getBufferedStatements().subjects()) {
                        JSONLDWriter jsonldWriter = NDJSONLDWriter.this.getJsonldWriter(writer, baseURI);
                        Iterable statements = this.getBufferedStatements().getStatements(subject, null, null, new Resource[]{context});
                        jsonldWriter.startRDF();
                        for (String key : NDJSONLDWriter.this.namespacesBuffer.keySet()) {
                            jsonldWriter.handleNamespace(key, NDJSONLDWriter.this.namespacesBuffer.get(key));
                        }
                        for (Statement st : statements) {
                            jsonldWriter.handleStatement(st);
                        }
                        jsonldWriter.endRDF();
                        try {
                            jsonldWriter.getWriter().write(System.lineSeparator());
                        }
                        catch (IOException e) {
                            throw new RDFHandlerException((Throwable)e);
                        }
                    }
                }
                this.getBufferedStatements().clear();
            }
        };
    }

    private JSONLDWriter getJsonldWriter(Writer writer, String baseURI) {
        JSONLDWriter jsonldWriter = new JSONLDWriter(writer, baseURI);
        jsonldWriter.setWriterConfig(this.getWriterConfig());
        jsonldWriter.getWriterConfig().set((RioSetting)BasicWriterSettings.PRETTY_PRINT, (Object)false);
        return jsonldWriter;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.bufferedGroupingRDFHandler.handleStatement(st);
    }

    public void startRDF() throws RDFHandlerException {
        this.bufferedGroupingRDFHandler.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.bufferedGroupingRDFHandler.endRDF();
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespacesBuffer.put(prefix, uri);
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NDJSONLD;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(Arrays.asList(BasicWriterSettings.BASE_DIRECTIVE, JSONLDSettings.COMPACT_ARRAYS, JSONLDSettings.HIERARCHICAL_VIEW, JSONLDSettings.JSONLD_MODE, JSONLDSettings.PRODUCE_GENERALIZED_RDF, JSONLDSettings.USE_RDF_TYPE, JSONLDSettings.USE_NATIVE_TYPES));
        return result;
    }
}

