/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC16;
import org.eclipse.rdf4j.rio.hdt.HDTPart;

class HDTHeader
extends HDTPart {
    static final byte[] HEADER_FORMAT = "ntriples".getBytes(StandardCharsets.US_ASCII);
    static final String HEADER_LENGTH = "length";
    private byte[] headerData;

    HDTHeader() {
    }

    @Override
    void parse(InputStream is) throws IOException {
        try (UncloseableInputStream uis = new UncloseableInputStream(is);
             CheckedInputStream cis = new CheckedInputStream((InputStream)uis, new CRC16());){
            HDTHeader.checkControl(cis, HDTPart.Type.HEADER);
            HDTHeader.checkFormat(cis, HEADER_FORMAT);
            this.properties = HDTHeader.getProperties(cis);
            HDTHeader.checkCRC(cis, is, 2);
        }
        int hlen = this.getIntegerProperty(this.properties, HEADER_LENGTH, "Header length");
        this.headerData = this.parseHeaderData(is, hlen);
    }

    byte[] getHeaderData() {
        return this.headerData;
    }

    private byte[] parseHeaderData(InputStream is, int len) throws IOException {
        byte[] b = new byte[len];
        is.read(b);
        return b;
    }
}

