/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC16;
import org.eclipse.rdf4j.rio.hdt.HDTPart;

class HDTTriples
extends HDTPart {
    static final byte[] FORMAT_LIST = "<http://purl.org/HDT/hdt#triplesList>".getBytes(StandardCharsets.US_ASCII);
    static final byte[] FORMAT_BITMAP = "<http://purl.org/HDT/hdt#triplesBitmap>".getBytes(StandardCharsets.US_ASCII);
    static final String ORDER = "order";
    static final String NUM = "numTriples";
    private Order order;
    private int nrtriples;

    HDTTriples() {
    }

    Order getOrder() {
        return this.order;
    }

    @Override
    void parse(InputStream is) throws IOException {
        try (UncloseableInputStream uis = new UncloseableInputStream(is);
             CheckedInputStream cis = new CheckedInputStream((InputStream)uis, new CRC16());){
            HDTTriples.checkControl(cis, HDTPart.Type.TRIPLES);
            HDTTriples.checkFormat(cis, FORMAT_BITMAP);
            this.properties = HDTTriples.getProperties(cis);
            int i = this.getIntegerProperty(this.properties, ORDER, ORDER);
            if (i != Order.SPO.getValue()) {
                throw new UnsupportedOperationException("Triples section: order " + Integer.toString(i) + ", but only SPO order is supported");
            }
            HDTTriples.checkCRC(cis, is, 2);
        }
    }

    static enum Order {
        UNKNOWN(0),
        SPO(1),
        SOP(2),
        PSO(3),
        POS(4),
        OSP(5),
        OPS(6);

        private final int value;

        int getValue() {
            return this.value;
        }

        private Order(int value) {
            this.value = value;
        }
    }
}

