/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC16;
import org.eclipse.rdf4j.rio.hdt.HDTPart;

class HDTDictionary
extends HDTPart {
    static final byte[] DICT_FORMAT = "<http://purl.org/HDT/hdt#dictionaryFour>".getBytes(StandardCharsets.US_ASCII);
    static final String DICT_MAPPING = "mapping";
    static final String DICT_ELEMENTS = "elements";

    HDTDictionary() {
    }

    @Override
    void parse(InputStream is) throws IOException {
        try (UncloseableInputStream uis = new UncloseableInputStream(is);
             CheckedInputStream cis = new CheckedInputStream((InputStream)uis, new CRC16());){
            HDTDictionary.checkControl(cis, HDTPart.Type.DICTIONARY);
            HDTDictionary.checkFormat(cis, DICT_FORMAT);
            this.properties = HDTDictionary.getProperties(cis);
            HDTDictionary.checkCRC(cis, is, 2);
        }
    }
}

