/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC32;
import org.eclipse.rdf4j.rio.hdt.CRC8;
import org.eclipse.rdf4j.rio.hdt.HDTPart;
import org.eclipse.rdf4j.rio.hdt.VByte;

class HDTBitmap
extends HDTPart {
    protected static final int BITMAP1 = 1;
    private int bits;
    private byte[] buffer;

    HDTBitmap() {
    }

    protected int get(int i) {
        int bytePos = i / 8;
        int bitPos = i % 8;
        byte b = this.buffer[bytePos];
        return (b & 0xFF) >> bitPos & 1;
    }

    protected int size() {
        return this.bits;
    }

    @Override
    protected void parse(InputStream is) throws IOException {
        long bytes;
        CheckedInputStream cis;
        try (UncloseableInputStream uis = new UncloseableInputStream(is);){
            cis = new CheckedInputStream((InputStream)uis, new CRC8());
            try {
                int dtype = cis.read();
                if (dtype != 1) {
                    throw new UnsupportedOperationException("Bitmap encoding " + Long.toHexString(dtype) + ", but only bitmap v1 is supported");
                }
                long b = (int)VByte.decode(cis);
                if (b > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Maximum number of entries in bitmap exceeded: " + b);
                }
                this.bits = (int)b;
                bytes = (this.bits + 7) / 8;
                HDTBitmap.checkCRC(cis, is, 1);
            }
            finally {
                cis.close();
            }
        }
        uis = new UncloseableInputStream(is);
        try {
            cis = new CheckedInputStream((InputStream)uis, new CRC32());
            try {
                this.buffer = new byte[(int)bytes];
                cis.read(this.buffer);
                HDTBitmap.checkCRC(cis, is, 4);
            }
            finally {
                cis.close();
            }
        }
        finally {
            uis.close();
        }
    }
}

