/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;

public class VByte {
    public static boolean hasNext(byte b) {
        return (b & 0xFF) < 128;
    }

    public static long decode(byte[] bytes, int len) {
        if (len > 8 || bytes.length < len) {
            throw new IllegalArgumentException("Buffer too long, or incorrect length");
        }
        long val = 0L;
        for (int i = len - 1; i >= 0; --i) {
            val <<= 7;
            val |= (long)(bytes[i] & 0x7F);
        }
        return val;
    }

    public static long decode(InputStream is) throws IOException {
        byte[] buffer = new byte[8];
        int i = 0;
        do {
            buffer[i] = (byte)is.read();
        } while (i < buffer.length && VByte.hasNext(buffer[i++]));
        return VByte.decode(buffer, i);
    }

    public static long decodeFrom(byte[] b, int start) throws IOException {
        byte[] buffer = new byte[8];
        int i = 0;
        do {
            buffer[i] = b[start + i];
        } while (i < buffer.length && VByte.hasNext(buffer[i++]));
        return VByte.decode(buffer, i);
    }

    public static int encodedLength(long value) {
        if (value < 127L) {
            return 1;
        }
        if (value < 16384L) {
            return 2;
        }
        if (value < 0x200000L) {
            return 3;
        }
        if (value < 0x10000000L) {
            return 4;
        }
        return 5;
    }
}

