/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CheckedInputStream;

abstract class HDTPart {
    protected static final byte[] COOKIE = "$HDT".getBytes(StandardCharsets.US_ASCII);
    private static final int BUFLEN = 0x100000;
    protected final String name;
    protected final long pos;
    protected Map<String, String> properties;

    protected abstract void parse(InputStream var1) throws IOException;

    protected Map<String, String> getProperties() {
        return this.properties;
    }

    protected HDTPart(String name, long pos) {
        this.name = name;
        this.pos = pos;
    }

    protected HDTPart() {
        this("", -1L);
    }

    protected String getDebugPartStr() {
        if (this.name == null || this.name.isEmpty()) {
            return "";
        }
        return this.pos != -1L ? this.name + " (starts at byte " + this.pos + ")" : this.name;
    }

    protected static void checkControl(InputStream is, Type ctype) throws IOException {
        byte[] cookie = new byte[COOKIE.length];
        is.read(cookie);
        if (!Arrays.equals(cookie, COOKIE)) {
            throw new IOException("$HDT marker not found");
        }
        byte b = (byte)is.read();
        if (b != ctype.getValue()) {
            throw new IOException("Info type " + Long.toHexString(b) + ", but expected different control info type");
        }
    }

    protected static void checkFormat(InputStream is, byte[] format) throws IOException {
        byte[] b = new byte[format.length];
        is.read(b);
        if (!Arrays.equals(b, format)) {
            throw new IOException("Unknown format, expected " + new String(format, StandardCharsets.US_ASCII));
        }
        is.read();
    }

    protected static byte[] readToNull(InputStream is) throws IOException {
        byte[] buf = new byte[0x100000];
        int len = 0;
        do {
            buf[len] = (byte)is.read();
        } while (buf[len] != 0 && ++len < 0x100000);
        if (len == 0x100000) {
            throw new IOException("Buffer for reading properties exceeded, max 1048576");
        }
        return Arrays.copyOf(buf, len);
    }

    protected static int countToNull(byte[] b, int start) throws IOException {
        for (int i = start; i < b.length; ++i) {
            if (b[i] != 0) continue;
            return i;
        }
        throw new IOException("No null byte found in buffer starting at byte " + start);
    }

    protected static Map<String, String> getProperties(InputStream is) throws IOException {
        return HDTPart.mapProperties(HDTPart.readToNull(is));
    }

    protected static Map<String, String> mapProperties(byte[] props) {
        String[] strs;
        HashMap<String, String> map = new HashMap<String, String>();
        if (props == null || props.length == 0) {
            return map;
        }
        for (String str : strs = new String(props, 0, props.length, StandardCharsets.US_ASCII).split(";")) {
            String[] prop = str.split("=");
            if (prop.length != 2) continue;
            map.put(prop[0], prop[1]);
        }
        return map;
    }

    protected int getIntegerProperty(Map<String, String> props, String prop, String name) throws IOException {
        int len = 0;
        String str = props.getOrDefault(prop, "0");
        try {
            len = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(name + " is not an integer: " + str);
        }
        if (len < 1) {
            throw new IOException(name + " is less than 1: " + len);
        }
        return len;
    }

    protected static void checkCRC(CheckedInputStream cis, InputStream is, int len) throws IOException {
        long calc = cis.getChecksum().getValue();
        byte[] checksum = new byte[len];
        is.read(checksum);
        long expect = 0L;
        for (int i = len - 1; i >= 0; --i) {
            expect <<= 8;
            expect |= (long)(checksum[i] & 0xFF);
        }
        if (calc != expect) {
            throw new IOException("CRC does not match: calculated " + Long.toHexString(calc) + " instead of " + Long.toHexString(expect));
        }
    }

    protected static enum Type {
        GLOBAL(1),
        HEADER(2),
        DICTIONARY(3),
        TRIPLES(4);

        private final byte value;

        protected byte getValue() {
            return this.value;
        }

        private Type(byte value) {
            this.value = value;
        }
    }
}

