/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.util.Namespaces;
import org.eclipse.rdf4j.rio.DatatypeHandler;
import org.eclipse.rdf4j.rio.DatatypeHandlerRegistry;
import org.eclipse.rdf4j.rio.LanguageHandler;
import org.eclipse.rdf4j.rio.LanguageHandlerRegistry;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BooleanRioSetting;
import org.eclipse.rdf4j.rio.helpers.LargeLiteralHandling;
import org.eclipse.rdf4j.rio.helpers.LongRioSetting;
import org.eclipse.rdf4j.rio.helpers.RioSettingImpl;
import org.eclipse.rdf4j.rio.helpers.StringRioSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicParserSettings {
    private static final Logger log = LoggerFactory.getLogger(BasicParserSettings.class);
    public static final RioSetting<Boolean> VERIFY_DATATYPE_VALUES = new BooleanRioSetting("org.eclipse.rdf4j.rio.verify_datatype_values", "Verify recognised datatype values", Boolean.FALSE);
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_DATATYPES = new BooleanRioSetting("org.eclipse.rdf4j.rio.fail_on_unknown_datatypes", "Fail on unknown datatypes", Boolean.FALSE);
    public static final RioSetting<Boolean> NORMALIZE_DATATYPE_VALUES = new BooleanRioSetting("org.eclipse.rdf4j.rio.normalize_datatype_values", "Normalize recognised datatype values", Boolean.FALSE);
    public static final RioSetting<List<DatatypeHandler>> DATATYPE_HANDLERS;
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_LANGUAGES;
    public static final RioSetting<Boolean> VERIFY_LANGUAGE_TAGS;
    public static final RioSetting<Boolean> NORMALIZE_LANGUAGE_TAGS;
    public static final RioSetting<List<LanguageHandler>> LANGUAGE_HANDLERS;
    public static final RioSetting<Boolean> VERIFY_RELATIVE_URIS;
    public static final RioSetting<Boolean> VERIFY_URI_SYNTAX;
    public static final RioSetting<Boolean> PRESERVE_BNODE_IDS;
    public static final RioSetting<String> SKOLEMIZE_ORIGIN;
    public static final RioSetting<LargeLiteralHandling> LARGE_LITERALS_HANDLING;
    public static final RioSetting<Long> LARGE_LITERALS_LIMIT;
    public static final RioSetting<Set<Namespace>> NAMESPACES;
    public static final RioSetting<Boolean> PROCESS_ENCODED_RDF_STAR;

    private BasicParserSettings() {
    }

    static {
        FAIL_ON_UNKNOWN_LANGUAGES = new BooleanRioSetting("org.eclipse.rdf4j.rio.fail_on_unknown_languages", "Fail on unknown languages", Boolean.FALSE);
        VERIFY_LANGUAGE_TAGS = new BooleanRioSetting("org.eclipse.rdf4j.rio.verify_language_tags", "Verify language tags", Boolean.TRUE);
        NORMALIZE_LANGUAGE_TAGS = new BooleanRioSetting("org.eclipse.rdf4j.rio.normalize_language_tags", "Normalize recognised language tags", Boolean.FALSE);
        VERIFY_RELATIVE_URIS = new BooleanRioSetting("org.eclipse.rdf4j.rio.verify_relative_uris", "Verify relative URIs", Boolean.TRUE);
        VERIFY_URI_SYNTAX = new BooleanRioSetting("org.eclipse.rdf4j.rio.verify_uri_syntax", "Verify URI syntax", Boolean.TRUE);
        PRESERVE_BNODE_IDS = new BooleanRioSetting("org.eclipse.rdf4j.rio.preserve_bnode_ids", "Preserve blank node identifiers", Boolean.FALSE);
        SKOLEMIZE_ORIGIN = new StringRioSetting("org.eclipse.rdf4j.rio.skolem_origin", "Replace blank nodes with well known genid IRIs using this scheme and authority", null);
        LARGE_LITERALS_HANDLING = new RioSettingImpl<LargeLiteralHandling>("org.eclipse.rdf4j.rio.large_literals", "Large literals handling", LargeLiteralHandling.PRESERVE);
        LARGE_LITERALS_LIMIT = new LongRioSetting("org.eclipse.rdf4j.rio.large_literals_limit", "Size limit for large literals", 0x100000L);
        NAMESPACES = new RioSettingImpl<Set>("org.eclipse.rdf4j.rio.namespaces", "Collection of default namespaces to use for parsing", Namespaces.DEFAULT_RDF4J);
        PROCESS_ENCODED_RDF_STAR = new BooleanRioSetting("org.eclipse.rdf4j.rio.process_encoded_rdf_star", "Converts RDF-star triples encoded as RDF-compatible IRIs back to triple values", Boolean.TRUE);
        ArrayList<DatatypeHandler> defaultDatatypeHandlers = new ArrayList<DatatypeHandler>(5);
        try {
            DatatypeHandlerRegistry registry = DatatypeHandlerRegistry.getInstance();
            for (String nextDatatype : Arrays.asList("org.eclipse.rdf4j.rio.datatypes.xmlschema", "org.eclipse.rdf4j.rio.datatypes.rdf", "org.eclipse.rdf4j.rio.datatypes.dbpedia", "org.eclipse.rdf4j.rio.datatypes.virtuosogeometry", "org.eclipse.rdf4j.rio.datatypes.geosparql")) {
                Optional nextDatatypeHandler = registry.get(nextDatatype);
                if (nextDatatypeHandler.isPresent()) {
                    defaultDatatypeHandlers.add((DatatypeHandler)nextDatatypeHandler.get());
                    continue;
                }
                log.warn("Could not find DatatypeHandler : {}", (Object)nextDatatype);
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading DatatypeHandler services", (Throwable)e);
        }
        DATATYPE_HANDLERS = new RioSettingImpl("org.eclipse.rdf4j.rio.datatype_handlers", "Datatype Handlers", Collections.unmodifiableList(defaultDatatypeHandlers));
        ArrayList<LanguageHandler> defaultLanguageHandlers = new ArrayList<LanguageHandler>(1);
        try {
            LanguageHandlerRegistry registry = LanguageHandlerRegistry.getInstance();
            String nextLanguageTagScheme = "org.eclipse.rdf4j.rio.languages.BCP47";
            if (registry.has(nextLanguageTagScheme)) {
                Optional nextLanguageHandler = registry.get(nextLanguageTagScheme);
                if (nextLanguageHandler.isPresent()) {
                    defaultLanguageHandlers.add((LanguageHandler)nextLanguageHandler.get());
                } else {
                    log.warn("Could not find LanguageHandler : {}", (Object)nextLanguageTagScheme);
                }
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading LanguageHandler services", (Throwable)e);
        }
        LANGUAGE_HANDLERS = new RioSettingImpl("org.eclipse.rdf4j.rio.language_handlers", "Language Handlers", Collections.unmodifiableList(defaultLanguageHandlers));
    }
}

