/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.DatatypeHandler;
import org.eclipse.rdf4j.rio.LanguageHandler;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class RDFParserHelper {
    public static final Literal createLiteral(String label, String lang, IRI datatype, ParserConfig parserConfig, ParseErrorListener errListener, ValueFactory valueFactory) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, parserConfig, errListener, valueFactory, -1L, -1L);
    }

    public static final Literal createLiteral(String label, String lang, IRI datatype, ParserConfig parserConfig, ParseErrorListener errListener, ValueFactory valueFactory, long lineNo, long columnNo) throws RDFParseException {
        if (label == null) {
            throw new NullPointerException("Cannot create a literal using a null label");
        }
        Literal result = null;
        String workingLabel = label;
        Optional workingLang = Optional.ofNullable(lang);
        IRI workingDatatype = datatype;
        if (workingLang.isPresent() && (workingDatatype == null || RDF.LANGSTRING.equals((Object)workingDatatype))) {
            boolean recognisedLanguage = false;
            for (LanguageHandler nextHandler : parserConfig.get(BasicParserSettings.LANGUAGE_HANDLERS)) {
                if (!nextHandler.isRecognizedLanguage(workingLang.get())) continue;
                recognisedLanguage = true;
                if (parserConfig.get(BasicParserSettings.VERIFY_LANGUAGE_TAGS).booleanValue()) {
                    try {
                        if (!nextHandler.verifyLanguage(workingLabel, workingLang.get())) {
                            RDFParserHelper.reportError("'" + lang + "' is not a valid language tag ", lineNo, columnNo, BasicParserSettings.VERIFY_LANGUAGE_TAGS, parserConfig, errListener);
                        }
                    }
                    catch (LiteralUtilException e) {
                        RDFParserHelper.reportError("'" + label + " could not be verified by a language handler that recognised it. language was " + lang, lineNo, columnNo, BasicParserSettings.VERIFY_LANGUAGE_TAGS, parserConfig, errListener);
                    }
                }
                if (!parserConfig.get(BasicParserSettings.NORMALIZE_LANGUAGE_TAGS).booleanValue()) continue;
                try {
                    result = nextHandler.normalizeLanguage(workingLabel, workingLang.get(), valueFactory);
                    workingLabel = result.getLabel();
                    workingLang = result.getLanguage();
                    workingDatatype = result.getDatatype();
                }
                catch (LiteralUtilException e) {
                    RDFParserHelper.reportError("'" + label + "' did not have a valid value for language " + lang + ": " + e.getMessage() + " and could not be normalised", lineNo, columnNo, BasicParserSettings.NORMALIZE_LANGUAGE_TAGS, parserConfig, errListener);
                }
            }
            if (!recognisedLanguage) {
                RDFParserHelper.reportError("'" + label + "' was not recognised as a language literal, and could not be verified, with language " + lang, lineNo, columnNo, BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, parserConfig, errListener);
            }
        } else if (workingDatatype != null) {
            boolean recognisedDatatype = false;
            for (DatatypeHandler nextHandler : parserConfig.get(BasicParserSettings.DATATYPE_HANDLERS)) {
                if (!nextHandler.isRecognizedDatatype(workingDatatype)) continue;
                recognisedDatatype = true;
                if (parserConfig.get(BasicParserSettings.VERIFY_DATATYPE_VALUES).booleanValue()) {
                    try {
                        if (!nextHandler.verifyDatatype(workingLabel, workingDatatype)) {
                            RDFParserHelper.reportError("'" + label + "' is not a valid value for datatype " + datatype, lineNo, columnNo, BasicParserSettings.VERIFY_DATATYPE_VALUES, parserConfig, errListener);
                        }
                    }
                    catch (LiteralUtilException e) {
                        RDFParserHelper.reportError("'" + label + " could not be verified by a datatype handler that recognised it. datatype was " + datatype, lineNo, columnNo, BasicParserSettings.VERIFY_DATATYPE_VALUES, parserConfig, errListener);
                    }
                }
                if (!parserConfig.get(BasicParserSettings.NORMALIZE_DATATYPE_VALUES).booleanValue()) continue;
                try {
                    result = nextHandler.normalizeDatatype(workingLabel, workingDatatype, valueFactory);
                    workingLabel = result.getLabel();
                    workingLang = result.getLanguage();
                    workingDatatype = result.getDatatype();
                }
                catch (LiteralUtilException e) {
                    RDFParserHelper.reportError("'" + label + "' is not a valid value for datatype " + datatype + ": " + e.getMessage() + " and could not be normalised", lineNo, columnNo, BasicParserSettings.NORMALIZE_DATATYPE_VALUES, parserConfig, errListener);
                }
            }
            if (!recognisedDatatype) {
                RDFParserHelper.reportError("'" + label + "' was not recognised, and could not be verified, with datatype " + datatype, lineNo, columnNo, BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, parserConfig, errListener);
            }
        }
        if (result == null) {
            try {
                if (!(workingDatatype != null && !RDF.LANGSTRING.equals((Object)workingDatatype) || workingLang.isPresent() && !workingLang.get().isEmpty() || parserConfig.get(BasicParserSettings.VERIFY_DATATYPE_VALUES).booleanValue())) {
                    workingLang = Optional.ofNullable(null);
                    workingDatatype = null;
                }
                result = workingLang.isPresent() && (workingDatatype == null || RDF.LANGSTRING.equals((Object)workingDatatype)) ? valueFactory.createLiteral(workingLabel, workingLang.get().intern()) : (workingDatatype != null ? valueFactory.createLiteral(workingLabel, workingDatatype) : valueFactory.createLiteral(workingLabel, XMLSchema.STRING));
            }
            catch (Exception e) {
                RDFParserHelper.reportFatalError(e, lineNo, columnNo, errListener);
            }
        }
        return result;
    }

    public static void reportError(String msg, RioSetting<Boolean> relevantSetting, ParserConfig parserConfig, ParseErrorListener errListener) throws RDFParseException {
        RDFParserHelper.reportError(msg, -1L, -1L, relevantSetting, parserConfig, errListener);
    }

    public static void reportError(String msg, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting, ParserConfig parserConfig, ParseErrorListener errListener) throws RDFParseException {
        if (parserConfig.get(relevantSetting).booleanValue()) {
            if (errListener != null) {
                errListener.error(msg, lineNo, columnNo);
            }
            if (!parserConfig.isNonFatalError(relevantSetting)) {
                throw new RDFParseException(msg, lineNo, columnNo);
            }
        }
    }

    public static void reportError(Exception e, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting, ParserConfig parserConfig, ParseErrorListener errListener) throws RDFParseException {
        if (parserConfig.get(relevantSetting).booleanValue()) {
            if (errListener != null) {
                errListener.error(e.getMessage(), lineNo, columnNo);
            }
            if (!parserConfig.isNonFatalError(relevantSetting)) {
                if (e instanceof RDFParseException) {
                    throw (RDFParseException)((Object)e);
                }
                throw new RDFParseException(e, lineNo, columnNo);
            }
        }
    }

    public static void reportFatalError(String msg, ParseErrorListener errListener) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, -1L, -1L, errListener);
    }

    public static void reportFatalError(String msg, long lineNo, long columnNo, ParseErrorListener errListener) throws RDFParseException {
        if (errListener != null) {
            errListener.fatalError(msg, lineNo, columnNo);
        }
        throw new RDFParseException(msg, lineNo, columnNo);
    }

    public static void reportFatalError(Exception e, ParseErrorListener errListener) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, -1L, -1L, errListener);
    }

    public static void reportFatalError(Exception e, long lineNo, long columnNo, ParseErrorListener errListener) throws RDFParseException {
        if (e instanceof RDFParseException) {
            throw (RDFParseException)((Object)e);
        }
        if (errListener != null) {
            errListener.fatalError(e.getMessage(), lineNo, columnNo);
        }
        throw new RDFParseException(e, lineNo, columnNo);
    }

    public static void reportFatalError(String message, Exception e, long lineNo, long columnNo, ParseErrorListener errListener) throws RDFParseException {
        if (e instanceof RDFParseException) {
            throw (RDFParseException)((Object)e);
        }
        if (errListener != null) {
            errListener.fatalError(message, lineNo, columnNo);
        }
        throw new RDFParseException(message, e, lineNo, columnNo);
    }

    protected RDFParserHelper() {
    }
}

