/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.query;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SparqlSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.query.QueryStringUtil;

public class SPARQLTupleQuery
extends AbstractHTTPQuery
implements TupleQuery {
    public SPARQLTupleQuery(SparqlSession httpClient, String baseUri, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseUri);
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        SparqlSession client = this.getHttpClient();
        try {
            return client.sendTupleQuery(QueryLanguage.SPARQL, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        SparqlSession client = this.getHttpClient();
        try {
            client.sendTupleQuery(QueryLanguage.SPARQL, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
    }

    private String getQueryString() {
        return QueryStringUtil.getQueryString(this.queryString, this.getBindings());
    }
}

