/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.SesameClient;
import org.eclipse.rdf4j.http.client.SesameClientDependent;
import org.eclipse.rdf4j.http.client.SesameClientImpl;
import org.eclipse.rdf4j.http.client.SparqlSession;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.sparql.SPARQLConnection;

public class SPARQLRepository
extends AbstractRepository
implements HttpClientDependent,
SesameClientDependent {
    private boolean quadMode = false;
    private SesameClient client;
    private SesameClientImpl dependentClient;
    private String username;
    private String password;
    private String queryEndpointUrl;
    private String updateEndpointUrl;
    private Map<String, String> additionalHttpHeaders = Collections.emptyMap();

    public SPARQLRepository(String endpointUrl) {
        this(endpointUrl, endpointUrl);
    }

    public SPARQLRepository(String queryEndpointUrl, String updateEndpointUrl) {
        if (queryEndpointUrl == null || updateEndpointUrl == null) {
            throw new IllegalArgumentException("endpoint URL may not be null.");
        }
        this.queryEndpointUrl = queryEndpointUrl;
        this.updateEndpointUrl = updateEndpointUrl;
    }

    public synchronized SesameClient getSesameClient() {
        if (this.client == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        return this.client;
    }

    public synchronized void setSesameClient(SesameClient client) {
        this.client = client;
    }

    public final HttpClient getHttpClient() {
        return this.getSesameClient().getHttpClient();
    }

    public void setHttpClient(HttpClient httpClient) {
        if (this.dependentClient == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        this.dependentClient.setHttpClient(httpClient);
    }

    protected SparqlSession createHTTPClient() {
        SparqlSession httpClient = this.getSesameClient().createSparqlSession(this.queryEndpointUrl, this.updateEndpointUrl);
        httpClient.setValueFactory((ValueFactory)SimpleValueFactory.getInstance());
        httpClient.setPreferredTupleQueryResultFormat(TupleQueryResultFormat.SPARQL);
        httpClient.setAdditionalHttpHeaders(this.additionalHttpHeaders);
        if (this.username != null) {
            httpClient.setUsernameAndPassword(this.username, this.password);
        }
        return httpClient;
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (!this.isInitialized()) {
            throw new RepositoryException("SPARQLRepository not initialized.");
        }
        return new SPARQLConnection(this, this.createHTTPClient(), this.quadMode);
    }

    public File getDataDir() {
        return null;
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    protected void initializeInternal() throws RepositoryException {
    }

    public boolean isWritable() throws RepositoryException {
        return false;
    }

    public void setDataDir(File dataDir) {
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected void shutDownInternal() throws RepositoryException {
        if (this.dependentClient != null) {
            this.dependentClient.shutDown();
            this.dependentClient = null;
        }
        this.client = null;
    }

    public String toString() {
        return this.queryEndpointUrl;
    }

    public Map<String, String> getAdditionalHttpHeaders() {
        return Collections.unmodifiableMap(this.additionalHttpHeaders);
    }

    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders == null ? Collections.emptyMap() : additionalHttpHeaders;
    }

    public void enableQuadMode(boolean flag) {
        this.quadMode = flag;
    }
}

