/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPUpdate;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepositoryConnection;
import org.eclipse.rdf4j.repository.http.HTTPUpdateExecutionException;

public class HTTPUpdate
extends AbstractHTTPUpdate {
    private final HTTPRepositoryConnection httpCon;

    public HTTPUpdate(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super((SPARQLProtocolSession)con.getSesameSession(), ql, queryString, baseURI);
        this.httpCon = con;
    }

    public void execute() throws UpdateExecutionException {
        try {
            if (this.httpCon.getRepository().useCompatibleMode()) {
                if (this.httpCon.isAutoCommit()) {
                    SPARQLProtocolSession client = this.getHttpClient();
                    try {
                        client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getMaxExecutionTime(), this.getBindingsArray());
                    }
                    catch (IOException | UnauthorizedException | MalformedQueryException | QueryInterruptedException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                } else {
                    this.httpCon.scheduleUpdate(this);
                }
                return;
            }
            SPARQLProtocolSession client = this.getHttpClient();
            try {
                this.httpCon.flushTransactionState(Protocol.Action.UPDATE);
                client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getMaxExecutionTime(), this.getBindingsArray());
            }
            catch (IOException | UnauthorizedException | MalformedQueryException | QueryInterruptedException e) {
                throw new HTTPUpdateExecutionException(e.getMessage(), e);
            }
        }
        catch (RepositoryException e) {
            throw new HTTPUpdateExecutionException(e.getMessage(), e);
        }
    }
}

