/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigTemplate {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\{%[\\p{Print}&&[^\\}]]+%\\}");
    private String template;
    private final Map<String, List<String>> variableMap = new LinkedHashMap<String, List<String>>();
    private final Map<String, String> multilineMap = new LinkedHashMap<String, String>();

    public ConfigTemplate(String template) {
        this.setTemplate(template);
    }

    public String getTemplate() {
        return this.template;
    }

    public final void setTemplate(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template must not be null");
        }
        this.template = template;
        this.parseTemplate();
    }

    private void parseTemplate() {
        Matcher matcher = TOKEN_PATTERN.matcher(this.template);
        while (matcher.find()) {
            String group = matcher.group();
            String[] tokensArray = group.substring(2, group.length() - 2).split("\\|");
            List<String> tokens = Arrays.asList(tokensArray);
            String var = tokens.get(0).trim();
            if (var.length() == 0) {
                throw new IllegalArgumentException("Illegal template token: " + matcher.group());
            }
            if (this.variableMap.containsKey(var)) continue;
            this.variableMap.put(var, tokens.subList(1, tokens.size()));
            int start = matcher.start();
            String before = this.template.substring(start - 3, start);
            int end = matcher.end();
            if (!"'''".equals(before) && !"\"\"\"".equals(before) || !before.equals(this.template.substring(end, end + 3))) continue;
            this.multilineMap.put(var, before);
        }
    }

    public Map<String, List<String>> getVariableMap() {
        return Collections.unmodifiableMap(this.variableMap);
    }

    public String render(Map<String, String> valueMap) {
        StringBuffer result = new StringBuffer(this.template.length());
        Matcher matcher = TOKEN_PATTERN.matcher(this.template);
        while (matcher.find()) {
            String group = matcher.group();
            String[] tokensArray = group.substring(2, group.length() - 2).split("\\|");
            String var = tokensArray[0].trim();
            String value = valueMap.get(var);
            if (value == null) {
                List<String> values = this.variableMap.get(var);
                String string = value = values.isEmpty() ? "" : values.get(0);
            }
            if (!value.isEmpty() && this.multilineMap.containsKey(var)) {
                value = ConfigTemplate.escapeMultilineQuotes(this.multilineMap.get(var), value);
            }
            matcher.appendReplacement(result, value);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    protected static String escapeMultilineQuotes(String quoteVariant, String value) {
        if ("'''".equals(quoteVariant) || "\"\"\"".equals(quoteVariant)) {
            return value.replace(quoteVariant, new String(new char[3]).replace("\u0000", "\\" + quoteVariant.charAt(0)));
        }
        throw new IllegalArgumentException("Only a valid Turtle multi-line quote delmiter is allowed.");
    }

    public Map<String, String> getMultilineMap() {
        return Collections.unmodifiableMap(this.multilineMap);
    }
}

