/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;

public interface RepositoryConnection
extends AutoCloseable {
    public Repository getRepository();

    public void setParserConfig(ParserConfig var1);

    public ParserConfig getParserConfig();

    public ValueFactory getValueFactory();

    public boolean isOpen() throws RepositoryException;

    @Override
    public void close() throws RepositoryException;

    public Query prepareQuery(String var1) throws RepositoryException, MalformedQueryException;

    public Query prepareQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public Query prepareQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public TupleQuery prepareTupleQuery(String var1) throws RepositoryException, MalformedQueryException;

    public TupleQuery prepareTupleQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public TupleQuery prepareTupleQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public GraphQuery prepareGraphQuery(String var1) throws RepositoryException, MalformedQueryException;

    public GraphQuery prepareGraphQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public GraphQuery prepareGraphQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public BooleanQuery prepareBooleanQuery(String var1) throws RepositoryException, MalformedQueryException;

    public BooleanQuery prepareBooleanQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public BooleanQuery prepareBooleanQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public Update prepareUpdate(String var1) throws RepositoryException, MalformedQueryException;

    public Update prepareUpdate(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public Update prepareUpdate(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException;

    public RepositoryResult<Statement> getStatements(Resource var1, IRI var2, Value var3, Resource ... var4) throws RepositoryException;

    @Deprecated
    public RepositoryResult<Statement> getStatements(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    public RepositoryResult<Statement> getStatements(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    public boolean hasStatement(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    @Deprecated
    public boolean hasStatement(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    public boolean hasStatement(Statement var1, boolean var2, Resource ... var3) throws RepositoryException;

    public void exportStatements(Resource var1, IRI var2, Value var3, boolean var4, RDFHandler var5, Resource ... var6) throws RepositoryException, RDFHandlerException;

    public void export(RDFHandler var1, Resource ... var2) throws RepositoryException, RDFHandlerException;

    public long size(Resource ... var1) throws RepositoryException;

    public boolean isEmpty() throws RepositoryException;

    @Deprecated
    public void setAutoCommit(boolean var1) throws RepositoryException;

    @Deprecated
    public boolean isAutoCommit() throws RepositoryException;

    public boolean isActive() throws UnknownTransactionStateException, RepositoryException;

    public void setIsolationLevel(IsolationLevel var1) throws IllegalStateException;

    public IsolationLevel getIsolationLevel();

    public void begin() throws RepositoryException;

    public void begin(IsolationLevel var1) throws RepositoryException;

    public void commit() throws RepositoryException;

    public void rollback() throws RepositoryException;

    public void add(InputStream var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(Reader var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(URL var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(File var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(Resource var1, IRI var2, Value var3, Resource ... var4) throws RepositoryException;

    @Deprecated
    public void add(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;

    public void add(Statement var1, Resource ... var2) throws RepositoryException;

    public void add(Iterable<? extends Statement> var1, Resource ... var2) throws RepositoryException;

    public <E extends Exception> void add(Iteration<? extends Statement, E> var1, Resource ... var2) throws RepositoryException, E;

    public void remove(Resource var1, IRI var2, Value var3, Resource ... var4) throws RepositoryException;

    @Deprecated
    public void remove(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;

    public void remove(Statement var1, Resource ... var2) throws RepositoryException;

    public void remove(Iterable<? extends Statement> var1, Resource ... var2) throws RepositoryException;

    public <E extends Exception> void remove(Iteration<? extends Statement, E> var1, Resource ... var2) throws RepositoryException, E;

    public void clear(Resource ... var1) throws RepositoryException;

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException;

    public String getNamespace(String var1) throws RepositoryException;

    public void setNamespace(String var1, String var2) throws RepositoryException;

    public void removeNamespace(String var1) throws RepositoryException;

    public void clearNamespaces() throws RepositoryException;
}

