/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.csv;

import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.AbstractTupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;

public class SPARQLResultsCSVParser
extends AbstractTupleQueryResultParser
implements TupleQueryResultParser {
    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.CSV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        List<String> bindingNames = null;
        try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(in, Charset.forName("UTF-8")));){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null) {
                if (bindingNames == null) {
                    bindingNames = Arrays.asList(nextLine);
                    if (this.handler == null) continue;
                    this.handler.startQueryResult(bindingNames);
                    continue;
                }
                ArrayList<BNode> values = new ArrayList<BNode>();
                for (String valueString : nextLine) {
                    BNode v = null;
                    if (valueString.startsWith("_:")) {
                        v = this.valueFactory.createBNode(valueString.substring(2));
                    } else if (!"".equals(valueString)) {
                        if (valueString.matches("^[\\+\\-]?[\\d\\.].*")) {
                            IRI datatype = null;
                            if (XMLDatatypeUtil.isValidInteger((String)valueString)) {
                                datatype = XMLDatatypeUtil.isValidNegativeInteger((String)valueString) ? XMLSchema.NEGATIVE_INTEGER : XMLSchema.INTEGER;
                            } else if (XMLDatatypeUtil.isValidDecimal((String)valueString)) {
                                datatype = XMLSchema.DECIMAL;
                            } else if (XMLDatatypeUtil.isValidDouble((String)valueString)) {
                                datatype = XMLSchema.DOUBLE;
                            }
                            v = datatype != null ? this.valueFactory.createLiteral(valueString, datatype) : this.valueFactory.createLiteral(valueString);
                        } else {
                            try {
                                v = this.valueFactory.createIRI(valueString);
                            }
                            catch (IllegalArgumentException e) {
                                v = this.valueFactory.createLiteral(valueString);
                            }
                        }
                    }
                    values.add(v);
                }
                ListBindingSet bindingSet = new ListBindingSet(bindingNames, values.toArray(new Value[values.size()]));
                if (this.handler == null) continue;
                this.handler.handleSolution((BindingSet)bindingSet);
            }
            if (bindingNames != null && this.handler != null) {
                this.handler.endQueryResult();
            }
        }
    }
}

