/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.query.resultio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParserFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.helpers.QueryResultCollector;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.RDFStarUtil;
import org.junit.jupiter.api.Test;

public abstract class AbstractTupleQueryResultWriterTest {
    protected static final ValueFactory vf = SimpleValueFactory.getInstance();

    @Test
    public void testRDFStarHandling_WithEncoding() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TupleQueryResultWriter writer = this.getWriterFactory().getWriter((OutputStream)baos);
        writer.getWriterConfig().set((RioSetting)BasicWriterSettings.ENCODE_RDF_STAR, (Object)true);
        Triple t = vf.createTriple((Resource)RDF.ALT, RDF.TYPE, (Value)RDFS.CLASS);
        MapBindingSet bs = new MapBindingSet();
        bs.addBinding("t", (Value)t);
        writer.startQueryResult(new ArrayList(bs.getBindingNames()));
        writer.handleSolution((BindingSet)bs);
        writer.endQueryResult();
        QueryResultCollector collector = new QueryResultCollector();
        TupleQueryResultParser parser = this.getParserFactory().getParser();
        parser.getParserConfig().set((RioSetting)BasicParserSettings.PROCESS_ENCODED_RDF_STAR, (Object)false);
        parser.setQueryResultHandler((QueryResultHandler)collector);
        parser.parseQueryResult((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        BindingSet actual = (BindingSet)collector.getBindingSets().get(0);
        if (writer.getTupleQueryResultFormat().supportsRDFStar()) {
            Assertions.assertThat((Object)actual.getValue("t")).isInstanceOf(Triple.class);
        } else {
            Assertions.assertThat((Object)actual.getValue("t")).isInstanceOf(IRI.class);
            Assertions.assertThat((Object)actual.getValue("t")).isEqualTo((Object)RDFStarUtil.toRDFEncodedValue((Value)t));
        }
    }

    @Test
    public void testRDFStarHandling_NoEncoding() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TupleQueryResultWriter writer = this.getWriterFactory().getWriter((OutputStream)baos);
        writer.getWriterConfig().set((RioSetting)BasicWriterSettings.ENCODE_RDF_STAR, (Object)false);
        Triple t = vf.createTriple((Resource)RDF.ALT, RDF.TYPE, (Value)RDFS.CLASS);
        MapBindingSet bs = new MapBindingSet();
        bs.addBinding("t", (Value)t);
        writer.startQueryResult(new ArrayList(bs.getBindingNames()));
        writer.handleSolution((BindingSet)bs);
        writer.endQueryResult();
        QueryResultCollector collector = new QueryResultCollector();
        TupleQueryResultParser parser = this.getParserFactory().getParser();
        parser.getParserConfig().set((RioSetting)BasicParserSettings.PROCESS_ENCODED_RDF_STAR, (Object)false);
        parser.setQueryResultHandler((QueryResultHandler)collector);
        parser.parseQueryResult((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        BindingSet actual = (BindingSet)collector.getBindingSets().get(0);
        Assertions.assertThat((Object)actual.getValue("t")).isInstanceOf(Triple.class);
    }

    @Test
    public void testRDFStarHandling_DeepNesting() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TupleQueryResultWriter writer = this.getWriterFactory().getWriter((OutputStream)baos);
        writer.getWriterConfig().set((RioSetting)BasicWriterSettings.ENCODE_RDF_STAR, (Object)false);
        Triple t2 = vf.createTriple((Resource)RDF.ALT, RDF.TYPE, (Value)RDFS.CLASS);
        Triple t = vf.createTriple((Resource)RDF.BAG, RDFS.COMMENT, (Value)t2);
        MapBindingSet bs = new MapBindingSet();
        bs.addBinding("t", (Value)t);
        writer.startQueryResult(new ArrayList(bs.getBindingNames()));
        writer.handleSolution((BindingSet)bs);
        writer.endQueryResult();
        QueryResultCollector collector = new QueryResultCollector();
        TupleQueryResultParser parser = this.getParserFactory().getParser();
        parser.getParserConfig().set((RioSetting)BasicParserSettings.PROCESS_ENCODED_RDF_STAR, (Object)false);
        parser.setQueryResultHandler((QueryResultHandler)collector);
        parser.parseQueryResult((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        BindingSet actual = (BindingSet)collector.getBindingSets().get(0);
        Assertions.assertThat((Object)actual.getValue("t")).isInstanceOf(Triple.class);
        Triple actualT = (Triple)actual.getValue("t");
        Assertions.assertThat((Object)actualT.getSubject()).isEqualTo((Object)RDF.BAG);
        Assertions.assertThat((Object)actualT.getPredicate()).isEqualTo((Object)RDFS.COMMENT);
        Assertions.assertThat((Object)actualT.getObject()).isInstanceOf(Triple.class);
        Triple actualT2 = (Triple)actualT.getObject();
        Assertions.assertThat((Object)actualT2.getSubject()).isEqualTo((Object)RDF.ALT);
        Assertions.assertThat((Object)actualT2.getPredicate()).isEqualTo((Object)RDF.TYPE);
        Assertions.assertThat((Object)actualT2.getObject()).isEqualTo((Object)RDFS.CLASS);
    }

    @Test
    public void testGetSupportedSettings() {
        TupleQueryResultWriter writer = this.getWriterFactory().getWriter((OutputStream)System.out);
        Collection supportedSettings = writer.getSupportedSettings();
        Assertions.assertThat((Collection)supportedSettings).containsExactlyInAnyOrder((Object[])this.getExpectedSupportedSettings());
    }

    protected abstract RioSetting<?>[] getExpectedSupportedSettings();

    protected abstract TupleQueryResultParserFactory getParserFactory();

    protected abstract TupleQueryResultWriterFactory getWriterFactory();
}

