/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.query.resultio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.testsuite.query.resultio.AbstractQueryResultIOTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractQueryResultIOTupleTest
extends AbstractQueryResultIOTest {
    @Override
    protected final QueryResultFormat getFormat() {
        return this.getTupleFormat();
    }

    protected abstract TupleQueryResultFormat getTupleFormat();

    protected abstract BooleanQueryResultFormat getMatchingBooleanFormatOrNull();

    @Test
    public final void testSPARQLResultFormatSingleVarMultipleBindingSets() throws Exception {
        this.doTupleNoLinks(this.getTupleFormat(), this.createTupleSingleVarMultipleBindingSets(), this.createTupleSingleVarMultipleBindingSets());
    }

    @Test
    public final void testSPARQLResultFormatMultipleBindingsMultipleBindingSets() throws Exception {
        this.doTupleNoLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets());
    }

    @Test
    public final void testSPARQLResultFormatNoResults() throws Exception {
        this.doTupleNoLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets());
    }

    @Test
    public final void testNoHandlerNoResults() throws Exception {
        this.doTupleNoHandler(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets());
    }

    @Test
    public final void testNoHandlerWithResults() throws Exception {
        this.doTupleNoHandler(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets());
    }

    @Test
    public final void testTupleParseNoHandlerOnBooleanResults() throws Exception {
        this.doTupleParseNoHandlerOnBooleanResults(this.getTupleFormat(), true, this.getMatchingBooleanFormatOrNull());
        this.doTupleParseNoHandlerOnBooleanResults(this.getTupleFormat(), false, this.getMatchingBooleanFormatOrNull());
    }

    @Test
    public final void testNoLinksNoResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList(new String[0]));
    }

    @Test
    public final void testNoLinksWithResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList(new String[0]));
    }

    @Test
    public final void testOneLinkNoResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList("info"));
    }

    @Test
    public final void testOneLinkWithResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info"));
    }

    @Test
    public final void testMultipleLinksNoResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList("info", "alternate", "other", "another"));
    }

    @Test
    public final void testMultipleLinksWithResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"));
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheet() throws Exception {
        this.doTupleLinksAndStylesheet(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespaces() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespaces(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespaces());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespacesQName() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespacesQName(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespaces());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespacesWithEmpty() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespaces(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespacesWithEmpty());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespacesQNameWithEmpty() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespacesQName(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespacesWithEmpty());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetNoStarts() throws Exception {
        this.doTupleLinksAndStylesheetNoStarts(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetMultipleEndHeaders() throws Exception {
        this.doTupleLinksAndStylesheetMultipleEndHeaders(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testNoResultsAndStylesheet() throws Exception {
        this.doTupleStylesheet(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), "test.xsl");
    }

    @Test
    public final void testMultipleResultsAndStylesheet() throws Exception {
        this.doTupleStylesheet(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), "test.xsl");
    }

    @Test
    public final void testMultipleResultsJSONPCallback() throws Exception {
        this.doTupleJSONPCallback(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets());
    }

    @Test
    public final void testNoResultsJSONPCallback() throws Exception {
        this.doTupleJSONPCallback(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets());
    }

    @Test
    public final void testNoResultsExceptionHandleSolutionBeforeStartQueryResult() throws Exception {
        this.doTupleMissingStartQueryResult(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testMultipleExceptionHandleSolutionBeforeStartQueryResult() throws Exception {
        this.doTupleMissingStartQueryResult(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testRDFStarCompatibility() throws IOException {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        List<String> bindingNames = Arrays.asList("a", "b", "c");
        ArrayList<MapBindingSet> bindings = new ArrayList<MapBindingSet>();
        MapBindingSet bs1 = new MapBindingSet();
        bs1.addBinding("a", (Value)vf.createLiteral("1984", XSD.INTEGER));
        bs1.addBinding("b", (Value)vf.createIRI("urn:test"));
        bs1.addBinding("c", (Value)vf.createBNode("bnode1"));
        bindings.add(bs1);
        MapBindingSet bs2 = new MapBindingSet();
        bs2.addBinding("a", (Value)vf.createLiteral("foo"));
        bs2.addBinding("b", (Value)vf.createTriple((Resource)vf.createBNode("bnode2"), RDFS.LABEL, (Value)vf.createLiteral("\"literal with\tfunny\nchars")));
        bs2.addBinding("c", (Value)vf.createTriple((Resource)vf.createTriple((Resource)vf.createTriple((Resource)vf.createIRI("urn:a"), RDF.TYPE, (Value)vf.createIRI("urn:b")), vf.createIRI("urn:c"), (Value)vf.createIRI("urn:d")), vf.createIRI("urn:e"), (Value)vf.createIRI("urn:f")));
        bindings.add(bs2);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            QueryResultIO.writeTuple((TupleQueryResult)new IteratingTupleQueryResult(bindingNames, bindings), (QueryResultFormat)this.getTupleFormat(), (OutputStream)bos);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());){
                TupleQueryResult parsedBindings = QueryResultIO.parseTuple((InputStream)bis, (QueryResultFormat)this.getTupleFormat(), new WeakReference<AbstractQueryResultIOTupleTest>(this));
                Assertions.assertEquals(bindingNames, (Object)parsedBindings.getBindingNames());
                ArrayList actualBindings = new ArrayList();
                parsedBindings.forEach(actualBindings::add);
                Assertions.assertEquals(bindings, actualBindings);
            }
        }
    }
}

