/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.util.Arrays;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultIOTest;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.junit.jupiter.api.Test;

public abstract class AbstractQueryResultIOBooleanTest
extends AbstractQueryResultIOTest {
    @Override
    protected final QueryResultFormat getFormat() {
        return this.getBooleanFormat();
    }

    protected abstract BooleanQueryResultFormat getBooleanFormat();

    protected abstract TupleQueryResultFormat getMatchingTupleFormatOrNull();

    @Test
    public final void testBooleanNoLinks() throws Exception {
        this.doBooleanNoLinks(this.getBooleanFormat(), true);
        this.doBooleanNoLinks(this.getBooleanFormat(), false);
    }

    @Test
    public final void testBooleanEmptyLinks() throws Exception {
        this.doBooleanLinks(this.getBooleanFormat(), true, Arrays.asList(new String[0]));
        this.doBooleanLinks(this.getBooleanFormat(), false, Arrays.asList(new String[0]));
    }

    @Test
    public final void testBooleanOneLink() throws Exception {
        this.doBooleanLinks(this.getBooleanFormat(), true, Arrays.asList("info"));
        this.doBooleanLinks(this.getBooleanFormat(), false, Arrays.asList("info"));
    }

    @Test
    public final void testBooleanMultipleLinks() throws Exception {
        this.doBooleanLinks(this.getBooleanFormat(), true, Arrays.asList("info", "alternate", "other", "another"));
        this.doBooleanLinks(this.getBooleanFormat(), false, Arrays.asList("info", "alternate", "other", "another"));
    }

    @Test
    public final void testBooleanEmptyLinksOnly() throws Exception {
        this.doBooleanLinksOnly(this.getBooleanFormat(), true, Arrays.asList(new String[0]));
        this.doBooleanLinksOnly(this.getBooleanFormat(), false, Arrays.asList(new String[0]));
    }

    @Test
    public final void testBooleanOneLinkOnly() throws Exception {
        this.doBooleanLinksOnly(this.getBooleanFormat(), true, Arrays.asList("info"));
        this.doBooleanLinksOnly(this.getBooleanFormat(), false, Arrays.asList("info"));
    }

    @Test
    public final void testBooleanMultipleLinksOnly() throws Exception {
        this.doBooleanLinksOnly(this.getBooleanFormat(), true, Arrays.asList("info", "alternate", "other", "another"));
        this.doBooleanLinksOnly(this.getBooleanFormat(), false, Arrays.asList("info", "alternate", "other", "another"));
    }

    @Test
    public final void testBooleanMultipleLinksWithStylesheet() throws Exception {
        this.doBooleanLinksAndStylesheet(this.getBooleanFormat(), true, Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
        this.doBooleanLinksAndStylesheet(this.getBooleanFormat(), false, Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testMultipleResultsAndStylesheet() throws Exception {
        this.doBooleanStylesheet(this.getBooleanFormat(), true, "test.xsl");
        this.doBooleanStylesheet(this.getBooleanFormat(), false, "test.xsl");
    }

    @Test
    public final void testInvalidBooleanAfterStartQueryResult() throws Exception {
        this.doInvalidBooleanAfterStartQueryResult(this.getBooleanFormat(), true, Arrays.asList("info", "alternate", "other", "another"));
        this.doInvalidBooleanAfterStartQueryResult(this.getBooleanFormat(), false, Arrays.asList("info", "alternate", "other", "another"));
    }

    @Test
    public final void testBooleanNoHandler() throws Exception {
        this.doBooleanNoHandler(this.getBooleanFormat(), true);
        this.doBooleanNoHandler(this.getBooleanFormat(), false);
    }

    @Test
    public final void testBooleanParseNoHandlerOnTupleResultsNoResults() throws Exception {
        this.doBooleanParseNoHandlerOnTupleResults(this.getBooleanFormat(), this.createTupleNoBindingSets(), this.getMatchingTupleFormatOrNull());
    }

    @Test
    public final void testBooleanParseNoHandlerOnTupleResultsSingleVarMultipleBindingSets() throws Exception {
        this.doBooleanParseNoHandlerOnTupleResults(this.getBooleanFormat(), this.createTupleSingleVarMultipleBindingSets(), this.getMatchingTupleFormatOrNull());
    }

    @Test
    public final void testBooleanParseNoHandlerOnTupleResultsMultipleBindingsMultipleBindingSets() throws Exception {
        this.doBooleanParseNoHandlerOnTupleResults(this.getBooleanFormat(), this.createTupleMultipleBindingSets(), this.getMatchingTupleFormatOrNull());
    }
}

