/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.util.Arrays;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultIOTest;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.junit.Test;

public abstract class AbstractQueryResultIOTupleTest
extends AbstractQueryResultIOTest {
    @Override
    protected final QueryResultFormat getFormat() {
        return this.getTupleFormat();
    }

    protected abstract TupleQueryResultFormat getTupleFormat();

    protected abstract BooleanQueryResultFormat getMatchingBooleanFormatOrNull();

    @Test
    public final void testSPARQLResultFormatSingleVarMultipleBindingSets() throws Exception {
        this.doTupleNoLinks(this.getTupleFormat(), this.createTupleSingleVarMultipleBindingSets(), this.createTupleSingleVarMultipleBindingSets());
    }

    @Test
    public final void testSPARQLResultFormatMultipleBindingsMultipleBindingSets() throws Exception {
        this.doTupleNoLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets());
    }

    @Test
    public final void testSPARQLResultFormatNoResults() throws Exception {
        this.doTupleNoLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets());
    }

    @Test
    public final void testNoHandlerNoResults() throws Exception {
        this.doTupleNoHandler(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets());
    }

    @Test
    public final void testNoHandlerWithResults() throws Exception {
        this.doTupleNoHandler(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets());
    }

    @Test
    public final void testTupleParseNoHandlerOnBooleanResults() throws Exception {
        this.doTupleParseNoHandlerOnBooleanResults(this.getTupleFormat(), true, this.getMatchingBooleanFormatOrNull());
        this.doTupleParseNoHandlerOnBooleanResults(this.getTupleFormat(), false, this.getMatchingBooleanFormatOrNull());
    }

    @Test
    public final void testNoLinksNoResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList(new String[0]));
    }

    @Test
    public final void testNoLinksWithResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList(new String[0]));
    }

    @Test
    public final void testOneLinkNoResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList("info"));
    }

    @Test
    public final void testOneLinkWithResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info"));
    }

    @Test
    public final void testMultipleLinksNoResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList("info", "alternate", "other", "another"));
    }

    @Test
    public final void testMultipleLinksWithResults() throws Exception {
        this.doTupleLinks(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"));
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheet() throws Exception {
        this.doTupleLinksAndStylesheet(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespaces() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespaces(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespaces());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespacesQName() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespacesQName(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespaces());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespacesWithEmpty() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespaces(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespacesWithEmpty());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetAndNamespacesQNameWithEmpty() throws Exception {
        this.doTupleLinksAndStylesheetAndNamespacesQName(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl", this.getNamespacesWithEmpty());
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetNoStarts() throws Exception {
        this.doTupleLinksAndStylesheetNoStarts(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testMultipleLinksWithResultsAndStylesheetMultipleEndHeaders() throws Exception {
        this.doTupleLinksAndStylesheetMultipleEndHeaders(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testNoResultsAndStylesheet() throws Exception {
        this.doTupleStylesheet(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), "test.xsl");
    }

    @Test
    public final void testMultipleResultsAndStylesheet() throws Exception {
        this.doTupleStylesheet(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), "test.xsl");
    }

    @Test
    public final void testMultipleResultsJSONPCallback() throws Exception {
        this.doTupleJSONPCallback(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets());
    }

    @Test
    public final void testNoResultsJSONPCallback() throws Exception {
        this.doTupleJSONPCallback(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets());
    }

    @Test
    public final void testNoResultsExceptionHandleSolutionBeforeStartQueryResult() throws Exception {
        this.doTupleMissingStartQueryResult(this.getTupleFormat(), this.createTupleNoBindingSets(), this.createTupleNoBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }

    @Test
    public final void testMultipleExceptionHandleSolutionBeforeStartQueryResult() throws Exception {
        this.doTupleMissingStartQueryResult(this.getTupleFormat(), this.createTupleMultipleBindingSets(), this.createTupleMultipleBindingSets(), Arrays.asList("info", "alternate", "other", "another"), "test.xsl");
    }
}

