/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.BasicQueryWriterSettings;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParser;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.UnsupportedQueryResultFormatException;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractQueryResultIOTest {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();

    protected abstract String getFileName();

    protected abstract QueryResultFormat getFormat();

    @Test
    public final void testGetParserFormatForFileNameString() throws Exception {
        String fileName = this.getFileName();
        QueryResultFormat format = this.getFormat() instanceof TupleQueryResultFormat ? QueryResultIO.getParserFormatForFileName((String)fileName) : QueryResultIO.getBooleanParserFormatForFileName((String)fileName);
        Assert.assertTrue((String)"Could not find parser for this format.", (format != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.getFormat(), (Object)format);
    }

    protected TupleQueryResult createTupleSingleVarMultipleBindingSets() {
        List<String> bindingNames = Arrays.asList("a");
        MapBindingSet solution1 = new MapBindingSet(bindingNames.size());
        solution1.addBinding("a", (Value)vf.createIRI("foo:bar"));
        MapBindingSet solution2 = new MapBindingSet(bindingNames.size());
        solution2.addBinding("a", (Value)vf.createLiteral("2.0", XMLSchema.DOUBLE));
        MapBindingSet solution3 = new MapBindingSet(bindingNames.size());
        solution3.addBinding("a", (Value)vf.createBNode("bnode3"));
        MapBindingSet solution4 = new MapBindingSet(bindingNames.size());
        solution4.addBinding("a", (Value)vf.createLiteral("''single-quoted string", XMLSchema.STRING));
        MapBindingSet solution5 = new MapBindingSet(bindingNames.size());
        solution5.addBinding("a", (Value)vf.createLiteral("\"\"double-quoted string", XMLSchema.STRING));
        MapBindingSet solution6 = new MapBindingSet(bindingNames.size());
        solution6.addBinding("a", (Value)vf.createLiteral("space at the end         ", XMLSchema.STRING));
        MapBindingSet solution7 = new MapBindingSet(bindingNames.size());
        solution7.addBinding("a", (Value)vf.createLiteral("space at the end         ", XMLSchema.STRING));
        MapBindingSet solution8 = new MapBindingSet(bindingNames.size());
        solution8.addBinding("a", (Value)vf.createLiteral("\"\"double-quoted string with no datatype"));
        MapBindingSet solution9 = new MapBindingSet(bindingNames.size());
        solution9.addBinding("a", (Value)vf.createLiteral("newline at the end \n", XMLSchema.STRING));
        List<MapBindingSet> bindingSetList = Arrays.asList(solution1, solution2, solution3, solution4, solution5, solution6, solution7, solution8, solution9);
        IteratingTupleQueryResult result = new IteratingTupleQueryResult(bindingNames, bindingSetList);
        return result;
    }

    protected TupleQueryResult createTupleMultipleBindingSets() {
        List<String> bindingNames = Arrays.asList("a", "b", "c");
        MapBindingSet solution1 = new MapBindingSet(bindingNames.size());
        solution1.addBinding("a", (Value)vf.createIRI("foo:bar"));
        solution1.addBinding("b", (Value)vf.createBNode("bnode"));
        solution1.addBinding("c", (Value)vf.createLiteral("baz"));
        MapBindingSet solution2 = new MapBindingSet(bindingNames.size());
        solution2.addBinding("a", (Value)vf.createLiteral("1", XMLSchema.INTEGER));
        solution2.addBinding("c", (Value)vf.createLiteral("Hello World!", "en"));
        MapBindingSet solution3 = new MapBindingSet(bindingNames.size());
        solution3.addBinding("a", (Value)vf.createIRI("http://example.org/test/ns/bindingA"));
        solution3.addBinding("b", (Value)vf.createLiteral("http://example.com/other/ns/bindingB"));
        solution3.addBinding("c", (Value)vf.createIRI("http://example.com/other/ns/binding,C"));
        MapBindingSet solution4 = new MapBindingSet(bindingNames.size());
        solution4.addBinding("a", (Value)vf.createLiteral("string with newline at the end       \n"));
        solution4.addBinding("b", (Value)vf.createLiteral("string with space at the end         "));
        solution4.addBinding("c", (Value)vf.createLiteral("    "));
        MapBindingSet solution5 = new MapBindingSet(bindingNames.size());
        solution5.addBinding("a", (Value)vf.createLiteral("''single-quoted string"));
        solution5.addBinding("b", (Value)vf.createLiteral("\"\"double-quoted string"));
        solution5.addBinding("c", (Value)vf.createLiteral("\t\tunencoded tab characters followed by encoded \t\t"));
        List<MapBindingSet> bindingSetList = Arrays.asList(solution1, solution2, solution3, solution4, solution5);
        IteratingTupleQueryResult result = new IteratingTupleQueryResult(bindingNames, bindingSetList);
        return result;
    }

    protected Map<String, String> getNamespaces() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("test", "http://example.org/test/ns/");
        result.put("other", "http://example.com/other/ns/");
        return result;
    }

    protected Map<String, String> getNamespacesWithEmpty() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("test", "http://example.org/test/ns/");
        result.put("other", "http://example.com/other/ns/");
        result.put("", "http://other.example.org/ns/");
        return result;
    }

    protected TupleQueryResult createTupleNoBindingSets() {
        List<String> bindingNames = Arrays.asList("a", "b", "c");
        List bindingSetList = Collections.emptyList();
        IteratingTupleQueryResult result = new IteratingTupleQueryResult(bindingNames, bindingSetList);
        return result;
    }

    protected void doTupleLinks(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, List<String> links) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        writer.startDocument();
        writer.startHeader();
        writer.handleLinks(links);
        QueryResults.report((TupleQueryResult)input, (QueryResultHandler)writer);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
    }

    protected void doTupleLinksAndStylesheet(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, List<String> links, String stylesheetUrl) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        writer.startDocument();
        writer.handleStylesheet(stylesheetUrl);
        writer.startHeader();
        writer.handleLinks(links);
        QueryResults.report((TupleQueryResult)input, (QueryResultHandler)writer);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
    }

    protected void doTupleLinksAndStylesheetAndNamespaces(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, List<String> links, String stylesheetUrl, Map<String, String> namespaces) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        for (String nextPrefix : namespaces.keySet()) {
            writer.handleNamespace(nextPrefix, namespaces.get(nextPrefix));
        }
        writer.startDocument();
        writer.handleStylesheet(stylesheetUrl);
        writer.startHeader();
        writer.handleLinks(links);
        QueryResults.report((TupleQueryResult)input, (QueryResultHandler)writer);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
    }

    protected void doTupleLinksAndStylesheetAndNamespacesQName(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, List<String> links, String stylesheetUrl, Map<String, String> namespaces) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        if (writer.getSupportedSettings().contains(BasicQueryWriterSettings.ADD_SESAME_QNAME)) {
            writer.getWriterConfig().set(BasicQueryWriterSettings.ADD_SESAME_QNAME, (Object)true);
        }
        for (String nextPrefix : namespaces.keySet()) {
            writer.handleNamespace(nextPrefix, namespaces.get(nextPrefix));
        }
        writer.startDocument();
        writer.handleStylesheet(stylesheetUrl);
        writer.startHeader();
        writer.handleLinks(links);
        QueryResults.report((TupleQueryResult)input, (QueryResultHandler)writer);
        String result = out.toString("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
        if (writer.getSupportedSettings().contains(BasicQueryWriterSettings.ADD_SESAME_QNAME)) {
            Assert.assertTrue((boolean)result.contains("test:bindingA"));
            Assert.assertFalse((boolean)result.contains("other:bindingB"));
            Assert.assertTrue((boolean)result.contains("other:binding,C"));
        }
    }

    protected void doTupleJSONPCallback(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        if (writer.getSupportedSettings().contains(BasicQueryWriterSettings.JSONP_CALLBACK)) {
            String callback = "nextfunctionname" + Math.abs(new Random().nextInt());
            writer.getWriterConfig().set(BasicQueryWriterSettings.JSONP_CALLBACK, (Object)callback);
            QueryResults.report((TupleQueryResult)input, (QueryResultHandler)writer);
            String result = out.toString("UTF-8");
            Assert.assertTrue((boolean)result.startsWith(callback + "("));
            Assert.assertTrue((boolean)result.endsWith(");"));
            result = result.substring(callback.length() + 1, result.length() - 2);
            ByteArrayInputStream in = new ByteArrayInputStream(result.getBytes("UTF-8"));
            TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
            this.assertQueryResultsEqual(expected, output);
        }
    }

    protected void doTupleNoLinks(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected) throws IOException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException, QueryResultHandlerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        QueryResultIO.writeTuple((TupleQueryResult)input, (QueryResultFormat)format, (OutputStream)out);
        input.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
    }

    protected void doTupleStylesheet(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, String stylesheetUrl) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        writer.handleStylesheet(stylesheetUrl);
        QueryResults.report((TupleQueryResult)input, (QueryResultHandler)writer);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
    }

    protected void doTupleLinksAndStylesheetNoStarts(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, List<String> links, String stylesheetUrl) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        writer.handleStylesheet(stylesheetUrl);
        writer.handleLinks(links);
        QueryResults.report((TupleQueryResult)input, (QueryResultHandler)writer);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTupleLinksAndStylesheetMultipleEndHeaders(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, List<String> links, String stylesheetUrl) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        writer.handleStylesheet(stylesheetUrl);
        writer.startQueryResult(input.getBindingNames());
        writer.handleLinks(links);
        writer.endHeader();
        writer.endHeader();
        try {
            while (input.hasNext()) {
                BindingSet bindingSet = (BindingSet)input.next();
                writer.handleSolution(bindingSet);
            }
        }
        finally {
            input.close();
        }
        writer.endQueryResult();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResult output = QueryResultIO.parseTuple((InputStream)in, (QueryResultFormat)format);
        this.assertQueryResultsEqual(expected, output);
    }

    protected void assertQueryResultsEqual(TupleQueryResult expected, TupleQueryResult output) throws QueryEvaluationException, TupleQueryResultHandlerException, QueryResultHandlerException, UnsupportedEncodingException {
        Assert.assertTrue((boolean)QueryResults.equals((TupleQueryResult)expected, (TupleQueryResult)output));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTupleMissingStartQueryResult(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected, List<String> links, String stylesheetUrl) throws QueryResultHandlerException, QueryEvaluationException, QueryResultParseException, UnsupportedQueryResultFormatException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)out);
        writer.startDocument();
        writer.handleStylesheet(stylesheetUrl);
        writer.startHeader();
        writer.handleLinks(links);
        writer.endHeader();
        try {
            while (input.hasNext()) {
                BindingSet bindingSet = (BindingSet)input.next();
                writer.handleSolution(bindingSet);
            }
            writer.endQueryResult();
            Assert.fail((String)"Expected exception when calling handleSolution without startQueryResult");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            input.close();
        }
    }

    protected void doTupleNoHandler(TupleQueryResultFormat format, TupleQueryResult input, TupleQueryResult expected) throws QueryResultParseException, IOException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        QueryResultIO.writeTuple((TupleQueryResult)input, (QueryResultFormat)format, (OutputStream)out);
        out.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResultParser parser = QueryResultIO.createTupleParser((QueryResultFormat)format);
        parser.parse((InputStream)in);
    }

    protected void doTupleParseNoHandlerOnBooleanResults(TupleQueryResultFormat format, boolean input, BooleanQueryResultFormat matchingBooleanFormat) throws UnsupportedQueryResultFormatException, QueryResultHandlerException, IOException {
        if (matchingBooleanFormat == null) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter((QueryResultFormat)matchingBooleanFormat, (OutputStream)out);
        writer.handleBoolean(input);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleQueryResultParser parser = QueryResultIO.createTupleParser((QueryResultFormat)format);
        try {
            parser.parse((InputStream)in);
            Assert.fail((String)"Did not find expected parse exception");
        }
        catch (QueryResultParseException queryResultParseException) {
            // empty catch block
        }
    }

    protected void doBooleanNoLinks(BooleanQueryResultFormat format, boolean input) throws IOException, QueryResultHandlerException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        QueryResultIO.writeBoolean((boolean)input, (QueryResultFormat)format, (OutputStream)out);
        out.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        boolean output = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)format);
        Assert.assertEquals((Object)output, (Object)input);
    }

    protected void doBooleanLinksOnly(BooleanQueryResultFormat format, boolean input, List<String> links) throws IOException, QueryResultHandlerException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter((QueryResultFormat)format, (OutputStream)out);
        writer.handleLinks(links);
        writer.handleBoolean(input);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        boolean output = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)format);
        Assert.assertEquals((Object)output, (Object)input);
    }

    protected void doInvalidBooleanAfterStartQueryResult(BooleanQueryResultFormat format, boolean input, List<String> links) throws IOException, QueryResultHandlerException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter((QueryResultFormat)format, (OutputStream)out);
        writer.handleLinks(links);
        boolean supported = true;
        try {
            writer.startQueryResult(Arrays.asList("foo"));
        }
        catch (UnsupportedOperationException uoe) {
            supported = false;
        }
        if (supported) {
            try {
                writer.handleBoolean(input);
                Assert.fail((String)"Did not find expected exception");
            }
            catch (QueryResultHandlerException queryResultHandlerException) {
                // empty catch block
            }
        }
    }

    protected void doBooleanLinks(BooleanQueryResultFormat format, boolean input, List<String> links) throws IOException, QueryResultHandlerException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter((QueryResultFormat)format, (OutputStream)out);
        writer.startDocument();
        writer.startHeader();
        writer.handleLinks(links);
        writer.handleBoolean(input);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        boolean output = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)format);
        Assert.assertEquals((Object)output, (Object)input);
    }

    protected void doBooleanLinksAndStylesheet(BooleanQueryResultFormat format, boolean input, List<String> links, String stylesheetUrl) throws IOException, QueryResultHandlerException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter((QueryResultFormat)format, (OutputStream)out);
        writer.startDocument();
        writer.handleStylesheet(stylesheetUrl);
        writer.startHeader();
        writer.handleLinks(links);
        writer.handleBoolean(input);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        boolean output = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)format);
        Assert.assertEquals((Object)output, (Object)input);
    }

    protected void doBooleanLinksAndStylesheetAndNamespaces(BooleanQueryResultFormat format, boolean input, List<String> links, String stylesheetUrl, Map<String, String> namespaces) throws IOException, QueryResultHandlerException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter((QueryResultFormat)format, (OutputStream)out);
        for (String nextPrefix : namespaces.keySet()) {
            writer.handleNamespace(nextPrefix, namespaces.get(nextPrefix));
        }
        writer.startDocument();
        writer.handleStylesheet(stylesheetUrl);
        writer.startHeader();
        writer.handleLinks(links);
        writer.handleBoolean(input);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        boolean output = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)format);
        Assert.assertEquals((Object)output, (Object)input);
    }

    protected void doBooleanStylesheet(BooleanQueryResultFormat format, boolean input, String stylesheetUrl) throws IOException, QueryResultHandlerException, QueryResultParseException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter((QueryResultFormat)format, (OutputStream)out);
        writer.handleStylesheet(stylesheetUrl);
        writer.handleBoolean(input);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        boolean output = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)format);
        Assert.assertEquals((Object)output, (Object)input);
    }

    protected void doBooleanNoHandler(BooleanQueryResultFormat format, boolean input) throws QueryResultParseException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        QueryResultIO.writeBoolean((boolean)input, (QueryResultFormat)format, (OutputStream)out);
        out.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BooleanQueryResultParser parser = QueryResultIO.createBooleanParser((QueryResultFormat)format);
        Assert.assertEquals((Object)input, (Object)parser.parse((InputStream)in));
    }

    protected void doBooleanParseNoHandlerOnTupleResults(BooleanQueryResultFormat format, TupleQueryResult tqr, TupleQueryResultFormat matchingTupleFormat) throws TupleQueryResultHandlerException, UnsupportedQueryResultFormatException, QueryEvaluationException, IOException {
        if (matchingTupleFormat == null) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        QueryResultIO.writeTuple((TupleQueryResult)tqr, (QueryResultFormat)matchingTupleFormat, (OutputStream)out);
        out.flush();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BooleanQueryResultParser parser = QueryResultIO.createBooleanParser((QueryResultFormat)format);
        try {
            parser.parse((InputStream)in);
            Assert.fail((String)"Did not find expected parse exception");
        }
        catch (QueryResultParseException queryResultParseException) {
            // empty catch block
        }
    }
}

