/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.sparqljson.AbstractSPARQLJSONParser;

public class SPARQLResultsJSONParser
extends AbstractSPARQLJSONParser
implements TupleQueryResultParser {
    static final String TRIPLE_TYPE_STARDOG = "statement";
    static final String SUBJECT_JENA = "subject";
    static final String PREDICATE_JENA = "predicate";
    static final String OBJECT_JENA = "object";

    public SPARQLResultsJSONParser() {
    }

    public SPARQLResultsJSONParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public QueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.JSON;
    }

    @Deprecated
    public void setTupleQueryResultHandler(TupleQueryResultHandler handler) {
        this.setQueryResultHandler((QueryResultHandler)handler);
    }

    @Deprecated
    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        try {
            this.parseQueryResultInternal(in, false, true);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    @Override
    protected Triple parseTripleValue(JsonParser jp, String fieldName) throws IOException {
        Value subject = null;
        Value predicate = null;
        Value object = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new QueryResultParseException("Did not find triple attribute in triple value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
            String posName = jp.getCurrentName();
            if ("s".equals(posName) || SUBJECT_JENA.equals(posName)) {
                subject = this.parseValue(jp, fieldName + ":" + posName);
                continue;
            }
            if ("p".equals(posName) || PREDICATE_JENA.equals(posName)) {
                predicate = this.parseValue(jp, fieldName + ":" + posName);
                continue;
            }
            if ("o".equals(posName) || OBJECT_JENA.equals(posName)) {
                object = this.parseValue(jp, fieldName + ":" + posName);
                continue;
            }
            throw new QueryResultParseException("Unexpected field name in triple value: " + posName, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        if (subject instanceof Resource && predicate instanceof IRI && object != null) {
            return this.valueFactory.createTriple((Resource)subject, (IRI)predicate, object);
        }
        throw new QueryResultParseException("Incomplete or invalid triple value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
    }

    @Override
    protected boolean checkTripleType(JsonParser jp, String type) {
        if (!"triple".equals(type) && !TRIPLE_TYPE_STARDOG.equals(type)) {
            throw new QueryResultParseException("Found a triple value but unexpected type: " + type, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        return true;
    }
}

