/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqlstarjson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLResultsJSONParser;
import org.eclipse.rdf4j.query.resultio.sparqlstarjson.SPARQLStarResultsJSONConstants;

public class SPARQLStarResultsJSONParser
extends SPARQLResultsJSONParser {
    public SPARQLStarResultsJSONParser() {
    }

    public SPARQLStarResultsJSONParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return SPARQLStarResultsJSONConstants.QUERY_RESULT_FORMAT;
    }

    @Override
    protected Triple parseTripleValue(JsonParser jp, String fieldName) throws IOException {
        Value subject = null;
        Value predicate = null;
        Value object = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new QueryResultParseException("Did not find triple attribute in triple value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
            String posName = jp.getCurrentName();
            if ("s".equals(posName)) {
                subject = this.parseValue(jp, fieldName + ":" + posName);
                continue;
            }
            if ("p".equals(posName)) {
                predicate = this.parseValue(jp, fieldName + ":" + posName);
                continue;
            }
            if ("o".equals(posName)) {
                object = this.parseValue(jp, fieldName + ":" + posName);
                continue;
            }
            throw new QueryResultParseException("Unexpected field name in triple value: " + posName, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        if (subject instanceof Resource && predicate instanceof IRI && object != null) {
            return this.valueFactory.createTriple((Resource)subject, (IRI)predicate, object);
        }
        throw new QueryResultParseException("Incomplete or invalid triple value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
    }

    @Override
    protected boolean checkTripleType(JsonParser jp, String type) {
        if (!"triple".equals(type)) {
            throw new QueryResultParseException("Found a triple value but unexpected type: " + type, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        return true;
    }
}

