/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.JSONSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSPARQLJSONParser
extends AbstractQueryResultParser {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String HEAD = "head";
    public static final String LINK = "link";
    public static final String VARS = "vars";
    public static final String BOOLEAN = "boolean";
    public static final String RESULTS = "results";
    public static final String BINDINGS = "bindings";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String XMLLANG = "xml:lang";
    public static final String DATATYPE = "datatype";
    public static final String LITERAL = "literal";
    public static final String TYPED_LITERAL = "typed-literal";
    public static final String BNODE = "bnode";
    public static final String URI = "uri";
    private static final String DISTINCT = "distinct";
    private static final String ORDERED = "ordered";

    public AbstractSPARQLJSONParser() {
    }

    public AbstractSPARQLJSONParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public void parseQueryResult(InputStream in) throws IOException, QueryResultParseException, QueryResultHandlerException {
        this.parseQueryResultInternal(in, true, true);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean parseQueryResultInternal(InputStream in, boolean attemptParseBoolean, boolean attemptParseTuple) throws IOException, QueryResultParseException, QueryResultHandlerException {
        if (!attemptParseBoolean && !attemptParseTuple) {
            throw new IllegalArgumentException("Internal error: Did not specify whether to parse as either boolean and/or tuple");
        }
        JsonParser jp = null;
        boolean result = false;
        try {
            jp = this.configureNewJsonFactory().createParser(in);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new QueryResultParseException("Expected SPARQL Results JSON document to start with an Object", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
            ArrayList<String> varsList = new ArrayList<String>();
            boolean varsFound = false;
            HashSet<MapBindingSet> bindings = new HashSet<MapBindingSet>();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String baseStr = jp.getCurrentName();
                if (baseStr.equals(HEAD)) {
                    if (jp.nextToken() != JsonToken.START_OBJECT) {
                        throw new QueryResultParseException("Did not find object under " + baseStr + " field", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String headStr = jp.getCurrentName();
                        if (headStr.equals(VARS)) {
                            if (!attemptParseTuple) {
                                throw new QueryResultParseException("Found tuple results variables when attempting to parse SPARQL Results JSON to boolean result", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getLineNr());
                            }
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new QueryResultParseException("Expected variable labels to be an array", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                varsList.add(jp.getText());
                            }
                            if (this.handler != null) {
                                this.handler.startQueryResult(varsList);
                            }
                            varsFound = true;
                            if (bindings.isEmpty() || this.handler == null) continue;
                            for (BindingSet bindingSet : bindings) {
                                this.handler.handleSolution(bindingSet);
                                this.handler.endQueryResult();
                            }
                            bindings.clear();
                            continue;
                        }
                        if (headStr.equals(LINK)) {
                            ArrayList<String> linksList = new ArrayList<String>();
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new QueryResultParseException("Expected links to be an array", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                linksList.add(jp.getText());
                            }
                            if (this.handler == null) continue;
                            this.handler.handleLinks(linksList);
                            continue;
                        }
                        throw new QueryResultParseException("Found unexpected object in head field: " + headStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    continue;
                }
                if (baseStr.equals(RESULTS)) {
                    if (!attemptParseTuple) {
                        throw new QueryResultParseException("Found tuple results bindings when attempting to parse SPARQL Results JSON to boolean result", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getLineNr());
                    }
                    if (jp.nextToken() != JsonToken.START_OBJECT) {
                        throw new QueryResultParseException("Found unexpected token in results object: " + jp.getCurrentName(), (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        if (jp.getCurrentName().equals(BINDINGS)) {
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new QueryResultParseException("Found unexpected token in bindings object", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                MapBindingSet nextBindingSet = new MapBindingSet();
                                if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                                    throw new QueryResultParseException("Did not find object in bindings array: " + jp.getCurrentName(), (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                }
                                while (jp.nextToken() != JsonToken.END_OBJECT) {
                                    void var12_16;
                                    if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                        throw new QueryResultParseException("Did not find binding name", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                    }
                                    String bindingStr = jp.getCurrentName();
                                    if (jp.nextToken() != JsonToken.START_OBJECT) {
                                        throw new QueryResultParseException("Did not find object for binding value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                    }
                                    Object var12_15 = null;
                                    String type = null;
                                    String datatype = null;
                                    String value = null;
                                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                                        if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                            throw new QueryResultParseException("Did not find value attribute under " + bindingStr + " field", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                        }
                                        String fieldName = jp.getCurrentName();
                                        jp.nextToken();
                                        if (TYPE.equals(fieldName)) {
                                            type = jp.getText();
                                            continue;
                                        }
                                        if (XMLLANG.equals(fieldName)) {
                                            String string = jp.getText();
                                            continue;
                                        }
                                        if (DATATYPE.equals(fieldName)) {
                                            datatype = jp.getText();
                                            continue;
                                        }
                                        if (VALUE.equals(fieldName)) {
                                            value = jp.getText();
                                            continue;
                                        }
                                        throw new QueryResultParseException("Unexpected field name: " + fieldName, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                                    }
                                    nextBindingSet.addBinding(bindingStr, this.parseValue(type, value, (String)var12_16, datatype));
                                }
                                if (!varsFound) {
                                    bindings.add(nextBindingSet);
                                    continue;
                                }
                                if (this.handler == null) continue;
                                this.handler.handleSolution((BindingSet)nextBindingSet);
                            }
                            if (this.handler == null) continue;
                            this.handler.endQueryResult();
                            continue;
                        }
                        if (jp.getCurrentName().equals(DISTINCT) || jp.getCurrentName().equals(ORDERED)) {
                            jp.nextToken();
                            continue;
                        }
                        throw new QueryResultParseException("Found unexpected field in results: " + jp.getCurrentName(), (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    continue;
                }
                if (baseStr.equals(BOOLEAN)) {
                    if (!attemptParseBoolean) {
                        throw new QueryResultParseException("Found boolean results when attempting to parse SPARQL Results JSON to tuple results", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getLineNr());
                    }
                    jp.nextToken();
                    result = Boolean.parseBoolean(jp.getText());
                    if (this.handler == null) continue;
                    this.handler.handleBoolean(result);
                    continue;
                }
                this.logger.debug("Found unexpected object in top level {} field #{}.{}", new Object[]{baseStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr()});
                jp.nextToken();
                if (jp.currentToken() == JsonToken.START_ARRAY) {
                    while (!jp.getParsingContext().getParent().inRoot() || jp.currentToken() != JsonToken.END_ARRAY) {
                        if (jp.nextToken() != null) continue;
                        throw new QueryResultParseException("An array value of the unexpected " + baseStr + " field is not closed.", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getLineNr());
                    }
                    continue;
                }
                if (jp.currentToken() != JsonToken.START_OBJECT) continue;
                while (!jp.getParsingContext().getParent().inRoot() || jp.currentToken() != JsonToken.END_OBJECT) {
                    if (jp.nextToken() != null) continue;
                    throw new QueryResultParseException("An object value of the unexpected " + baseStr + " field is not closed.", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getLineNr());
                }
            }
        }
        catch (JsonProcessingException e) {
            throw new QueryResultParseException("Could not parse SPARQL/JSON", (Throwable)e, (long)e.getLocation().getLineNr(), (long)e.getLocation().getLineNr());
        }
        return result;
    }

    private Value parseValue(String type, String value, String language, String datatype) {
        this.logger.trace("type: {}", (Object)type);
        this.logger.trace("value: {}", (Object)value);
        this.logger.trace("language: {}", (Object)language);
        this.logger.trace("datatype: {}", (Object)datatype);
        Literal result = null;
        if (type.equals(LITERAL) || type.equals(TYPED_LITERAL)) {
            result = language != null ? this.valueFactory.createLiteral(value, language) : (datatype != null ? this.valueFactory.createLiteral(value, this.valueFactory.createIRI(datatype)) : this.valueFactory.createLiteral(value));
        } else if (type.equals(BNODE)) {
            result = this.valueFactory.createBNode(value);
        } else if (type.equals(URI)) {
            result = this.valueFactory.createIRI(value);
        }
        this.logger.debug("result value: {}", (Object)result);
        return result;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        result.add(JSONSettings.ALLOW_COMMENTS);
        result.add(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS);
        result.add(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS);
        result.add(JSONSettings.ALLOW_SINGLE_QUOTES);
        result.add(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS);
        result.add(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES);
        result.add(JSONSettings.ALLOW_YAML_COMMENTS);
        result.add(JSONSettings.ALLOW_TRAILING_COMMA);
        result.add(JSONSettings.INCLUDE_SOURCE_IN_LOCATION);
        result.add(JSONSettings.STRICT_DUPLICATE_DETECTION);
        return result;
    }

    private JsonFactory configureNewJsonFactory() {
        JsonFactory nextJsonFactory = new JsonFactory();
        nextJsonFactory.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        nextJsonFactory.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        nextJsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_COMMENTS)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_SINGLE_QUOTES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_SINGLE_QUOTES)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_YAML_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_YAML_COMMENTS)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_TRAILING_COMMA)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, ((Boolean)this.getParserConfig().get(JSONSettings.ALLOW_TRAILING_COMMA)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.INCLUDE_SOURCE_IN_LOCATION)) {
            nextJsonFactory.configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, ((Boolean)this.getParserConfig().get(JSONSettings.INCLUDE_SOURCE_IN_LOCATION)).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.STRICT_DUPLICATE_DETECTION)) {
            nextJsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, ((Boolean)this.getParserConfig().get(JSONSettings.STRICT_DUPLICATE_DETECTION)).booleanValue());
        }
        return nextJsonFactory;
    }
}

