/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BasicQueryWriterSettings;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

abstract class AbstractSPARQLJSONWriter
extends AbstractQueryResultWriter
implements QueryResultWriter {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    protected boolean firstTupleWritten = false;
    protected boolean documentOpen = false;
    protected boolean headerOpen = false;
    protected boolean headerComplete = false;
    protected boolean tupleVariablesFound = false;
    protected boolean linksFound = false;
    private final JsonGenerator jg;

    public AbstractSPARQLJSONWriter(OutputStream out) {
        try {
            this.jg = JSON_FACTORY.createJsonGenerator((Writer)new OutputStreamWriter(out, Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void endHeader() throws QueryResultHandlerException {
        if (!this.headerComplete) {
            try {
                this.jg.writeEndObject();
                if (this.tupleVariablesFound) {
                    this.jg.writeObjectFieldStart("results");
                    this.jg.writeArrayFieldStart("bindings");
                }
                this.headerComplete = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException((Throwable)e);
            }
        }
    }

    public void startQueryResult(List<String> columnHeaders) throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.tupleVariablesFound = true;
            this.jg.writeArrayFieldStart("vars");
            for (String nextColumn : columnHeaders) {
                this.jg.writeString(nextColumn);
            }
            this.jg.writeEndArray();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Must call startQueryResult before handleSolution");
            }
            this.firstTupleWritten = true;
            this.jg.writeStartObject();
            for (Binding binding : bindingSet) {
                this.jg.writeFieldName(binding.getName());
                this.writeValue(binding.getValue());
            }
            this.jg.writeEndObject();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
            }
            this.jg.writeEndArray();
            this.jg.writeEndObject();
            this.endDocument();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void startDocument() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.documentOpen = true;
            this.headerOpen = false;
            this.headerComplete = false;
            this.tupleVariablesFound = false;
            this.firstTupleWritten = false;
            this.linksFound = false;
            if (((Boolean)this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT)).booleanValue()) {
                DefaultPrettyPrinter.Lf2SpacesIndenter indenter = DefaultPrettyPrinter.Lf2SpacesIndenter.instance.withLinefeed("\n");
                DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
                this.jg.setPrettyPrinter((PrettyPrinter)pp);
            }
            try {
                if (this.getWriterConfig().isSet(BasicQueryWriterSettings.JSONP_CALLBACK)) {
                    String callbackName = (String)this.getWriterConfig().get(BasicQueryWriterSettings.JSONP_CALLBACK);
                    this.jg.writeRaw(callbackName);
                    this.jg.writeRaw("(");
                }
                this.jg.writeStartObject();
            }
            catch (IOException e) {
                throw new QueryResultHandlerException((Throwable)e);
            }
        }
    }

    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    public void startHeader() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            try {
                this.jg.writeObjectFieldStart("head");
                this.headerOpen = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException((Throwable)e);
            }
        }
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.jg.writeArrayFieldStart("link");
            for (String nextLink : linkUrls) {
                this.jg.writeString(nextLink);
            }
            this.jg.writeEndArray();
        }
        catch (IOException e) {
            throw new QueryResultHandlerException((Throwable)e);
        }
    }

    protected void writeValue(Value value) throws IOException, QueryResultHandlerException {
        this.jg.writeStartObject();
        if (value instanceof IRI) {
            this.jg.writeStringField("type", "uri");
            this.jg.writeStringField("value", ((IRI)value).toString());
        } else if (value instanceof BNode) {
            this.jg.writeStringField("type", "bnode");
            this.jg.writeStringField("value", ((BNode)value).getID());
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (Literals.isLanguageLiteral((Literal)lit)) {
                this.jg.writeObjectField("xml:lang", (Object)lit.getLanguage());
            } else {
                boolean ignoreDatatype;
                IRI datatype = lit.getDatatype();
                boolean bl = ignoreDatatype = datatype.equals((Object)XMLSchema.STRING) && this.xsdStringToPlainLiteral();
                if (!ignoreDatatype) {
                    this.jg.writeObjectField("datatype", (Object)lit.getDatatype().stringValue());
                }
            }
            this.jg.writeObjectField("type", (Object)"literal");
            this.jg.writeObjectField("value", (Object)lit.getLabel());
        } else {
            throw new TupleQueryResultHandlerException("Unknown Value object type: " + value.getClass());
        }
        this.jg.writeEndObject();
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        if (!this.headerComplete) {
            this.endHeader();
        }
        if (this.tupleVariablesFound) {
            throw new QueryResultHandlerException("Cannot call handleBoolean after startQueryResults");
        }
        try {
            if (value) {
                this.jg.writeBooleanField("boolean", Boolean.TRUE.booleanValue());
            } else {
                this.jg.writeBooleanField("boolean", Boolean.FALSE.booleanValue());
            }
            this.endDocument();
        }
        catch (IOException e) {
            throw new QueryResultHandlerException((Throwable)e);
        }
    }

    public final Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicQueryWriterSettings.JSONP_CALLBACK);
        result.add(BasicWriterSettings.PRETTY_PRINT);
        result.add(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        return result;
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }

    protected void endDocument() throws IOException {
        this.jg.writeEndObject();
        if (this.getWriterConfig().isSet(BasicQueryWriterSettings.JSONP_CALLBACK)) {
            this.jg.writeRaw(");");
        }
        this.jg.flush();
        this.documentOpen = false;
        this.headerOpen = false;
        this.headerComplete = false;
        this.tupleVariablesFound = false;
        this.firstTupleWritten = false;
        this.linksFound = false;
    }

    static {
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }
}

