/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.experimental;

import java.util.Stack;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.queryrender.RenderUtils;
import org.eclipse.rdf4j.queryrender.sparql.experimental.AbstractSerializableParsedQuery;

class PropertyPathSerializer
extends AbstractQueryModelVisitor<RuntimeException> {
    private StringBuilder builder;
    private Stack<VarInfo> currentSubjectVarStack = new Stack();
    private AbstractSerializableParsedQuery currentQueryProfile;

    PropertyPathSerializer() {
    }

    public String serialize(ArbitraryLengthPath path, AbstractSerializableParsedQuery currentQueryProfile) {
        this.builder = new StringBuilder();
        this.currentQueryProfile = currentQueryProfile;
        Var subjVar = path.getSubjectVar();
        Var objVar = path.getObjectVar();
        if (path.getContextVar() != null) {
            this.builder.append("GRAPH ");
            path.getContextVar().visit((QueryModelVisitor)this);
            this.builder.append(" {");
        }
        subjVar.visit((QueryModelVisitor)this);
        this.builder.append(" ");
        path.visit((QueryModelVisitor)this);
        this.builder.append(" ");
        objVar.visit((QueryModelVisitor)this);
        this.builder.append(" .");
        if (path.getContextVar() != null) {
            this.builder.append(" }");
        }
        this.builder.append(" \n");
        return this.builder.toString().trim();
    }

    public void meet(ArbitraryLengthPath node) throws RuntimeException {
        this.currentSubjectVarStack.push(new VarInfo(node.getSubjectVar(), false));
        this.builder.append("(");
        node.getPathExpression().visit((QueryModelVisitor)this);
        while (!this.currentSubjectVarStack.isEmpty()) {
            VarInfo currentSubjectVar = this.currentSubjectVarStack.pop();
            if (!currentSubjectVar.inverse) continue;
            this.builder.append(")");
        }
        this.builder.append(")");
        if (node.getMinLength() == 0L) {
            this.builder.append("*");
        } else {
            this.builder.append("+");
        }
    }

    public void meet(Join node) throws RuntimeException {
        this.builder.append("(");
        node.getLeftArg().visit((QueryModelVisitor)this);
        this.builder.append("/");
        node.getRightArg().visit((QueryModelVisitor)this);
        this.builder.append(")");
    }

    public void meet(Union node) throws RuntimeException {
        VarInfo currentSubjectVar = this.currentSubjectVarStack.peek();
        boolean containsZeroLength = node.getLeftArg() instanceof ZeroLengthPath;
        if (!containsZeroLength) {
            this.builder.append("(");
        }
        this.currentSubjectVarStack.push(currentSubjectVar);
        node.getLeftArg().visit((QueryModelVisitor)this);
        VarInfo currentObjectVarLeft = this.currentSubjectVarStack.pop();
        if (!containsZeroLength) {
            this.builder.append("|");
        }
        this.currentSubjectVarStack.push(currentSubjectVar);
        node.getRightArg().visit((QueryModelVisitor)this);
        VarInfo currentObjectVarRight = this.currentSubjectVarStack.pop();
        if (currentObjectVarRight.inverse) {
            this.builder.append(")");
        }
        if (!containsZeroLength) {
            this.builder.append(")");
        } else {
            this.builder.append("?");
        }
        this.currentSubjectVarStack.push(currentObjectVarLeft);
    }

    public void meet(StatementPattern node) throws RuntimeException {
        VarInfo subjVar = this.currentSubjectVarStack.peek();
        Var predicate = node.getPredicateVar();
        if (subjVar.var.getName().equals(node.getObjectVar().getName())) {
            this.builder.append("^(");
            this.currentSubjectVarStack.push(new VarInfo(node.getSubjectVar(), true));
        } else {
            this.currentSubjectVarStack.push(new VarInfo(node.getObjectVar(), false));
        }
        if (predicate.hasValue()) {
            this.builder.append(RenderUtils.toSPARQL(node.getPredicateVar().getValue()));
        } else {
            this.builder.append("?");
            this.builder.append(predicate.getName());
        }
    }

    public void meet(Var node) throws RuntimeException {
        if (node.hasValue()) {
            this.builder.append(RenderUtils.toSPARQL(node.getValue()));
        } else if (node.isAnonymous()) {
            if (this.currentQueryProfile.extensionElements.containsKey(node.getName())) {
                ExtensionElem elem = this.currentQueryProfile.extensionElements.get(node.getName());
                elem.getExpr().visit((QueryModelVisitor)this);
            } else {
                this.builder.append("_:");
                this.builder.append(node.getName());
            }
        } else {
            this.builder.append("?");
            this.builder.append(node.getName());
        }
        super.meet(node);
    }

    public void meet(ZeroLengthPath node) throws RuntimeException {
        VarInfo subjVar = this.currentSubjectVarStack.pop();
        if (subjVar.inverse) {
            this.builder.append(")");
        }
        this.currentSubjectVarStack.push(new VarInfo(node.getObjectVar(), false));
    }

    static class VarInfo {
        Var var;
        boolean inverse;

        VarInfo(Var var, boolean inverse) {
            this.var = var;
            this.inverse = inverse;
        }
    }
}

