/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.builder;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.queryrender.builder.BasicGroup;
import org.eclipse.rdf4j.queryrender.builder.FilterBuilder;
import org.eclipse.rdf4j.queryrender.builder.Group;
import org.eclipse.rdf4j.queryrender.builder.SupportsGroups;
import org.eclipse.rdf4j.queryrender.builder.UnionBuilder;

public class GroupBuilder<T extends ParsedQuery, E extends SupportsGroups> {
    private E mBuilder;
    private BasicGroup mGroup;
    private BasicGroup mParent;
    private StatementPattern.Scope mScope = StatementPattern.Scope.DEFAULT_CONTEXTS;
    private Var mContext = null;
    static int cnt = 0;

    public GroupBuilder(E theBuilder) {
        this(theBuilder, false, null);
    }

    public GroupBuilder(E theBuilder, boolean theOptional) {
        this(theBuilder, theOptional, null);
    }

    public int size() {
        return this.mGroup.size();
    }

    public GroupBuilder(E theBuilder, boolean theOptional, BasicGroup theParent) {
        this.mBuilder = theBuilder;
        this.mGroup = new BasicGroup(theOptional);
        if (theParent == null) {
            if (this.mBuilder != null) {
                this.mBuilder.addGroup(this.mGroup);
            }
        } else {
            this.mParent = theParent;
            theParent.addChild(this.mGroup);
        }
    }

    public Group getGroup() {
        return this.mGroup;
    }

    public GroupBuilder<T, E> group() {
        return new GroupBuilder<T, E>(this.mBuilder, false, this.mGroup);
    }

    public GroupBuilder<T, E> optional() {
        return new GroupBuilder<T, E>(this.mBuilder, true, this.mGroup);
    }

    public E closeGroup() {
        if (this.mGroup.isEmpty()) {
            if (this.mParent != null) {
                this.mParent.removeChild(this.mGroup);
            } else {
                this.mBuilder.removeGroup(this.mGroup);
            }
        }
        return this.mBuilder;
    }

    public UnionBuilder<T, E> union() {
        UnionBuilder aBuilder = new UnionBuilder(this);
        this.mGroup.addChild(aBuilder);
        return aBuilder;
    }

    public GroupBuilder<T, E> setScope(StatementPattern.Scope theScope) {
        this.mScope = theScope;
        for (StatementPattern aPattern : this.mGroup.getPatterns()) {
            aPattern.setScope(this.mScope);
        }
        return this;
    }

    public GroupBuilder<T, E> setContext(String theContextVar) {
        this.mContext = new Var(theContextVar);
        return this;
    }

    public GroupBuilder<T, E> setContext(Value theContextValue) {
        this.mContext = GroupBuilder.valueToVar(theContextValue);
        for (StatementPattern aPattern : this.mGroup.getPatterns()) {
            aPattern.setContextVar(this.mContext);
        }
        return this;
    }

    public FilterBuilder<T, E> filter() {
        return new FilterBuilder(this);
    }

    public GroupBuilder<T, E> filter(ValueExpr theExpr) {
        this.mGroup.addFilter(theExpr);
        return this;
    }

    public GroupBuilder<T, E> filter(String theVar, Compare.CompareOp theOp, Value theValue) {
        Compare aComp = new Compare((ValueExpr)new Var(theVar), (ValueExpr)new ValueConstant(theValue), theOp);
        this.mGroup.addFilter((ValueExpr)aComp);
        return this;
    }

    public GroupBuilder<T, E> atom(StatementPattern thePattern) {
        return this.addPattern(thePattern);
    }

    public GroupBuilder<T, E> atom(StatementPattern ... thePatterns) {
        return this.atoms(new HashSet<StatementPattern>(Arrays.asList(thePatterns)));
    }

    public GroupBuilder<T, E> atoms(Set<StatementPattern> thePatterns) {
        for (StatementPattern aPattern : thePatterns) {
            aPattern.setContextVar(this.mContext);
            aPattern.setScope(this.mScope);
        }
        this.mGroup.addAll(thePatterns);
        return this;
    }

    public GroupBuilder<T, E> atom(String theSubjVar, String thePredVar, String theObjVar) {
        return this.addPattern(this.newPattern(new Var(theSubjVar), new Var(thePredVar), new Var(theObjVar)));
    }

    public GroupBuilder<T, E> atom(String theSubjVar, String thePredVar, Value theObj) {
        return this.addPattern(this.newPattern(new Var(theSubjVar), new Var(thePredVar), GroupBuilder.valueToVar(theObj)));
    }

    public GroupBuilder<T, E> atom(String theSubjVar, Value thePredVar, String theObj) {
        return this.addPattern(this.newPattern(new Var(theSubjVar), GroupBuilder.valueToVar(thePredVar), new Var(theObj)));
    }

    public GroupBuilder<T, E> atom(String theSubjVar, Value thePred, Value theObj) {
        return this.addPattern(this.newPattern(new Var(theSubjVar), GroupBuilder.valueToVar(thePred), GroupBuilder.valueToVar(theObj)));
    }

    public GroupBuilder<T, E> atom(Value theSubjVar, Value thePredVar, Value theObj) {
        return this.addPattern(this.newPattern(GroupBuilder.valueToVar(theSubjVar), GroupBuilder.valueToVar(thePredVar), GroupBuilder.valueToVar(theObj)));
    }

    public GroupBuilder<T, E> atom(Value theSubjVar, Value thePredVar, String theObj) {
        return this.addPattern(this.newPattern(GroupBuilder.valueToVar(theSubjVar), GroupBuilder.valueToVar(thePredVar), new Var(theObj)));
    }

    public GroupBuilder<T, E> atom(Value theSubjVar, String thePredVar, String theObj) {
        return this.addPattern(this.newPattern(GroupBuilder.valueToVar(theSubjVar), new Var(thePredVar), new Var(theObj)));
    }

    private GroupBuilder<T, E> addPattern(StatementPattern thePattern) {
        thePattern.setContextVar(this.mContext);
        thePattern.setScope(this.mScope);
        this.mGroup.add((TupleExpr)thePattern);
        return this;
    }

    private StatementPattern newPattern(Var theSubj, Var thePred, Var theObj) {
        return new StatementPattern(this.mScope, theSubj, thePred, theObj, this.mContext);
    }

    public static Var valueToVar(Value theValue) {
        Var aVar = new Var("var" + cnt++, theValue);
        aVar.setAnonymous(true);
        return aVar;
    }
}

