/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.serql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.serql.SeRQLUtil;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLiteral;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQueryContainer;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTString;
import org.eclipse.rdf4j.query.parser.serql.ast.VisitorException;

class StringEscapesProcessor {
    StringEscapesProcessor() {
    }

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        StringProcessor visitor = new StringProcessor();
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    private static class StringProcessor
    extends AbstractASTVisitor {
        @Override
        public Object visit(ASTString stringNode, Object data) throws VisitorException {
            String value = stringNode.getValue();
            try {
                value = SeRQLUtil.decodeString(value);
                stringNode.setValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            return super.visit(stringNode, data);
        }

        @Override
        public Object visit(ASTLiteral literalNode, Object data) throws VisitorException {
            String label = literalNode.getLabel();
            try {
                label = SeRQLUtil.decodeString(label);
                literalNode.setLabel(label);
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            return super.visit(literalNode, data);
        }
    }
}

