/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser;

import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParser;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.query.parser.QueryPrologLexer;

public class QueryParserUtil {
    public static QueryParser createParser(QueryLanguage ql) throws UnsupportedQueryLanguageException {
        QueryParserFactory factory = (QueryParserFactory)QueryParserRegistry.getInstance().get(ql).orElseThrow(() -> new UnsupportedQueryLanguageException("No factory available for query language " + String.valueOf(ql)));
        return factory.getParser();
    }

    public static ParsedOperation parseOperation(QueryLanguage ql, String operation, String baseURI) throws MalformedQueryException {
        String strippedOperation;
        QueryParser parser = QueryParserUtil.createParser(ql);
        ParsedOperation parsedOperation = QueryLanguage.SPARQL.equals((Object)ql) ? ((strippedOperation = QueryParserUtil.removeSPARQLQueryProlog(operation).toUpperCase()).startsWith("SELECT") || strippedOperation.startsWith("CONSTRUCT") || strippedOperation.startsWith("DESCRIBE") || strippedOperation.startsWith("ASK") ? parser.parseQuery(operation, baseURI) : parser.parseUpdate(operation, baseURI)) : parser.parseQuery(operation, baseURI);
        return parsedOperation;
    }

    public static ParsedUpdate parseUpdate(QueryLanguage ql, String update, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        QueryParser parser = QueryParserUtil.createParser(ql);
        return parser.parseUpdate(update, baseURI);
    }

    public static ParsedQuery parseQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        QueryParser parser = QueryParserUtil.createParser(ql);
        return parser.parseQuery(query, baseURI);
    }

    public static ParsedTupleQuery parseTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedTupleQuery) {
            return (ParsedTupleQuery)q;
        }
        throw new IllegalArgumentException("query is not a tuple query: " + query);
    }

    public static ParsedGraphQuery parseGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedGraphQuery) {
            return (ParsedGraphQuery)q;
        }
        throw new IllegalArgumentException("query is not a graph query: " + query);
    }

    public static ParsedBooleanQuery parseBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedBooleanQuery) {
            return (ParsedBooleanQuery)q;
        }
        throw new IllegalArgumentException("query is not a boolean query: " + query);
    }

    public static String removeSPARQLQueryProlog(String queryString) {
        QueryPrologLexer.Token t = QueryPrologLexer.getRestOfQueryToken(queryString);
        if (t != null) {
            return t.getStringValue();
        }
        return queryString;
    }
}

