/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;

public class ProjectionElemList
extends AbstractQueryModelNode {
    private ProjectionElem[] elements = new ProjectionElem[0];
    private List<ProjectionElem> elementsList = Collections.emptyList();

    public ProjectionElemList() {
    }

    public ProjectionElemList(ProjectionElem ... elements) {
        this.addElements(elements);
    }

    public ProjectionElemList(Iterable<ProjectionElem> elements) {
        this.addElements(elements);
    }

    public List<ProjectionElem> getElements() {
        return this.elementsList;
    }

    public void setElements(List<ProjectionElem> elements) {
        this.elementsList = Collections.unmodifiableList(elements);
        this.elements = this.elementsList.toArray(new ProjectionElem[0]);
    }

    public void addElements(ProjectionElem ... elements) {
        this.addElements(List.of(elements));
    }

    public void addElements(Iterable<ProjectionElem> elements) {
        this.addElements(StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList()));
    }

    public void addElements(List<ProjectionElem> elements) {
        if (this.elementsList.isEmpty()) {
            this.setElements(elements);
        } else {
            ArrayList<ProjectionElem> currentElementsList = new ArrayList<ProjectionElem>(this.elementsList);
            for (ProjectionElem projectionElem : elements) {
                projectionElem.setParentNode(this);
            }
            currentElementsList.addAll(elements);
            this.setElements(currentElementsList);
        }
    }

    public void addElement(ProjectionElem pe) {
        assert (pe != null) : "pe must not be null";
        ArrayList<ProjectionElem> currentElementsList = new ArrayList<ProjectionElem>(this.elementsList);
        currentElementsList.add(pe);
        this.setElements(currentElementsList);
        pe.setParentNode(this);
    }

    public Set<String> getTargetNames() {
        LinkedHashSet<String> targetNames = new LinkedHashSet<String>(this.elementsList.size());
        for (ProjectionElem pe : this.elementsList) {
            targetNames.add(pe.getTargetName());
        }
        return targetNames;
    }

    public Set<String> getTargetNamesFor(Collection<String> sourceNames) {
        LinkedHashSet<String> targetNames = new LinkedHashSet<String>(this.elementsList.size());
        for (ProjectionElem pe : this.elementsList) {
            if (!sourceNames.contains(pe.getSourceName())) continue;
            targetNames.add(pe.getTargetName());
        }
        return targetNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        ArrayList<ProjectionElem> currentElementsList = new ArrayList<ProjectionElem>(this.elementsList);
        if (this.replaceNodeInList(currentElementsList, current, replacement)) {
            this.setElements(currentElementsList);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProjectionElemList) {
            ProjectionElemList o = (ProjectionElemList)other;
            return this.elementsList.equals(o.getElements());
        }
        return false;
    }

    public int hashCode() {
        return this.elementsList.hashCode();
    }

    @Override
    public ProjectionElemList clone() {
        ProjectionElemList clone = (ProjectionElemList)super.clone();
        clone.elements = new ProjectionElem[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            clone.elements[i] = this.elements[i].clone();
            clone.elements[i].setParentNode(clone);
        }
        clone.elementsList = List.of(clone.elements);
        return clone;
    }
}

