/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class TupleExprs {
    public static boolean containsProjection(TupleExpr t) {
        class VisitException
        extends Exception {
            VisitException() {
                super(null, null, false, false);
            }
        }
        final boolean[] result = new boolean[1];
        try {
            t.visit(new AbstractQueryModelVisitor<VisitException>(){

                @Override
                public void meet(Projection node) throws VisitException {
                    result[0] = true;
                    throw new VisitException();
                }

                @Override
                public void meet(Join node) throws VisitException {
                    result[0] = false;
                    throw new VisitException();
                }
            });
        }
        catch (VisitException visitException) {
            // empty catch block
        }
        return result[0];
    }

    public static Var createConstVar(Value value) {
        String varName = TupleExprs.getConstVarName(value);
        Var var = new Var(varName);
        var.setConstant(true);
        var.setAnonymous(true);
        var.setValue(value);
        return var;
    }

    public static String getConstVarName(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        String uniqueStringForValue = Integer.toHexString(value.stringValue().hashCode());
        if (value instanceof Literal) {
            uniqueStringForValue = uniqueStringForValue + "_lit";
            Literal lit = (Literal)value;
            if (lit.getDatatype() != null) {
                uniqueStringForValue = uniqueStringForValue + "_" + Integer.toHexString(lit.getDatatype().hashCode());
            }
            if (lit.getLanguage() != null) {
                uniqueStringForValue = uniqueStringForValue + "_" + Integer.toHexString(lit.getLanguage().hashCode());
            }
        } else {
            uniqueStringForValue = value instanceof BNode ? uniqueStringForValue + "_node" : uniqueStringForValue + "_uri";
        }
        return "_const_" + uniqueStringForValue;
    }
}

