/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;

public class Slice
extends UnaryTupleOperator {
    private long offset;
    private long limit;

    public Slice() {
    }

    public Slice(TupleExpr arg) {
        this(arg, 0L, -1L);
    }

    public Slice(TupleExpr arg, long offset2, long limit2) {
        super(arg);
        this.setOffset(offset2);
        this.setLimit(limit2);
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean hasOffset() {
        return this.offset > 0L;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public boolean hasLimit() {
        return this.limit >= 0L;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(super.getSignature());
        sb.append(" ( ");
        if (this.hasLimit()) {
            sb.append("limit=").append(this.getLimit());
        }
        if (this.hasOffset()) {
            sb.append("offset=").append(this.getOffset());
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Slice && super.equals(other)) {
            Slice o = (Slice)other;
            return this.offset == o.getOffset() && this.limit == o.getLimit();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.offset ^ (int)this.limit;
    }

    @Override
    public Slice clone() {
        return (Slice)super.clone();
    }
}

