/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import java.util.Objects;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.ValidatingValueFactory;

public class Values {
    private static final ValueFactory VALUE_FACTORY = new ValidatingValueFactory((ValueFactory)SimpleValueFactory.getInstance());

    private Values() {
    }

    public static IRI iri(String iri) throws IllegalArgumentException {
        return Values.iri(VALUE_FACTORY, iri);
    }

    public static IRI iri(ValueFactory vf, String iri) throws IllegalArgumentException {
        return vf.createIRI(Objects.requireNonNull(iri, "iri may not be null"));
    }

    public static IRI iri(String namespace, String localName) throws IllegalArgumentException {
        return Values.iri(VALUE_FACTORY, namespace, localName);
    }

    public static IRI iri(Namespace namespace, String localName) throws IllegalArgumentException {
        return Values.iri(VALUE_FACTORY, Objects.requireNonNull(namespace.getName()), localName);
    }

    public static IRI iri(Iterable<Namespace> namespaces, String prefixedName) throws IllegalArgumentException {
        if (prefixedName.indexOf(58) < 0) {
            throw new IllegalArgumentException("Invalid prefixed name: '" + prefixedName + "'");
        }
        String prefix = prefixedName.substring(0, prefixedName.indexOf(58));
        for (Namespace ns : namespaces) {
            if (!prefix.equals(ns.getPrefix())) continue;
            return Values.iri(ns.getName(), prefixedName.substring(prefixedName.indexOf(58) + 1));
        }
        throw new IllegalArgumentException("Prefix '" + prefix + "' not identified in supplied namespaces");
    }

    public static IRI iri(ValueFactory vf, String namespace, String localName) throws IllegalArgumentException {
        return vf.createIRI(Objects.requireNonNull(namespace, "namespace may not be null"), Objects.requireNonNull(localName, "localName may not be null"));
    }

    public static BNode bnode() {
        return Values.bnode(VALUE_FACTORY);
    }

    public static BNode bnode(ValueFactory vf) {
        return vf.createBNode();
    }

    public static BNode bnode(String nodeId) throws IllegalArgumentException {
        return Values.bnode(VALUE_FACTORY, nodeId);
    }

    public static BNode bnode(ValueFactory vf, String nodeId) throws IllegalArgumentException {
        return vf.createBNode(Objects.requireNonNull(nodeId, "nodeId may not be null"));
    }

    public static Literal literal(String lexicalValue) {
        return Values.literal(VALUE_FACTORY, lexicalValue);
    }

    public static Literal literal(ValueFactory vf, String lexicalValue) {
        return vf.createLiteral(Objects.requireNonNull(lexicalValue, "lexicalValue may not be null"));
    }

    public static Literal literal(String lexicalValue, String languageTag) {
        return Values.literal(VALUE_FACTORY, lexicalValue, languageTag);
    }

    public static Literal literal(ValueFactory vf, String lexicalValue, String languageTag) {
        return vf.createLiteral(Objects.requireNonNull(lexicalValue, "lexicalValue may not be null"), Objects.requireNonNull(languageTag, "languageTag may not be null"));
    }

    public static Literal literal(String lexicalValue, IRI datatype) throws IllegalArgumentException {
        return Values.literal(VALUE_FACTORY, lexicalValue, datatype);
    }

    public static Literal literal(String lexicalValue, CoreDatatype datatype) throws IllegalArgumentException {
        return Values.literal(VALUE_FACTORY, lexicalValue, datatype);
    }

    public static Literal literal(ValueFactory vf, String lexicalValue, IRI datatype) throws IllegalArgumentException {
        return vf.createLiteral(Objects.requireNonNull(lexicalValue, "lexicalValue may not be null"), Objects.requireNonNull(datatype, "datatype may not be null"));
    }

    public static Literal literal(ValueFactory vf, String lexicalValue, CoreDatatype datatype) throws IllegalArgumentException {
        return vf.createLiteral(Objects.requireNonNull(lexicalValue, "lexicalValue may not be null"), Objects.requireNonNull(datatype, "datatype may not be null"));
    }

    public static Literal literal(boolean booleanValue) {
        return Values.literal(VALUE_FACTORY, booleanValue);
    }

    public static Literal literal(ValueFactory vf, boolean booleanValue) {
        return vf.createLiteral(booleanValue);
    }

    public static Literal literal(byte byteValue) {
        return Values.literal(VALUE_FACTORY, byteValue);
    }

    public static Literal literal(ValueFactory vf, byte byteValue) {
        return vf.createLiteral(byteValue);
    }

    public static Literal literal(short shortValue) {
        return Values.literal(VALUE_FACTORY, shortValue);
    }

    public static Literal literal(ValueFactory vf, short shortValue) {
        return vf.createLiteral(shortValue);
    }

    public static Literal literal(int intValue) {
        return Values.literal(VALUE_FACTORY, intValue);
    }

    public static Literal literal(ValueFactory vf, int intValue) {
        return vf.createLiteral(intValue);
    }

    public static Literal literal(long longValue) {
        return Values.literal(VALUE_FACTORY, longValue);
    }

    public static Literal literal(ValueFactory vf, long longValue) {
        return vf.createLiteral(longValue);
    }

    public static Literal literal(float floatValue) {
        return Values.literal(VALUE_FACTORY, floatValue);
    }

    public static Literal literal(ValueFactory vf, float floatValue) {
        return vf.createLiteral(floatValue);
    }

    public static Literal literal(double doubleValue) {
        return Values.literal(VALUE_FACTORY, doubleValue);
    }

    public static Literal literal(ValueFactory vf, double doubleValue) {
        return vf.createLiteral(doubleValue);
    }

    public static Literal literal(BigDecimal bigDecimal) {
        return Values.literal(VALUE_FACTORY, bigDecimal);
    }

    public static Literal literal(ValueFactory vf, BigDecimal bigDecimal) {
        return vf.createLiteral(Objects.requireNonNull(bigDecimal, "bigDecimal may not be null"));
    }

    public static Literal literal(BigInteger bigInteger) {
        return Values.literal(VALUE_FACTORY, bigInteger);
    }

    public static Literal literal(ValueFactory vf, BigInteger bigInteger) {
        return vf.createLiteral(Objects.requireNonNull(bigInteger, "bigInteger may not be null"));
    }

    public static Literal literal(TemporalAccessor value) throws IllegalArgumentException {
        return Values.literal(VALUE_FACTORY, value);
    }

    public static Literal literal(ValueFactory vf, TemporalAccessor value) throws IllegalArgumentException {
        return vf.createLiteral(Objects.requireNonNull(value, "value may not be null"));
    }

    public static Literal literal(Object object) {
        return Values.literal(VALUE_FACTORY, object, false);
    }

    public static Literal literal(Object object, boolean failOnUnknownType) {
        return Values.literal(VALUE_FACTORY, object, failOnUnknownType);
    }

    public static Literal literal(ValueFactory vf, Object object, boolean failOnUnknownType) {
        return Values.createLiteralFromObject(vf, object, failOnUnknownType);
    }

    public static Triple triple(Resource subject, IRI predicate, Value object) {
        return Values.triple(VALUE_FACTORY, subject, predicate, object);
    }

    public static Triple triple(ValueFactory vf, Resource subject, IRI predicate, Value object) {
        return vf.createTriple(Objects.requireNonNull(subject, "subject may not be null"), Objects.requireNonNull(predicate, "predicate may not be null"), Objects.requireNonNull(object, "object may not be null"));
    }

    public static Triple triple(Statement statement) {
        Objects.requireNonNull(statement, "statement may not be null");
        return VALUE_FACTORY.createTriple(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    public static Triple triple(ValueFactory vf, Statement statement) {
        Objects.requireNonNull(statement, "statement may not be null");
        return vf.createTriple(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    public static Namespace namespace(String prefix, String name) {
        return new SimpleNamespace(prefix, name);
    }

    public static ValueFactory getValueFactory() {
        return VALUE_FACTORY;
    }

    private static Literal createLiteralFromObject(ValueFactory valueFactory, Object object, boolean throwExceptionOnFailure) throws IllegalArgumentException {
        Objects.requireNonNull(valueFactory, "valueFactory may not be null");
        Objects.requireNonNull(object, "object may not be null");
        if (object instanceof Boolean) {
            return valueFactory.createLiteral(((Boolean)object).booleanValue());
        }
        if (object instanceof Byte) {
            return valueFactory.createLiteral(((Byte)object).byteValue());
        }
        if (object instanceof Double) {
            return valueFactory.createLiteral(((Double)object).doubleValue());
        }
        if (object instanceof Float) {
            return valueFactory.createLiteral(((Float)object).floatValue());
        }
        if (object instanceof BigDecimal) {
            return valueFactory.createLiteral((BigDecimal)object);
        }
        if (object instanceof Integer) {
            return valueFactory.createLiteral(((Integer)object).intValue());
        }
        if (object instanceof BigInteger) {
            return valueFactory.createLiteral((BigInteger)object);
        }
        if (object instanceof Long) {
            return valueFactory.createLiteral(((Long)object).longValue());
        }
        if (object instanceof Short) {
            return valueFactory.createLiteral(((Short)object).shortValue());
        }
        if (object instanceof XMLGregorianCalendar) {
            return valueFactory.createLiteral((XMLGregorianCalendar)object);
        }
        if (object instanceof Date) {
            return valueFactory.createLiteral((Date)object);
        }
        if (object instanceof TemporalAccessor) {
            return valueFactory.createLiteral((TemporalAccessor)object);
        }
        if (object instanceof TemporalAmount) {
            return valueFactory.createLiteral((TemporalAmount)object);
        }
        if (object instanceof String) {
            return valueFactory.createLiteral(object.toString(), (CoreDatatype)CoreDatatype.XSD.STRING);
        }
        if (throwExceptionOnFailure) {
            throw new IllegalArgumentException("Unrecognized object type: " + object);
        }
        return valueFactory.createLiteral(object.toString(), (CoreDatatype)CoreDatatype.XSD.STRING);
    }
}

