/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.ContextStatement;
import org.eclipse.rdf4j.model.impl.FilteredModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.util.PatternIterator;

public class LinkedHashModel
extends AbstractModel {
    private static final long serialVersionUID = -9161104123818983614L;
    static final Resource[] NULL_CTX = new Resource[]{null};
    Set<Namespace> namespaces = new LinkedHashSet<Namespace>();
    transient Map<Value, ModelNode> values;
    transient Set<ModelStatement> statements;

    public LinkedHashModel() {
        this(128);
    }

    public LinkedHashModel(Model model) {
        this(model.getNamespaces());
        this.addAll(model);
    }

    public LinkedHashModel(Collection<? extends Statement> c) {
        this(c.size());
        this.addAll(c);
    }

    public LinkedHashModel(int size) {
        this.values = new HashMap<Value, ModelNode>(size, 0.75f);
        this.statements = new LinkedHashSet<ModelStatement>(size * 2, 0.75f);
    }

    public LinkedHashModel(Set<Namespace> namespaces, Collection<? extends Statement> c) {
        this(c);
        this.namespaces.addAll(namespaces);
    }

    public LinkedHashModel(Set<Namespace> namespaces) {
        this();
        this.namespaces.addAll(namespaces);
    }

    public LinkedHashModel(Set<Namespace> namespaces, int size) {
        this(size);
        this.namespaces.addAll(namespaces);
    }

    @Override
    public Optional<Namespace> getNamespace(String prefix) {
        for (Namespace nextNamespace : this.namespaces) {
            if (!prefix.equals(nextNamespace.getPrefix())) continue;
            return Optional.of(nextNamespace);
        }
        return Optional.empty();
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Namespace setNamespace(String prefix, String name) {
        this.removeNamespace(prefix);
        SimpleNamespace result = new SimpleNamespace(prefix, name);
        this.namespaces.add(result);
        return result;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.removeNamespace(namespace.getPrefix());
        this.namespaces.add(namespace);
    }

    @Override
    public Optional<Namespace> removeNamespace(String prefix) {
        Optional<Namespace> result = this.getNamespace(prefix);
        if (result.isPresent()) {
            this.namespaces.remove(result.get());
        }
        return result;
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (subj == null || pred == null || obj == null) {
            throw new UnsupportedOperationException("Incomplete statement");
        }
        Resource[] ctxs = this.notNull(contexts);
        if (ctxs.length == 0) {
            ctxs = NULL_CTX;
        }
        boolean changed = false;
        for (Resource ctx : ctxs) {
            ModelNode<Resource> s = this.asNode(subj);
            ModelNode<IRI> p = this.asNode(pred);
            ModelNode<Value> o = this.asNode(obj);
            ModelNode<Resource> c = this.asNode(ctx);
            ModelStatement st = new ModelStatement(s, p, o, c);
            changed |= this.addModelStatement(st);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.values.clear();
        this.statements.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Statement) {
            if (o instanceof ModelStatement) {
                return this.statements.contains(o);
            }
            return this.find((Statement)o).hasNext();
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return this.matchPattern(null, null, null, new Resource[0]);
    }

    @Override
    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.matchPattern(subj, pred, obj, contexts).hasNext();
    }

    @Override
    public boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (this.isEmpty()) {
            return false;
        }
        ModelIterator iter = this.matchPattern(subj, pred, obj, contexts);
        if (!iter.hasNext()) {
            return false;
        }
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        return true;
    }

    @Override
    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return new FilteredModel(this, subj, pred, obj, contexts){
            private static final long serialVersionUID = 396293781006255959L;

            @Override
            public Iterator iterator() {
                return LinkedHashModel.this.matchPattern(this.subj, this.pred, this.obj, this.contexts);
            }

            @Override
            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                LinkedHashModel.this.removeTermIteration((Iterator)iter, subj, pred, obj, contexts);
            }
        };
    }

    public void removeTermIteration(Iterator iterator, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        Set<ModelStatement> owner = ((ModelIterator)iterator).getOwner();
        Set<ModelStatement> chosen = this.choose(subj, pred, obj, contexts);
        Iterator<ModelStatement> iter = chosen.iterator();
        iter = new PatternIterator<ModelStatement>(iter, subj, pred, obj, contexts);
        while (iter.hasNext()) {
            ModelStatement last = iter.next();
            if (this.statements == owner) {
                this.statements = new LinkedHashSet<ModelStatement>(this.statements);
                this.statements.remove(last);
            } else if (this.statements != chosen) {
                this.statements.remove(last);
            }
            if (last.subj.subjects == owner) {
                last.subj.subjects = new LinkedHashSet<ModelStatement>(last.subj.subjects);
                last.subj.subjects.remove(last);
            } else if (last.subj.subjects != chosen) {
                last.subj.subjects.remove(last);
            }
            if (last.pred.predicates == owner) {
                last.pred.predicates = new LinkedHashSet<ModelStatement>(this.statements);
                last.pred.predicates.remove(last);
            } else if (last.pred.predicates != chosen) {
                last.pred.predicates.remove(last);
            }
            if (last.obj.objects == owner) {
                last.obj.objects = new LinkedHashSet<ModelStatement>(this.statements);
                last.obj.objects.remove(last);
            } else if (last.obj.objects != chosen) {
                last.obj.objects.remove(last);
            }
            if (last.ctx.contexts == owner) {
                last.ctx.contexts = new LinkedHashSet<ModelStatement>(this.statements);
                last.ctx.contexts.remove(last);
            } else if (last.ctx.contexts != chosen) {
                last.ctx.contexts.remove(last);
            }
            if (owner == chosen) continue;
            iter.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.statements.size());
        for (ModelStatement st : this.statements) {
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            Resource ctx = st.getContext();
            s.writeObject(new ContextStatement(subj, pred, obj, ctx));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.values = new HashMap<Value, ModelNode>(size * 2);
        this.statements = new LinkedHashSet<ModelStatement>(size);
        for (int i = 0; i < size; ++i) {
            Statement st = (Statement)s.readObject();
            this.add(st);
        }
    }

    private ModelIterator matchPattern(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        Set<ModelStatement> set = this.choose(subj, pred, obj, contexts);
        Iterator<ModelStatement> it = set.iterator();
        PatternIterator<ModelStatement> iter = new PatternIterator<ModelStatement>(it, subj, pred, obj, contexts);
        return new ModelIterator(iter, set);
    }

    private Set<ModelStatement> choose(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        contexts = this.notNull(contexts);
        Set<ModelStatement> s = null;
        Set<ModelStatement> p = null;
        Set<ModelStatement> o = null;
        if (subj != null) {
            if (!this.values.containsKey(subj)) {
                return Collections.emptySet();
            }
            s = this.values.get((Object)subj).subjects;
        }
        if (pred != null) {
            if (!this.values.containsKey(pred)) {
                return Collections.emptySet();
            }
            p = this.values.get((Object)pred).predicates;
        }
        if (obj != null) {
            if (!this.values.containsKey(obj)) {
                return Collections.emptySet();
            }
            o = this.values.get((Object)obj).objects;
        }
        if (contexts.length == 1) {
            if (!this.values.containsKey(contexts[0])) {
                return Collections.emptySet();
            }
            Set<ModelStatement> c = this.values.get((Object)contexts[0]).contexts;
            return this.smallest(this.statements, s, p, o, c);
        }
        return this.smallest(this.statements, s, p, o);
    }

    private Resource[] notNull(Resource[] contexts) {
        if (contexts == null) {
            return new Resource[]{null};
        }
        return contexts;
    }

    private Iterator find(Statement st) {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        Resource ctx = st.getContext();
        return this.matchPattern(subj, pred, obj, ctx);
    }

    private boolean addModelStatement(ModelStatement st) {
        Set<ModelStatement> subj = st.subj.subjects;
        Set<ModelStatement> pred = st.pred.predicates;
        Set<ModelStatement> obj = st.obj.objects;
        Set<ModelStatement> ctx = st.ctx.contexts;
        if (this.smallest(subj, pred, obj, ctx).contains(st)) {
            return false;
        }
        this.statements.add(st);
        subj.add(st);
        pred.add(st);
        obj.add(st);
        ctx.add(st);
        return true;
    }

    private Set<ModelStatement> smallest(Set<ModelStatement> ... sets) {
        int minSize = Integer.MAX_VALUE;
        Set<ModelStatement> minSet = null;
        for (Set<ModelStatement> set : sets) {
            if (set == null || set.size() >= minSize) continue;
            minSet = set;
            minSize = set.size();
        }
        return minSet;
    }

    private <V extends Value> ModelNode<V> asNode(V value) {
        ModelNode<V> node = this.values.get(value);
        if (node != null) {
            return node;
        }
        node = new ModelNode<V>(value);
        this.values.put(value, node);
        return node;
    }

    private static class ModelStatement
    extends ContextStatement {
        private static final long serialVersionUID = 2200404772364346279L;
        ModelNode<Resource> subj;
        ModelNode<IRI> pred;
        ModelNode<Value> obj;
        ModelNode<Resource> ctx;

        public ModelStatement(ModelNode<Resource> subj, ModelNode<IRI> pred, ModelNode<Value> obj, ModelNode<Resource> ctx) {
            super(subj.getValue(), pred.getValue(), obj.getValue(), ctx.getValue());
            assert (subj != null);
            assert (pred != null);
            assert (obj != null);
            assert (ctx != null);
            this.subj = subj;
            this.pred = pred;
            this.obj = obj;
            this.ctx = ctx;
        }

        @Override
        public Resource getSubject() {
            return this.subj.getValue();
        }

        @Override
        public IRI getPredicate() {
            return this.pred.getValue();
        }

        @Override
        public Value getObject() {
            return this.obj.getValue();
        }

        @Override
        public Resource getContext() {
            return this.ctx.getValue();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            if (this.getContext() == null) {
                return ((Statement)other).getContext() == null;
            }
            return this.getContext().equals(((Statement)other).getContext());
        }
    }

    private static class ModelNode<V extends Value>
    implements Serializable {
        private static final long serialVersionUID = -1205676084606998540L;
        Set<ModelStatement> subjects = new LinkedHashSet<ModelStatement>();
        Set<ModelStatement> predicates = new LinkedHashSet<ModelStatement>();
        Set<ModelStatement> objects = new LinkedHashSet<ModelStatement>();
        Set<ModelStatement> contexts = new LinkedHashSet<ModelStatement>();
        private V value;

        public ModelNode(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }
    }

    private class ModelIterator
    implements Iterator<ModelStatement> {
        private Iterator<ModelStatement> iter;
        private Set<ModelStatement> owner;
        private ModelStatement last;

        public ModelIterator(Iterator<ModelStatement> iter, Set<ModelStatement> owner) {
            this.iter = iter;
            this.owner = owner;
        }

        public Set<ModelStatement> getOwner() {
            return this.owner;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ModelStatement next() {
            this.last = this.iter.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.removeFrom(LinkedHashModel.this.statements);
            this.removeFrom(this.last.subj.subjects);
            this.removeFrom(this.last.pred.predicates);
            this.removeFrom(this.last.obj.objects);
            this.removeFrom(this.last.ctx.contexts);
            this.iter.remove();
        }

        private void removeFrom(Set<ModelStatement> subjects) {
            if (subjects != this.owner) {
                subjects.remove(this.last);
            }
        }
    }
}

