/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.ModelException;

public class Models {
    protected Models() {
    }

    public static Optional<Value> object(Model m) {
        return m.stream().map(st -> st.getObject()).findAny();
    }

    @Deprecated
    public static Value anyObject(Model m) {
        return Models.object(m).orElse(null);
    }

    public static Optional<Literal> objectLiteral(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof Literal).map(l -> (Literal)l).findAny();
    }

    public static Set<Literal> objectLiterals(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof Literal).map(l -> (Literal)l).collect(Collectors.toSet());
    }

    @Deprecated
    public static Literal anyObjectLiteral(Model m) {
        return Models.objectLiteral(m).orElse(null);
    }

    public static Optional<Resource> objectResource(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof Resource).map(r -> (Resource)r).findAny();
    }

    public static Set<Resource> objectResources(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof Resource).map(r -> (Resource)r).collect(Collectors.toSet());
    }

    @Deprecated
    public static Resource anyObjectResource(Model m) {
        return Models.objectResource(m).orElse(null);
    }

    public static Optional<IRI> objectIRI(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).findAny();
    }

    public static Set<IRI> objectIRIs(Model m) {
        return m.stream().map(st -> st.getObject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).collect(Collectors.toSet());
    }

    public static Optional<String> objectString(Model m) {
        return m.stream().map(st -> st.getObject().stringValue()).findAny();
    }

    public static Set<String> objectStrings(Model m) {
        return m.stream().map(st -> st.getObject().stringValue()).collect(Collectors.toSet());
    }

    @Deprecated
    public static URI anyObjectURI(Model m) {
        return Models.objectIRI(m).orElse(null);
    }

    public static Optional<Resource> subject(Model m) {
        return m.stream().map(st -> st.getSubject()).findAny();
    }

    @Deprecated
    public static Resource anySubject(Model m) {
        return Models.subject(m).orElse(null);
    }

    public static Optional<IRI> subjectIRI(Model m) {
        return m.stream().map(st -> st.getSubject()).filter(s -> s instanceof IRI).map(s -> (IRI)s).findAny();
    }

    public static Set<IRI> subjectIRIs(Model m) {
        return m.subjects().stream().filter(s -> s instanceof IRI).map(s -> (IRI)s).collect(Collectors.toSet());
    }

    @Deprecated
    public static URI anySubjectURI(Model m) {
        return Models.subjectIRI(m).orElse(null);
    }

    public static Optional<BNode> subjectBNode(Model m) {
        return m.stream().map(st -> st.getSubject()).filter(s -> s instanceof BNode).map(s -> (BNode)s).findAny();
    }

    public static Set<BNode> subjectBNodes(Model m) {
        return m.subjects().stream().filter(s -> s instanceof BNode).map(s -> (BNode)s).collect(Collectors.toSet());
    }

    @Deprecated
    public static BNode anySubjectBNode(Model m) {
        return Models.subjectBNode(m).orElse(null);
    }

    public static Optional<IRI> predicate(Model m) {
        return m.stream().map(st -> st.getPredicate()).findAny();
    }

    @Deprecated
    public static URI anyPredicate(Model m) {
        return Models.predicate(m).orElse(null);
    }

    public static Model setProperty(Model m, Resource subject, IRI property, Value value, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        Objects.requireNonNull(value, "value may not be null");
        if (m.contains(subject, property, null, contexts)) {
            m.remove(subject, property, null, contexts);
        }
        m.add(subject, property, value, contexts);
        return m;
    }

    public static Optional<Value> getProperty(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.object(m.filter(subject, property, null, contexts));
    }

    public static Set<Value> getProperties(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return m.filter(subject, property, null, contexts).objects();
    }

    public static Optional<Resource> getPropertyResource(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectResource(m.filter(subject, property, null, contexts));
    }

    public static Set<Resource> getPropertyResources(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectResources(m.filter(subject, property, null, contexts));
    }

    public static Optional<IRI> getPropertyIRI(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectIRI(m.filter(subject, property, null, contexts));
    }

    public static Set<IRI> getPropertyIRIs(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectIRIs(m.filter(subject, property, null, contexts));
    }

    public static Optional<Literal> getPropertyLiteral(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectLiteral(m.filter(subject, property, null, contexts));
    }

    public static Set<Literal> getPropertyLiterals(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectLiterals(m.filter(subject, property, null, contexts));
    }

    public static Optional<String> getPropertyString(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectString(m.filter(subject, property, null, contexts));
    }

    public static Set<String> getPropertyStrings(Model m, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectStrings(m.filter(subject, property, null, contexts));
    }

    public static boolean isomorphic(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Model set1 = Models.toModel(model1);
        Model set2 = Models.toModel(model2);
        if (set1.size() != set2.size()) {
            return false;
        }
        return Models.isSubsetInternal(set1, set2);
    }

    @Deprecated
    public static boolean equals(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        return Models.isomorphic(model1, model2);
    }

    public static boolean isSubset(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Model set1 = Models.toModel(model1);
        Model set2 = Models.toModel(model2);
        return Models.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() > model2.size()) {
            return false;
        }
        return Models.isSubsetInternal(Models.toModel(model1), Models.toModel(model2));
    }

    private static boolean isSubsetInternal(Model model1, Model model2) {
        return Models.matchModels(model1, model2);
    }

    private static boolean matchModels(Model model1, Model model2) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(model1.size());
        for (Statement st : model1) {
            if (Models.isBlank(st.getSubject()) || Models.isBlank(st.getObject()) || Models.isBlank(st.getContext())) {
                model1BNodes.add(st);
                continue;
            }
            if (model2.contains(st)) continue;
            return false;
        }
        return Models.matchModels(model1BNodes, model2, new HashMap<Resource, Resource>(), 0);
    }

    private static boolean matchModels(List<? extends Statement> model1, Model model2, Map<Resource, Resource> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            List<Statement> matchingStats = Models.findMatchingStatements(st1, model2, bNodeMapping);
            for (Statement st2 : matchingStats) {
                HashMap<Resource, Resource> newBNodeMapping = new HashMap<Resource, Resource>(bNodeMapping);
                if (Models.isBlank(st1.getSubject()) && Models.isBlank(st2.getSubject())) {
                    newBNodeMapping.put(st1.getSubject(), st2.getSubject());
                }
                if (Models.isBlank(st1.getObject()) && Models.isBlank(st2.getObject())) {
                    newBNodeMapping.put((Resource)st1.getObject(), (Resource)st2.getObject());
                }
                if (Models.isBlank(st1.getContext()) && Models.isBlank(st2.getContext())) {
                    newBNodeMapping.put(st1.getContext(), st2.getContext());
                }
                if (!(result = Models.matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<Statement> findMatchingStatements(Statement st, Model model, Map<Resource, Resource> bNodeMapping) {
        Resource[] resourceArray;
        Value o;
        Resource s = Models.isBlank(st.getSubject()) ? null : st.getSubject();
        IRI p = st.getPredicate();
        Value value = o = Models.isBlank(st.getObject()) ? null : st.getObject();
        if (Models.isBlank(st.getContext())) {
            resourceArray = new Resource[]{};
        } else {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = st.getContext();
        }
        Resource[] g = resourceArray;
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement modelSt : model.filter(s, p, o, g)) {
            if (!Models.statementsMatch(st, modelSt, bNodeMapping)) continue;
            result.add(modelSt);
        }
        return result;
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<Resource, Resource> bNodeMapping) {
        Resource mappedBNode;
        Resource mappedBNode2;
        Resource mappedBNode3;
        IRI pred2;
        IRI pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (Models.isBlank(subj1) && Models.isBlank(subj2) ? ((mappedBNode3 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode3) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        if (Models.isBlank(obj1) && Models.isBlank(obj2) ? ((mappedBNode2 = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode2) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2)) {
            return false;
        }
        Resource context1 = st1.getContext();
        Resource context2 = st2.getContext();
        if (context1 == null) {
            return context2 == null;
        }
        if (context2 == null) {
            return false;
        }
        return !(Models.isBlank(context1) && Models.isBlank(context2) ? ((mappedBNode = bNodeMapping.get(context1)) != null ? !context2.equals(mappedBNode) : bNodeMapping.containsValue(context2)) : !context1.equals(context1));
    }

    private static boolean isBlank(Value value) {
        if (value instanceof IRI) {
            return value.stringValue().indexOf("/.well-known/genid/") > 0;
        }
        return value instanceof BNode;
    }

    private static Model toModel(Iterable<? extends Statement> iterable) {
        if (iterable instanceof Model) {
            return (Model)iterable;
        }
        TreeModel set = new TreeModel();
        StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull).forEach(st -> set.add(st));
        return set;
    }

    public static Supplier<ModelException> modelException(String message) {
        return () -> new ModelException(message);
    }
}

