/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SKOS;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class ModelBuilder {
    private final Model model;
    private Resource currentSubject;
    private Resource currentNamedGraph;

    public ModelBuilder() {
        this(new LinkedHashModel());
    }

    public ModelBuilder(Model model) {
        this.model = model;
    }

    public ModelBuilder setNamespace(Namespace ns) {
        this.model.setNamespace(ns);
        return this;
    }

    public ModelBuilder setNamespace(String prefix, String namespace) {
        this.model.setNamespace(new SimpleNamespace(prefix, namespace));
        return this;
    }

    public ModelBuilder subject(Resource subject) {
        this.currentSubject = subject;
        return this;
    }

    public ModelBuilder subject(String prefixedNameOrIri) {
        return this.subject(this.mapToIRI(prefixedNameOrIri));
    }

    public ModelBuilder namedGraph(Resource namedGraph) {
        this.currentSubject = null;
        this.currentNamedGraph = namedGraph;
        return this;
    }

    public ModelBuilder namedGraph(String prefixedNameOrIRI) {
        return this.namedGraph(this.mapToIRI(prefixedNameOrIRI));
    }

    public ModelBuilder defaultGraph() {
        this.currentSubject = null;
        this.currentNamedGraph = null;
        return this;
    }

    public ModelBuilder add(Resource subject, IRI predicate, Object object) {
        Value objectValue = null;
        if (object instanceof Value) {
            objectValue = (Value)object;
        } else if (object instanceof String) {
            objectValue = this.convertPrefixedName((String)object);
        }
        if (objectValue == null) {
            this.model.setNamespace(XMLSchema.NS);
            objectValue = Literals.createLiteral(SimpleValueFactory.getInstance(), object);
        }
        if (this.currentNamedGraph != null) {
            this.model.add(subject, predicate, objectValue, this.currentNamedGraph);
        } else {
            this.model.add(subject, predicate, objectValue, new Resource[0]);
        }
        return this;
    }

    public ModelBuilder add(String subject, IRI predicate, Object object) {
        return this.add(this.mapToIRI(subject), predicate, object);
    }

    public ModelBuilder add(String subject, String predicate, Object object) {
        return this.add(this.mapToIRI(subject), this.mapToIRI(predicate), object);
    }

    public ModelBuilder add(IRI predicate, Object object) {
        if (this.currentSubject == null) {
            throw new ModelException("subject not set");
        }
        return this.add(this.currentSubject, predicate, object);
    }

    public ModelBuilder add(String predicate, Object object) {
        return this.add(this.mapToIRI(predicate), object);
    }

    public Model build() {
        return this.model;
    }

    private IRI convertPrefixedName(String prefixedName) {
        if (prefixedName.indexOf(58) < 0) {
            return null;
        }
        String prefix = prefixedName.substring(0, prefixedName.indexOf(58));
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        for (Namespace ns : this.model.getNamespaces()) {
            if (!prefix.equals(ns.getPrefix())) continue;
            return vf.createIRI(ns.getName(), prefixedName.substring(prefixedName.indexOf(58) + 1));
        }
        for (Namespace ns : this.getDefaultNamespaces()) {
            if (!prefix.equals(ns.getPrefix())) continue;
            this.model.setNamespace(ns);
            return vf.createIRI(ns.getName(), prefixedName.substring(prefixedName.indexOf(58) + 1));
        }
        return null;
    }

    private IRI mapToIRI(String prefixedNameOrIRI) {
        if (prefixedNameOrIRI.indexOf(58) < 0) {
            throw new ModelException("not a valid prefixed name or IRI: " + prefixedNameOrIRI);
        }
        IRI iri = this.convertPrefixedName(prefixedNameOrIRI);
        if (iri == null) {
            iri = SimpleValueFactory.getInstance().createIRI(prefixedNameOrIRI);
        }
        return iri;
    }

    private Namespace[] getDefaultNamespaces() {
        return new Namespace[]{RDF.NS, RDFS.NS, OWL.NS, XMLSchema.NS, DCTERMS.NS, DC.NS, FOAF.NS, SKOS.NS};
    }
}

