/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.util.iterators.Iterators;

public class Models {
    protected Models() {
    }

    public static Value object(Model m) {
        Value result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            result = objects.iterator().next();
        }
        return result;
    }

    @Deprecated
    public static Value anyObject(Model m) {
        return Models.object(m);
    }

    public static Literal objectLiteral(Model m) {
        Literal result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            for (Value v : objects) {
                if (!(v instanceof Literal)) continue;
                result = (Literal)v;
                break;
            }
        }
        return result;
    }

    @Deprecated
    public static Literal anyObjectLiteral(Model m) {
        return Models.objectLiteral(m);
    }

    public static Resource objectResource(Model m) {
        Resource result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            for (Value v : objects) {
                if (!(v instanceof Resource)) continue;
                result = (Resource)v;
                break;
            }
        }
        return result;
    }

    @Deprecated
    public static Resource anyObjectResource(Model m) {
        return Models.objectResource(m);
    }

    public static IRI objectIRI(Model m) {
        IRI result = null;
        Set<Value> objects = m.objects();
        if (objects != null && !objects.isEmpty()) {
            for (Value v : objects) {
                if (!(v instanceof IRI)) continue;
                result = (IRI)v;
                break;
            }
        }
        return result;
    }

    public static String objectString(Model m) {
        Iterator<Value> iterator = m.objects().iterator();
        if (iterator.hasNext()) {
            Value object = iterator.next();
            return object.stringValue();
        }
        return null;
    }

    @Deprecated
    public static URI anyObjectURI(Model m) {
        return Models.objectIRI(m);
    }

    public static Resource subject(Model m) {
        Resource result = null;
        Set<Resource> subjects = m.subjects();
        if (subjects != null && !subjects.isEmpty()) {
            result = subjects.iterator().next();
        }
        return result;
    }

    @Deprecated
    public static Resource anySubject(Model m) {
        return Models.subject(m);
    }

    public static IRI subjectIRI(Model m) {
        IRI result = null;
        Set<Resource> objects = m.subjects();
        if (objects != null && !objects.isEmpty()) {
            for (Value value : objects) {
                if (!(value instanceof IRI)) continue;
                result = (IRI)value;
                break;
            }
        }
        return result;
    }

    @Deprecated
    public static URI anySubjectURI(Model m) {
        return Models.subjectIRI(m);
    }

    public static BNode subjectBNode(Model m) {
        BNode result = null;
        Set<Resource> objects = m.subjects();
        if (objects != null && !objects.isEmpty()) {
            for (Value value : objects) {
                if (!(value instanceof BNode)) continue;
                result = (BNode)value;
                break;
            }
        }
        return result;
    }

    @Deprecated
    public static BNode anySubjectBNode(Model m) {
        return Models.subjectBNode(m);
    }

    public static IRI predicate(Model m) {
        IRI result = null;
        Set<IRI> predicates = m.predicates();
        if (predicates != null && !predicates.isEmpty()) {
            result = predicates.iterator().next();
        }
        return result;
    }

    @Deprecated
    public static URI anyPredicate(Model m) {
        return Models.predicate(m);
    }

    public static Model setProperty(Model m, Resource subject, IRI property, Value value, Resource ... contexts) {
        Objects.requireNonNull(m, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        Objects.requireNonNull(value, "value may not be null");
        if (m.contains(subject, property, null, contexts)) {
            m.remove(subject, property, null, contexts);
        }
        m.add(subject, property, value, contexts);
        return m;
    }

    public static boolean isomorphic(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Set<? extends Statement> set1 = Models.toSet(model1);
        Set<? extends Statement> set2 = Models.toSet(model2);
        if (set1.size() != set2.size()) {
            return false;
        }
        return Models.isSubsetInternal(set1, set2);
    }

    @Deprecated
    public static boolean equals(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        return Models.isomorphic(model1, model2);
    }

    public static boolean isSubset(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Set<? extends Statement> set1 = Models.toSet(model1);
        Set<? extends Statement> set2 = Models.toSet(model2);
        return Models.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() > model2.size()) {
            return false;
        }
        return Models.isSubsetInternal(model1, model2);
    }

    private static boolean isSubsetInternal(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        return Models.matchModels(model1, model2);
    }

    private static boolean matchModels(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(model1.size());
        for (Statement statement : model1) {
            if (statement.getSubject() instanceof BNode || statement.getObject() instanceof BNode || statement.getContext() instanceof BNode) {
                model1BNodes.add(statement);
                continue;
            }
            if (model2.contains(statement)) continue;
            return false;
        }
        return Models.matchModels(model1BNodes, model2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchModels(List<? extends Statement> model1, Iterable<? extends Statement> model2, Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            List<Statement> matchingStats = Models.findMatchingStatements(st1, model2, bNodeMapping);
            for (Statement st2 : matchingStats) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                if (st1.getSubject() instanceof BNode && st2.getSubject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getSubject(), (BNode)st2.getSubject());
                }
                if (st1.getObject() instanceof BNode && st2.getObject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getObject(), (BNode)st2.getObject());
                }
                if (st1.getContext() instanceof BNode && st2.getContext() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getContext(), (BNode)st2.getContext());
                }
                if (!(result = Models.matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<Statement> findMatchingStatements(Statement st, Iterable<? extends Statement> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement statement : model) {
            if (!Models.statementsMatch(st, statement, bNodeMapping)) continue;
            result.add(statement);
        }
        return result;
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<BNode, BNode> bNodeMapping) {
        BNode mappedBNode;
        BNode mappedBNode2;
        BNode mappedBNode3;
        IRI pred2;
        IRI pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (subj1 instanceof BNode && subj2 instanceof BNode ? ((mappedBNode3 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode3) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        if (obj1 instanceof BNode && obj2 instanceof BNode ? ((mappedBNode2 = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode2) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2)) {
            return false;
        }
        Resource context1 = st1.getContext();
        Resource context2 = st2.getContext();
        if (context1 == null) {
            return context2 == null;
        }
        if (context2 == null) {
            return false;
        }
        return !(context1 instanceof BNode && context2 instanceof BNode ? ((mappedBNode = bNodeMapping.get(context1)) != null ? !context2.equals(mappedBNode) : bNodeMapping.containsValue(context2)) : !context1.equals(context1));
    }

    private static <S extends Statement> Set<S> toSet(Iterable<S> iterable) {
        HashSet set = null;
        if (iterable instanceof Set) {
            set = (HashSet)iterable;
        } else {
            set = new HashSet();
            Iterators.addAll(iterable.iterator(), set);
        }
        return set;
    }
}

