/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.testsuite.rdf4j.sail.lucene;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractLuceneSailIndexedPropertiesTest {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    protected LuceneSail sail;
    protected Repository repository;
    public static final IRI SUBJECT_1 = vf.createIRI("urn:subject1");
    public static final IRI SUBJECT_2 = vf.createIRI("urn:subject2");
    public static final IRI SUBJECT_3 = vf.createIRI("urn:subject3");
    public static final IRI SUBJECT_4 = vf.createIRI("urn:subject4");
    public static final IRI SUBJECT_5 = vf.createIRI("urn:subject5");
    public static final IRI CONTEXT_1 = vf.createIRI("urn:context1");
    public static final IRI CONTEXT_2 = vf.createIRI("urn:context2");
    public static final IRI CONTEXT_3 = vf.createIRI("urn:context3");
    public static final IRI RDFSLABEL = RDFS.LABEL;
    public static final IRI RDFSCOMMENT = RDFS.COMMENT;
    public static final IRI FOAFNAME = vf.createIRI("http://xmlns.com/foaf/0.1/name");
    public static final IRI FOAFPLAN = vf.createIRI("http://xmlns.com/foaf/0.1/plan");

    protected abstract void configure(LuceneSail var1);

    @Before
    public void setUp() throws Exception {
        MemoryStore memoryStore = new MemoryStore();
        org.eclipse.rdf4j.common.concurrent.locks.Properties.setLockTrackingEnabled((boolean)true);
        this.sail = new LuceneSail();
        this.configure(this.sail);
        Properties indexedFields = new Properties();
        indexedFields.setProperty("index.1", RDFSLABEL.toString());
        indexedFields.setProperty("index.2", RDFSCOMMENT.toString());
        indexedFields.setProperty(FOAFNAME.toString(), RDFS.LABEL.toString());
        ByteArrayOutputStream indexedFieldsString = new ByteArrayOutputStream();
        indexedFields.store(indexedFieldsString, "For testing");
        this.sail.setParameter("indexedfields", indexedFieldsString.toString());
        this.sail.setBaseSail((Sail)memoryStore);
        this.repository = new SailRepository((Sail)this.sail);
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.begin();
            connection.add((Resource)SUBJECT_1, RDFSLABEL, (Value)vf.createLiteral("the first resource"), new Resource[0]);
            connection.add((Resource)SUBJECT_1, RDFSCOMMENT, (Value)vf.createLiteral("Groucho Marx is going to cut away the first part of the first party of the contract."), new Resource[0]);
            connection.add((Resource)SUBJECT_1, FOAFNAME, (Value)vf.createLiteral("groucho and harpo"), new Resource[0]);
            connection.add((Resource)SUBJECT_2, FOAFNAME, (Value)vf.createLiteral("the second resource"), new Resource[0]);
            connection.add((Resource)SUBJECT_2, RDFSCOMMENT, (Value)vf.createLiteral("in the night at the opera, groucho is in a cabin on a ship."), new Resource[0]);
            connection.add((Resource)SUBJECT_3, RDFSLABEL, (Value)vf.createLiteral("the third resource"), new Resource[0]);
            connection.add((Resource)SUBJECT_3, RDFSCOMMENT, (Value)vf.createLiteral("a not well known fact, groucho marx was not a smoker"), new Resource[0]);
            connection.add((Resource)SUBJECT_3, FOAFPLAN, (Value)vf.createLiteral("groucho did not smoke cigars nor cigarillos"), new Resource[0]);
            connection.commit();
        }
    }

    @After
    public void tearDown() throws IOException, RepositoryException {
        if (this.repository != null) {
            this.repository.shutDown();
        }
        org.eclipse.rdf4j.common.concurrent.locks.Properties.setLockTrackingEnabled((boolean)false);
    }

    @Test
    public void testTriplesStored() {
        try (RepositoryConnection connection = this.repository.getConnection();){
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_1, RDFSLABEL, (Value)vf.createLiteral("the first resource"), false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_1, RDFSCOMMENT, (Value)vf.createLiteral("Groucho Marx is going to cut away the first part of the first party of the contract."), false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_1, FOAFNAME, (Value)vf.createLiteral("groucho and harpo"), false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_2, FOAFNAME, (Value)vf.createLiteral("the second resource"), false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_2, RDFSCOMMENT, (Value)vf.createLiteral("in the night at the opera, groucho is in a cabin on a ship."), false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, RDFSLABEL, (Value)vf.createLiteral("the third resource"), false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, RDFSCOMMENT, (Value)vf.createLiteral("a not well known fact, groucho marx was not a smoker"), false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, FOAFPLAN, (Value)vf.createLiteral("groucho did not smoke cigars nor cigarillos"), false, new Resource[0]));
            System.err.println("--- after");
        }
    }

    @Test
    public void testRegularQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            BindingSet bindings;
            ArrayList<IRI> uris;
            String queryString = "SELECT ?Subject ?Score WHERE { ?Subject <" + String.valueOf(LuceneSailSchema.MATCHES) + "> [  <" + String.valueOf(LuceneSailSchema.QUERY) + "> ?Query;  <" + String.valueOf(LuceneSailSchema.PROPERTY) + "> ?Property;  <" + String.valueOf(LuceneSailSchema.SCORE) + "> ?Score ].} ";
            TupleQuery query = connection.prepareTupleQuery(queryString);
            query.setBinding("Query", (Value)vf.createLiteral("resource"));
            query.setBinding("Property", (Value)RDFSLABEL);
            try (TupleQueryResult result = query.evaluate();){
                uris = new ArrayList<IRI>();
                while (result.hasNext()) {
                    bindings = (BindingSet)result.next();
                    uris.add((IRI)bindings.getValue("Subject"));
                    Assert.assertNotNull((Object)bindings.getValue("Score"));
                }
                Assert.assertEquals((long)3L, (long)uris.size());
                Assert.assertTrue((boolean)uris.contains(SUBJECT_1));
                Assert.assertTrue((boolean)uris.contains(SUBJECT_2));
                Assert.assertTrue((boolean)uris.contains(SUBJECT_3));
            }
            query = connection.prepareTupleQuery(queryString);
            query.setBinding("Query", (Value)vf.createLiteral("groucho"));
            query.setBinding("Property", (Value)RDFSLABEL);
            result = query.evaluate();
            try {
                uris = new ArrayList();
                while (result.hasNext()) {
                    bindings = (BindingSet)result.next();
                    uris.add((IRI)bindings.getValue("Subject"));
                    Assert.assertNotNull((Object)bindings.getValue("Score"));
                }
                Assert.assertEquals((long)1L, (long)uris.size());
                Assert.assertTrue((boolean)uris.contains(SUBJECT_1));
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            query = connection.prepareTupleQuery(queryString);
            query.setBinding("Query", (Value)vf.createLiteral("cigarillos"));
            query.setBinding("Property", (Value)FOAFPLAN);
            result = query.evaluate();
            try {
                Assert.assertFalse((boolean)result.hasNext());
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
    }
}

