/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.testsuite.rdf4j.sail.lucene;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=10L, unit=TimeUnit.MINUTES)
public abstract class AbstractLuceneSailTest {
    protected static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String QUERY_STRING;
    public static final IRI SUBJECT_1;
    public static final IRI SUBJECT_2;
    public static final IRI SUBJECT_3;
    public static final IRI SUBJECT_4;
    public static final IRI SUBJECT_5;
    public static final IRI CONTEXT_1;
    public static final IRI CONTEXT_2;
    public static final IRI CONTEXT_3;
    public static final IRI PREDICATE_1;
    public static final IRI PREDICATE_2;
    public static final IRI PREDICATE_3;
    protected LuceneSail sail;
    protected Repository repository;
    private final Random random = new Random(43252333L);

    protected abstract void configure(LuceneSail var1);

    @BeforeEach
    public void setUp() {
        MemoryStore memoryStore = new MemoryStore();
        Properties.setLockTrackingEnabled((boolean)true);
        this.sail = new LuceneSail();
        this.configure(this.sail);
        this.sail.setBaseSail((Sail)memoryStore);
        this.repository = new SailRepository((Sail)this.sail);
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.begin();
            connection.add((Resource)SUBJECT_1, PREDICATE_1, (Value)vf.createLiteral("one"), new Resource[0]);
            connection.add((Resource)SUBJECT_1, PREDICATE_1, (Value)vf.createLiteral("five"), new Resource[0]);
            connection.add((Resource)SUBJECT_1, PREDICATE_2, (Value)vf.createLiteral("two"), new Resource[0]);
            connection.add((Resource)SUBJECT_2, PREDICATE_1, (Value)vf.createLiteral("one"), new Resource[0]);
            connection.add((Resource)SUBJECT_2, PREDICATE_2, (Value)vf.createLiteral("three"), new Resource[0]);
            connection.add((Resource)SUBJECT_3, PREDICATE_1, (Value)vf.createLiteral("four"), new Resource[0]);
            connection.add((Resource)SUBJECT_3, PREDICATE_2, (Value)vf.createLiteral("one"), new Resource[0]);
            connection.add((Resource)SUBJECT_3, PREDICATE_3, (Value)SUBJECT_1, new Resource[0]);
            connection.add((Resource)SUBJECT_3, PREDICATE_3, (Value)SUBJECT_2, new Resource[0]);
            connection.commit();
        }
    }

    @AfterEach
    public void tearDown() throws RepositoryException {
        if (this.repository != null) {
            this.repository.shutDown();
        }
        Properties.setLockTrackingEnabled((boolean)false);
    }

    @Test
    public void testTriplesStored() {
        try (RepositoryConnection connection = this.repository.getConnection();){
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_1, PREDICATE_1, (Value)vf.createLiteral("one"), false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_1, PREDICATE_1, (Value)vf.createLiteral("five"), false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_1, PREDICATE_2, (Value)vf.createLiteral("two"), false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_2, PREDICATE_1, (Value)vf.createLiteral("one"), false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_2, PREDICATE_2, (Value)vf.createLiteral("three"), false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, PREDICATE_1, (Value)vf.createLiteral("four"), false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, PREDICATE_2, (Value)vf.createLiteral("one"), false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, PREDICATE_3, (Value)SUBJECT_1, false, new Resource[0]));
            Assertions.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, PREDICATE_3, (Value)SUBJECT_2, false, new Resource[0]));
        }
    }

    @Test
    public void testRegularQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(QUERY_STRING);
            query.setBinding("Query", (Value)vf.createLiteral("one"));
            try (TupleQueryResult result = query.evaluate();){
                ArrayList<IRI> uris = new ArrayList<IRI>();
                Assertions.assertTrue((boolean)result.hasNext());
                BindingSet bindings = (BindingSet)result.next();
                uris.add((IRI)bindings.getValue("Subject"));
                Assertions.assertNotNull((Object)bindings.getValue("Score"));
                Assertions.assertTrue((boolean)result.hasNext());
                bindings = (BindingSet)result.next();
                uris.add((IRI)bindings.getValue("Subject"));
                Assertions.assertNotNull((Object)bindings.getValue("Score"));
                Assertions.assertTrue((boolean)result.hasNext());
                bindings = (BindingSet)result.next();
                uris.add((IRI)bindings.getValue("Subject"));
                Assertions.assertNotNull((Object)bindings.getValue("Score"));
                Assertions.assertFalse((boolean)result.hasNext());
                Assertions.assertTrue((boolean)uris.contains(SUBJECT_1));
                Assertions.assertTrue((boolean)uris.contains(SUBJECT_2));
                Assertions.assertTrue((boolean)uris.contains(SUBJECT_3));
            }
        }
    }

    @Test
    public void testComplexQueryOne() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ?Resource ?Matching ?Score ");
        buffer.append("WHERE { ?Resource <" + PREDICATE_3 + "> ?Matching. ");
        buffer.append(" ?Matching <" + LuceneSailSchema.MATCHES + "> [ ");
        buffer.append(" <" + LuceneSailSchema.QUERY + "> \"one\"; ");
        buffer.append(" <" + LuceneSailSchema.SCORE + "> ?Score ]. } ");
        String q = buffer.toString();
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(q);
            try (TupleQueryResult result = query.evaluate();){
                ArrayList<CallSite> results = new ArrayList<CallSite>();
                Assertions.assertTrue((boolean)result.hasNext());
                BindingSet bindings = (BindingSet)result.next();
                results.add((CallSite)((Object)("<" + (IRI)bindings.getValue("Resource") + ">, <" + (IRI)bindings.getValue("Matching") + ">")));
                Assertions.assertNotNull((Object)bindings.getValue("Score"));
                Assertions.assertTrue((boolean)result.hasNext());
                bindings = (BindingSet)result.next();
                results.add((CallSite)((Object)("<" + (IRI)bindings.getValue("Resource") + ">, <" + (IRI)bindings.getValue("Matching") + ">")));
                Assertions.assertNotNull((Object)bindings.getValue("Score"));
                Assertions.assertFalse((boolean)result.hasNext());
                Assertions.assertTrue((boolean)results.contains("<" + SUBJECT_3 + ">, <" + SUBJECT_1 + ">"));
                Assertions.assertTrue((boolean)results.contains("<" + SUBJECT_3 + ">, <" + SUBJECT_2 + ">"));
            }
        }
    }

    @Test
    public void testComplexQueryTwo() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ?Resource ?Matching ?Score ");
        buffer.append("WHERE { ?Resource <" + PREDICATE_3 + "> ?Matching. ");
        buffer.append(" ?Matching <" + LuceneSailSchema.MATCHES + "> [ ");
        buffer.append(" <" + LuceneSailSchema.QUERY + "> \"two\"; ");
        buffer.append(" <" + LuceneSailSchema.SCORE + "> ?Score ]. } ");
        String q = buffer.toString();
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(q);
            try (TupleQueryResult result = query.evaluate();){
                Assertions.assertTrue((boolean)result.hasNext());
                BindingSet bindings = (BindingSet)result.next();
                Assertions.assertEquals((Object)SUBJECT_3, (Object)((IRI)bindings.getValue("Resource")));
                Assertions.assertEquals((Object)SUBJECT_1, (Object)((IRI)bindings.getValue("Matching")));
                Assertions.assertNotNull((Object)bindings.getValue("Score"));
                Assertions.assertFalse((boolean)result.hasNext());
            }
        }
    }

    @Test
    public void testMultipleLuceneQueries() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        String[] queries = new String[]{"SELECT ?Resource1 ?Resource2 ?R1Score ?R2Score \nWHERE {\n  ?Resource1 <" + PREDICATE_3 + "> ?Resource2 ; \n             <" + LuceneSailSchema.MATCHES + "> [ \n                                  <" + LuceneSailSchema.QUERY + "> \"one\"; \n                                  <" + LuceneSailSchema.SCORE + "> ?R1Score ]. \n  ?Resource2 <" + LuceneSailSchema.MATCHES + "> [ \n                                  <" + LuceneSailSchema.QUERY + "> \"one\"; \n                                  <" + LuceneSailSchema.SCORE + "> ?R2Score ]. } ", "SELECT ?Resource1 ?Resource3 ?R1Score ?R3Score \nWHERE {\n  ?Resource2 ?p21 ?Resource1 . \n  ?Resource2 ?p23 ?Resource3 . \n  ?Resource1 <" + LuceneSailSchema.MATCHES + "> [ \n                                 <" + LuceneSailSchema.QUERY + "> \"one\"; \n                                 <" + LuceneSailSchema.SCORE + "> ?R1Score ]. \n  ?Resource3 <" + LuceneSailSchema.MATCHES + "> [ \n                                 <" + LuceneSailSchema.QUERY + "> \"one\"; \n                                 <" + LuceneSailSchema.SCORE + "> ?R3Score ] . FILTER(?Resource1 != ?Resource3)\n}", "SELECT ?Resource1 ?Resource3 ?R1Score ?R3Score \nWHERE { \n  ?Resource2 ?p21 ?Resource1; \n             ?p23 ?Resource3 . \n  ?Resource1 <" + LuceneSailSchema.MATCHES + "> [ \n                           <" + LuceneSailSchema.QUERY + "> \"one\"; \n                           <" + LuceneSailSchema.PROPERTY + "> <" + PREDICATE_1 + ">; \n                           <" + LuceneSailSchema.SCORE + "> ?R1Score ].\n  ?Resource3 <" + LuceneSailSchema.MATCHES + "> [ \n                           <" + LuceneSailSchema.QUERY + "> \"two\"; \n                           <" + LuceneSailSchema.PROPERTY + "> <" + PREDICATE_2 + ">; \n                           <" + LuceneSailSchema.SCORE + "> ?R3Score ].}", "SELECT ?Resource1 ?Resource2 ?R1Score ?R2Score \nWHERE { \n   ?Resource1 <" + LuceneSailSchema.MATCHES + "> [ \n                            <" + LuceneSailSchema.QUERY + "> \"one\"; \n                            <" + LuceneSailSchema.PROPERTY + "> <" + PREDICATE_1 + ">; \n                            <" + LuceneSailSchema.SCORE + "> ?R1Score ].\n   ?Resource2 <" + LuceneSailSchema.MATCHES + "> [ \n                             <" + LuceneSailSchema.QUERY + "> \"one\"; \n                             <" + LuceneSailSchema.PROPERTY + "> <" + PREDICATE_2 + ">; \n                             <" + LuceneSailSchema.SCORE + "> ?R2Score ].}"};
        ArrayList<List<Map<String, String>>> results = new ArrayList<List<Map<String, String>>>();
        ArrayList resultSet = new ArrayList();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Resource1", SUBJECT_3.stringValue());
        result.put("R1Score", null);
        result.put("Resource2", SUBJECT_1.stringValue());
        result.put("R2Score", null);
        resultSet.add(result);
        result = new HashMap();
        result.put("Resource1", SUBJECT_3.stringValue());
        result.put("R1Score", null);
        result.put("Resource2", SUBJECT_2.stringValue());
        result.put("R2Score", null);
        resultSet.add(result);
        results.add(resultSet);
        resultSet = new ArrayList();
        result = new HashMap();
        result.put("Resource1", SUBJECT_1.stringValue());
        result.put("R1Score", null);
        result.put("Resource3", SUBJECT_2.stringValue());
        result.put("R3Score", null);
        resultSet.add(result);
        result = new HashMap();
        result.put("Resource1", SUBJECT_2.stringValue());
        result.put("R1Score", null);
        result.put("Resource3", SUBJECT_1.stringValue());
        result.put("R3Score", null);
        resultSet.add(result);
        results.add(resultSet);
        resultSet = new ArrayList();
        result = new HashMap();
        result.put("Resource1", SUBJECT_2.stringValue());
        result.put("R1Score", null);
        result.put("Resource3", SUBJECT_1.stringValue());
        result.put("R3Score", null);
        resultSet.add(result);
        result = new HashMap();
        result.put("Resource1", SUBJECT_1.stringValue());
        result.put("R1Score", null);
        result.put("Resource3", SUBJECT_1.stringValue());
        result.put("R3Score", null);
        resultSet.add(result);
        results.add(resultSet);
        resultSet = new ArrayList();
        result = new HashMap();
        result.put("Resource1", SUBJECT_1.stringValue());
        result.put("R1Score", null);
        result.put("Resource2", SUBJECT_3.stringValue());
        result.put("R2Score", null);
        resultSet.add(result);
        result = new HashMap();
        result.put("Resource1", SUBJECT_2.stringValue());
        result.put("R1Score", null);
        result.put("Resource2", SUBJECT_3.stringValue());
        result.put("R2Score", null);
        resultSet.add(result);
        results.add(resultSet);
        this.evaluate(queries, results);
    }

    private void evaluate(String[] queries, ArrayList<List<Map<String, String>>> expectedResults) throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            for (int queryID = 0; queryID < queries.length; ++queryID) {
                String sparql = queries[queryID];
                List<Map<String, String>> expectedResultSet = expectedResults.get(queryID);
                TupleQuery query = connection.prepareTupleQuery(sparql);
                try (TupleQueryResult tqr = query.evaluate();){
                    int actualResults = 0;
                    HashSet<Integer> matched = new HashSet<Integer>();
                    block11: while (tqr.hasNext()) {
                        BindingSet bs = (BindingSet)tqr.next();
                        ++actualResults;
                        for (int resultSetID = 0; resultSetID < expectedResultSet.size(); ++resultSetID) {
                            if (matched.contains(resultSetID)) continue;
                            boolean matches = true;
                            HashMap<String, String> expectedResult = new HashMap<String, String>(expectedResultSet.get(resultSetID));
                            ArrayList vars = new ArrayList(expectedResult.keySet());
                            for (String var : vars) {
                                String expectedVal = (String)expectedResult.get(var);
                                Value actualVal = bs.getValue(var);
                                if (expectedVal == null) {
                                    if (actualVal == null) {
                                        matches = false;
                                        break;
                                    }
                                } else if (actualVal == null || expectedVal.compareTo(actualVal.stringValue()) != 0) {
                                    matches = false;
                                    break;
                                }
                                expectedResult.remove(var);
                            }
                            if (!expectedResult.isEmpty()) {
                                matches = false;
                            }
                            if (!matches) continue;
                            matched.add(resultSetID);
                            continue block11;
                        }
                    }
                    Assertions.assertEquals((int)expectedResultSet.size(), (int)matched.size(), (String)("How many expected results were retrieved for query #" + queryID + "?"));
                    Assertions.assertEquals((int)expectedResultSet.size(), (int)actualResults, (String)("How many actual results were retrieved for query #" + queryID + "?"));
                    continue;
                }
            }
        }
    }

    @Test
    public void testPredicateLuceneQueries() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        String[] queries = new String[]{"SELECT ?Resource ?Score ?Snippet \nWHERE { \n  ?Resource <" + LuceneSailSchema.MATCHES + "> [ \n                            <" + LuceneSailSchema.QUERY + "> \"one\"; \n                            <" + LuceneSailSchema.SCORE + "> ?Score; \n                            <" + LuceneSailSchema.SNIPPET + "> ?Snippet ].}", "SELECT ?Resource ?Score ?Snippet \nWHERE { \n  ?Resource <" + LuceneSailSchema.MATCHES + "> [ \n                            <" + LuceneSailSchema.QUERY + "> \"five\"; \n                            <" + LuceneSailSchema.SCORE + "> ?Score; \n                            <" + LuceneSailSchema.SNIPPET + "> ?Snippet ].}"};
        ArrayList<List<Map<String, String>>> results = new ArrayList<List<Map<String, String>>>();
        ArrayList resultSet = new ArrayList();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Resource", SUBJECT_1.stringValue());
        result.put("Score", null);
        result.put("Snippet", "<B>one</B>");
        resultSet.add(result);
        result = new HashMap();
        result.put("Resource", SUBJECT_2.stringValue());
        result.put("Score", null);
        result.put("Snippet", "<B>one</B>");
        resultSet.add(result);
        result = new HashMap();
        result.put("Resource", SUBJECT_3.stringValue());
        result.put("Score", null);
        result.put("Snippet", "<B>one</B>");
        resultSet.add(result);
        results.add(resultSet);
        resultSet = new ArrayList();
        result = new HashMap();
        result.put("Resource", SUBJECT_1.stringValue());
        result.put("Score", null);
        result.put("Snippet", "<B>five</B>");
        resultSet.add(result);
        results.add(resultSet);
        this.evaluate(queries, results);
    }

    @Test
    public void testSnippetQueries() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ?Resource ?Score \n");
        buffer.append("WHERE {\n");
        buffer.append("  ?Resource <" + LuceneSailSchema.MATCHES + "> [\n ");
        buffer.append("    <" + LuceneSailSchema.QUERY + "> \"one\"; ");
        buffer.append("    <" + LuceneSailSchema.PROPERTY + "> <" + PREDICATE_1 + ">; ");
        buffer.append("    <" + LuceneSailSchema.SCORE + "> ?Score ].} ");
        String q = buffer.toString();
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(q);
            try (TupleQueryResult result = query.evaluate();){
                int results = 0;
                HashSet<IRI> expectedSubject = new HashSet<IRI>();
                expectedSubject.add(SUBJECT_1);
                expectedSubject.add(SUBJECT_2);
                while (result.hasNext()) {
                    ++results;
                    BindingSet bindings = (BindingSet)result.next();
                    Assertions.assertTrue((boolean)expectedSubject.remove(bindings.getValue("Resource")));
                    Assertions.assertNotNull((Object)bindings.getValue("Score"));
                }
                Assertions.assertEquals((int)2, (int)results);
            }
        }
    }

    @Test
    public void testSnippetLimitedToPredicate() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        BindingSet bindings;
        HashSet<String> expectedSnippetPart;
        int results;
        TupleQueryResult result;
        TupleQuery query;
        try (RepositoryConnection myconnection = this.repository.getConnection();){
            myconnection.begin();
            myconnection.add((Resource)SUBJECT_1, PREDICATE_1, (Value)vf.createLiteral("come charly lets go to candy mountain"), new Resource[0]);
            myconnection.add((Resource)SUBJECT_1, PREDICATE_1, (Value)vf.createLiteral("but the unicorn charly said to goaway"), new Resource[0]);
            myconnection.add((Resource)SUBJECT_1, PREDICATE_2, (Value)vf.createLiteral("there was poor charly without a kidney"), new Resource[0]);
            myconnection.commit();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ?Resource ?Score ?Snippet \n");
        buffer.append("WHERE { \n");
        buffer.append("  ?Resource <" + LuceneSailSchema.MATCHES + "> [\n ");
        buffer.append("    <" + LuceneSailSchema.QUERY + "> \"charly\"; ");
        buffer.append("    <" + LuceneSailSchema.PROPERTY + "> <" + PREDICATE_1 + ">; ");
        buffer.append("    <" + LuceneSailSchema.SNIPPET + "> ?Snippet; ");
        buffer.append("    <" + LuceneSailSchema.SCORE + "> ?Score ]. } ");
        String q = buffer.toString();
        try (RepositoryConnection connection = this.repository.getConnection();){
            query = connection.prepareTupleQuery(q);
            result = query.evaluate();
            try {
                results = 0;
                expectedSnippetPart = new HashSet<String>();
                expectedSnippetPart.add("come");
                expectedSnippetPart.add("unicorn");
                String notexpected = "poor";
                while (result.hasNext()) {
                    ++results;
                    bindings = (BindingSet)result.next();
                    String snippet = ((Literal)bindings.getValue("Snippet")).stringValue();
                    boolean foundexpected = false;
                    Iterator i = expectedSnippetPart.iterator();
                    while (i.hasNext()) {
                        String expected = (String)i.next();
                        if (!snippet.contains(expected)) continue;
                        foundexpected = true;
                        i.remove();
                    }
                    if (snippet.contains(notexpected)) {
                        Assertions.fail((String)("snippet '" + snippet + "' contained value '" + notexpected + "' from predicate " + PREDICATE_2));
                    }
                    if (!foundexpected) {
                        Assertions.fail((String)("did not find any of the expected strings " + expectedSnippetPart + " in the snippet " + snippet));
                    }
                    Assertions.assertNotNull((Object)bindings.getValue("Score"));
                }
                Assertions.assertTrue((boolean)expectedSnippetPart.isEmpty(), (String)("These were expected but not found: " + expectedSnippetPart));
                Assertions.assertEquals((int)2, (int)results, (String)"there should have been 2 results");
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("SELECT ?Resource ?Score ?Snippet \n");
        buffer.append("WHERE { \n");
        buffer.append("  ?Resource <" + LuceneSailSchema.MATCHES + "> [\n ");
        buffer.append("    <" + LuceneSailSchema.QUERY + "> \"charly\"; ");
        buffer.append("    <" + LuceneSailSchema.SNIPPET + "> ?Snippet; ");
        buffer.append("    <" + LuceneSailSchema.SCORE + "> ?Score ].} ");
        q = buffer.toString();
        connection = this.repository.getConnection();
        try {
            query = connection.prepareTupleQuery(q);
            result = query.evaluate();
            try {
                results = 0;
                expectedSnippetPart = new HashSet();
                expectedSnippetPart.add("come");
                expectedSnippetPart.add("unicorn");
                expectedSnippetPart.add("poor");
                while (result.hasNext()) {
                    ++results;
                    bindings = (BindingSet)result.next();
                    String snippet = ((Literal)bindings.getValue("Snippet")).stringValue();
                    boolean foundexpected = false;
                    Iterator i = expectedSnippetPart.iterator();
                    while (i.hasNext()) {
                        String expected = (String)i.next();
                        if (!snippet.contains(expected)) continue;
                        foundexpected = true;
                        i.remove();
                    }
                    if (!foundexpected) {
                        Assertions.fail((String)("did not find any of the expected strings " + expectedSnippetPart + " in the snippet " + snippet));
                    }
                    Assertions.assertNotNull((Object)bindings.getValue("Score"));
                }
                Assertions.assertTrue((boolean)expectedSnippetPart.isEmpty(), (String)("These were expected but not found: " + expectedSnippetPart));
                Assertions.assertEquals((int)3, (int)results, (String)"there should have been 3 results");
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testGraphQuery() throws QueryEvaluationException, MalformedQueryException, RepositoryException {
        IRI score = vf.createIRI("http://www.openrdf.org/contrib/lucenesail#score");
        StringBuilder query = new StringBuilder();
        query.append("PREFIX lucenesail: <http://www.openrdf.org/contrib/lucenesail#> \n");
        query.append("CONSTRUCT { \n");
        query.append("    ?r <" + PREDICATE_3 + "> ?r2 ;\n");
        query.append("       <" + score + "> ?s } \n");
        query.append("WHERE { \n");
        query.append("    ?r lucenesail:matches ?match. ?match lucenesail:query \"four\"; \n");
        query.append("                                         lucenesail:score ?s. \n");
        query.append("    ?r <" + PREDICATE_3 + "> ?r2. }\n");
        int r = 0;
        int n = 0;
        try (RepositoryConnection connection = this.repository.getConnection();){
            GraphQuery gq = connection.prepareGraphQuery(query.toString());
            try (GraphQueryResult result = gq.evaluate();){
                while (result.hasNext()) {
                    Statement statement = (Statement)result.next();
                    ++n;
                    if (statement.getSubject().equals(SUBJECT_3) && statement.getPredicate().equals((Object)PREDICATE_3) && statement.getObject().equals(SUBJECT_1)) {
                        r |= 1;
                        continue;
                    }
                    if (statement.getSubject().equals(SUBJECT_3) && statement.getPredicate().equals((Object)PREDICATE_3) && statement.getObject().equals(SUBJECT_2)) {
                        r |= 2;
                        continue;
                    }
                    if (!statement.getSubject().equals(SUBJECT_3) || !statement.getPredicate().equals((Object)score)) continue;
                    r |= 4;
                }
                Assertions.assertEquals((int)3, (int)n);
                Assertions.assertEquals((int)7, (int)r);
            }
        }
    }

    @Test
    public void testQueryWithSpecifiedSubject() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(QUERY_STRING);
            query.setBinding("Subject", (Value)SUBJECT_1);
            query.setBinding("Query", (Value)vf.createLiteral("one"));
            TupleQueryResult result = query.evaluate();
            Assertions.assertTrue((boolean)result.hasNext());
            BindingSet bindings = (BindingSet)result.next();
            Assertions.assertEquals((Object)SUBJECT_1, (Object)((IRI)bindings.getValue("Subject")));
            Assertions.assertNotNull((Object)bindings.getValue("Score"));
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testUnionQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        Object queryStr = "";
        queryStr = (String)queryStr + "PREFIX search: <http://www.openrdf.org/contrib/lucenesail#> ";
        queryStr = (String)queryStr + "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> ";
        queryStr = (String)queryStr + "SELECT DISTINCT ?result { ";
        queryStr = (String)queryStr + "{ ?result search:matches ?match1 . ";
        queryStr = (String)queryStr + "  ?match1 search:query 'one' ; ";
        queryStr = (String)queryStr + "          search:property <urn:predicate1> . }";
        queryStr = (String)queryStr + " UNION ";
        queryStr = (String)queryStr + "{ ?result search:matches ?match2 . ";
        queryStr = (String)queryStr + "  ?match2 search:query 'one' ; ";
        queryStr = (String)queryStr + "          search:property <urn:predicate2> . } ";
        queryStr = (String)queryStr + "} ";
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, (String)queryStr);
            query.setBinding("result", (Value)SUBJECT_1);
            try (TupleQueryResult result = query.evaluate();){
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertEquals((Object)SUBJECT_1, (Object)bs.getValue("result"));
            }
        }
    }

    @Test
    public void testContextHandling() {
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.begin();
            connection.add((Resource)SUBJECT_4, PREDICATE_1, (Value)vf.createLiteral("sfourponecone"), new Resource[]{CONTEXT_1});
            connection.add((Resource)SUBJECT_4, PREDICATE_2, (Value)vf.createLiteral("sfourptwocone"), new Resource[]{CONTEXT_1});
            connection.add((Resource)SUBJECT_5, PREDICATE_1, (Value)vf.createLiteral("sfiveponecone"), new Resource[]{CONTEXT_1});
            connection.add((Resource)SUBJECT_5, PREDICATE_1, (Value)vf.createLiteral("sfiveponectwo"), new Resource[]{CONTEXT_2});
            connection.add((Resource)SUBJECT_5, PREDICATE_2, (Value)vf.createLiteral("sfiveptwoctwo"), new Resource[]{CONTEXT_2});
            connection.commit();
            this.assertQueryResult("sfourponecone", PREDICATE_1, (Resource)SUBJECT_4);
            this.assertQueryResult("sfourptwocone", PREDICATE_2, (Resource)SUBJECT_4);
            this.assertQueryResult("sfiveponecone", PREDICATE_1, (Resource)SUBJECT_5);
            this.assertQueryResult("sfiveponectwo", PREDICATE_1, (Resource)SUBJECT_5);
            this.assertQueryResult("sfiveptwoctwo", PREDICATE_2, (Resource)SUBJECT_5);
            this.assertNoQueryResult("johannesgrenzfurthner");
            connection.clear(new Resource[]{CONTEXT_1});
            connection.commit();
            this.assertNoQueryResult("sfourponecone");
            this.assertNoQueryResult("sfourptwocone");
            this.assertNoQueryResult("sfiveponecone");
            this.assertQueryResult("sfiveponectwo", PREDICATE_1, (Resource)SUBJECT_5);
            this.assertQueryResult("sfiveptwoctwo", PREDICATE_2, (Resource)SUBJECT_5);
        }
    }

    @Test
    public void testConcurrentReadingAndWriting() {
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.begin();
            connection.add((Resource)SUBJECT_1, PREDICATE_1, (Value)vf.createLiteral("sfourponecone"), new Resource[]{CONTEXT_1});
            connection.add((Resource)SUBJECT_2, PREDICATE_1, (Value)vf.createLiteral("sfourponecone"), new Resource[]{CONTEXT_1});
            connection.commit();
            String queryString = "SELECT ?Resource WHERE { ?Resource <" + LuceneSailSchema.MATCHES + "> [  <" + LuceneSailSchema.QUERY + "> \"sfourponecone\"].} ";
            TupleQuery query = connection.prepareTupleQuery(queryString);
            TupleQueryResult result = query.evaluate();
            Assertions.assertTrue((boolean)result.hasNext());
            BindingSet bindings = (BindingSet)result.next();
            connection.add((Resource)SUBJECT_3, PREDICATE_1, (Value)vf.createLiteral("sfourponecone"), new Resource[]{CONTEXT_1});
            Assertions.assertTrue((boolean)result.hasNext());
            bindings = (BindingSet)result.next();
            result.close();
            connection.commit();
            queryString = "SELECT ?Resource WHERE { ?Resource <" + LuceneSailSchema.MATCHES + "> [  <" + LuceneSailSchema.QUERY + "> \"sfourponecone\"].} ";
            query = connection.prepareTupleQuery(queryString);
            result = query.evaluate();
            Assertions.assertTrue((boolean)result.hasNext());
            bindings = (BindingSet)result.next();
            connection.add((Resource)SUBJECT_3, PREDICATE_1, (Value)vf.createLiteral("blubbb"), new Resource[]{CONTEXT_1});
            connection.commit();
            Assertions.assertTrue((boolean)result.hasNext());
            bindings = (BindingSet)result.next();
            result.close();
        }
    }

    @Test
    public void testNullContextHandling() {
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.add((Resource)SUBJECT_4, PREDICATE_1, (Value)vf.createLiteral("sfourponecone"), new Resource[0]);
            connection.add((Resource)SUBJECT_4, PREDICATE_2, (Value)vf.createLiteral("sfourptwocone"), new Resource[0]);
            connection.add((Resource)SUBJECT_5, PREDICATE_1, (Value)vf.createLiteral("sfiveponecone"), new Resource[0]);
            connection.add((Resource)SUBJECT_5, PREDICATE_1, (Value)vf.createLiteral("sfiveponectwo"), new Resource[]{CONTEXT_2});
            connection.add((Resource)SUBJECT_5, PREDICATE_2, (Value)vf.createLiteral("sfiveptwoctwo"), new Resource[]{CONTEXT_2});
            connection.commit();
            this.assertQueryResult("sfourponecone", PREDICATE_1, (Resource)SUBJECT_4);
            this.assertQueryResult("sfourptwocone", PREDICATE_2, (Resource)SUBJECT_4);
            this.assertQueryResult("sfiveponecone", PREDICATE_1, (Resource)SUBJECT_5);
            this.assertQueryResult("sfiveponectwo", PREDICATE_1, (Resource)SUBJECT_5);
            this.assertQueryResult("sfiveptwoctwo", PREDICATE_2, (Resource)SUBJECT_5);
            this.assertNoQueryResult("johannesgrenzfurthner");
            connection.clear(new Resource[]{null});
            connection.commit();
            this.assertNoQueryResult("sfourponecone");
            this.assertNoQueryResult("sfourptwocone");
            this.assertNoQueryResult("sfiveponecone");
            this.assertQueryResult("sfiveponectwo", PREDICATE_1, (Resource)SUBJECT_5);
            this.assertQueryResult("sfiveptwoctwo", PREDICATE_2, (Resource)SUBJECT_5);
        }
    }

    @Test
    public void testFuzzyQuery() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ?Resource ?Score \n");
        buffer.append("WHERE { \n");
        buffer.append("  ?Resource <" + LuceneSailSchema.MATCHES + "> [\n");
        buffer.append("    <" + LuceneSailSchema.QUERY + "> \"one~0.8\"; ");
        buffer.append("    <" + LuceneSailSchema.SCORE + "> ?Score ].} ");
        String q = buffer.toString();
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(q);
            try (TupleQueryResult result = query.evaluate();){
                int results = 0;
                HashSet<IRI> expectedSubject = new HashSet<IRI>();
                expectedSubject.add(SUBJECT_1);
                expectedSubject.add(SUBJECT_2);
                expectedSubject.add(SUBJECT_3);
                while (result.hasNext()) {
                    ++results;
                    BindingSet bindings = (BindingSet)result.next();
                    Assertions.assertTrue((boolean)expectedSubject.remove((IRI)bindings.getValue("Resource")));
                    Assertions.assertNotNull((Object)bindings.getValue("Score"));
                }
                Assertions.assertEquals((int)3, (int)results);
            }
        }
    }

    @Test
    public void testReindexing() {
        this.sail.reindex();
        this.testComplexQueryTwo();
    }

    @Test
    public void testPropertyVar() throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ?Resource ?Property \n");
        buffer.append("WHERE {\n");
        buffer.append("  ?Resource <" + LuceneSailSchema.MATCHES + "> [\n ");
        buffer.append("    <" + LuceneSailSchema.QUERY + "> \"one\";\n ");
        buffer.append("    <" + LuceneSailSchema.PROPERTY + "> ?Property ]. } ");
        String q = buffer.toString();
        try (RepositoryConnection connection = this.repository.getConnection();){
            TupleQuery query = connection.prepareTupleQuery(q);
            try (TupleQueryResult result = query.evaluate();){
                int results = 0;
                HashMap<IRI, IRI> expectedSubject = new HashMap<IRI, IRI>();
                expectedSubject.put(SUBJECT_1, PREDICATE_1);
                expectedSubject.put(SUBJECT_2, PREDICATE_1);
                expectedSubject.put(SUBJECT_3, PREDICATE_2);
                while (result.hasNext()) {
                    ++results;
                    BindingSet bindings = (BindingSet)result.next();
                    Value subject = bindings.getValue("Resource");
                    IRI expectedProperty = (IRI)expectedSubject.remove(subject);
                    Assertions.assertEquals((Object)expectedProperty, (Object)bindings.getValue("Property"), (String)("For subject " + subject));
                }
                Assertions.assertEquals((int)3, (int)results);
            }
        }
    }

    @Test
    public void testMultithreadedAdd() throws InterruptedException {
        int numThreads = 3;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(numThreads);
        final ConcurrentHashMap.KeySetView exceptions = ConcurrentHashMap.newKeySet();
        for (int i = 0; i < numThreads; ++i) {
            new Thread(new Runnable(){
                private final long iterationCount;
                {
                    this.iterationCount = 10L + Math.round(AbstractLuceneSailTest.this.random.nextDouble() * 100.0);
                }

                @Override
                public void run() {
                    try (RepositoryConnection con = AbstractLuceneSailTest.this.repository.getConnection();){
                        startLatch.await();
                        for (long i = 0L; i < this.iterationCount; ++i) {
                            con.add((Resource)vf.createIRI("ex:" + i), vf.createIRI("ex:prop" + i % 3L), (Value)vf.createLiteral(i), new Resource[0]);
                        }
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                        throw new AssertionError((Object)e);
                    }
                    finally {
                        endLatch.countDown();
                    }
                }
            }).start();
        }
        startLatch.countDown();
        endLatch.await();
        for (Throwable e : exceptions) {
            e.printStackTrace(System.err);
        }
        Assertions.assertEquals((int)0, (int)exceptions.size(), (String)"Exceptions occurred during testMultithreadedAdd, see stacktraces above");
    }

    protected void assertQueryResult(String literal, IRI predicate, Resource resultUri) {
        try (RepositoryConnection connection = this.repository.getConnection();){
            String queryString = "SELECT ?Resource WHERE { ?Resource <" + LuceneSailSchema.MATCHES + "> [  <" + LuceneSailSchema.QUERY + "> \"" + literal + "\" ]. } ";
            TupleQuery query = connection.prepareTupleQuery(queryString);
            try (TupleQueryResult result = query.evaluate();){
                Assertions.assertTrue((boolean)result.hasNext(), (String)("query for literal '" + literal + " did not return any results, expected was " + resultUri));
                BindingSet bindings = (BindingSet)result.next();
                Assertions.assertEquals((Object)resultUri, (Object)bindings.getValue("Resource"), (String)("query for literal '" + literal + " did not return the expected resource"));
                Assertions.assertFalse((boolean)result.hasNext());
            }
        }
    }

    protected void assertNoQueryResult(String literal) {
        try (RepositoryConnection connection = this.repository.getConnection();){
            String queryString = "SELECT ?Resource WHERE { ?Resource <" + LuceneSailSchema.MATCHES + "> [  <" + LuceneSailSchema.QUERY + "> \"" + literal + "\" ]. } ";
            TupleQuery query = connection.prepareTupleQuery(queryString);
            try (TupleQueryResult result = query.evaluate();){
                Assertions.assertFalse((boolean)result.hasNext(), (String)("query for literal '" + literal + " did return results, which was not expected."));
            }
        }
    }

    static {
        SUBJECT_1 = vf.createIRI("urn:subject1");
        SUBJECT_2 = vf.createIRI("urn:subject2");
        SUBJECT_3 = vf.createIRI("urn:subject3");
        SUBJECT_4 = vf.createIRI("urn:subject4");
        SUBJECT_5 = vf.createIRI("urn:subject5");
        CONTEXT_1 = vf.createIRI("urn:context1");
        CONTEXT_2 = vf.createIRI("urn:context2");
        CONTEXT_3 = vf.createIRI("urn:context3");
        PREDICATE_1 = vf.createIRI("urn:predicate1");
        PREDICATE_2 = vf.createIRI("urn:predicate2");
        PREDICATE_3 = vf.createIRI("urn:predicate3");
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ?Subject ?Score\n");
        buffer.append("WHERE { ?Subject <" + LuceneSailSchema.MATCHES + "> [\n");
        buffer.append("                              <" + LuceneSailSchema.QUERY + "> ?Query; \n");
        buffer.append("                              <" + LuceneSailSchema.SCORE + "> ?Score ].}");
        QUERY_STRING = buffer.toString();
    }
}

