/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractLuceneSailGeoSPARQLTest {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final IRI SUBJECT_1 = vf.createIRI("urn:subject1");
    public static final IRI SUBJECT_2 = vf.createIRI("urn:subject2");
    public static final IRI SUBJECT_3 = vf.createIRI("urn:subject3");
    public static final IRI SUBJECT_4 = vf.createIRI("urn:subject4");
    public static final IRI SUBJECT_5 = vf.createIRI("urn:subject5");
    public static final IRI CONTEXT_1 = vf.createIRI("urn:context1");
    public static final IRI CONTEXT_2 = vf.createIRI("urn:context2");
    public static final IRI CONTEXT_3 = vf.createIRI("urn:context3");
    public static final Literal EIFFEL_TOWER = vf.createLiteral("POINT (2.2945 48.8582)", GEO.WKT_LITERAL);
    public static final Literal ARC_TRIOMPHE = vf.createLiteral("POINT (2.2950 48.8738)", GEO.WKT_LITERAL);
    public static final Literal NOTRE_DAME = vf.createLiteral("POINT (2.3465 48.8547)", GEO.WKT_LITERAL);
    public static final Literal POLY1 = vf.createLiteral("POLYGON ((2.3294 48.8726, 2.2719 48.8643, 2.3370 48.8398, 2.3294 48.8726))", GEO.WKT_LITERAL);
    public static final Literal POLY2 = vf.createLiteral("POLYGON ((2.3509 48.8429, 2.3785 48.8385, 2.3576 48.8487, 2.3509 48.8429))", GEO.WKT_LITERAL);
    public static final Literal TEST_POINT = vf.createLiteral("POINT (2.2871 48.8630)", GEO.WKT_LITERAL);
    public static final Literal TEST_POLY = vf.createLiteral("POLYGON ((2.315 48.855, 2.360 48.835, 2.370 48.850, 2.315 48.855))", GEO.WKT_LITERAL);
    private static final double ERROR = 2.0;
    protected LuceneSail sail;
    protected Repository repository;

    protected abstract void configure(LuceneSail var1) throws IOException;

    @Before
    public void setUp() throws Exception {
        MemoryStore memoryStore = new MemoryStore();
        Properties.setLockTrackingEnabled((boolean)true);
        this.sail = new LuceneSail();
        this.configure(this.sail);
        this.sail.setBaseSail((Sail)memoryStore);
        this.repository = new SailRepository((Sail)this.sail);
        this.loadPoints();
        this.loadPolygons();
    }

    protected void loadPoints() {
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.add((Resource)SUBJECT_1, GEO.AS_WKT, (Value)EIFFEL_TOWER, new Resource[]{CONTEXT_1});
            connection.add((Resource)SUBJECT_2, GEO.AS_WKT, (Value)ARC_TRIOMPHE, new Resource[0]);
            connection.add((Resource)SUBJECT_3, GEO.AS_WKT, (Value)NOTRE_DAME, new Resource[]{CONTEXT_2});
        }
    }

    protected void loadPolygons() {
        try (RepositoryConnection connection = this.repository.getConnection();){
            connection.add((Resource)SUBJECT_4, GEO.AS_WKT, (Value)POLY1, new Resource[0]);
            connection.add((Resource)SUBJECT_5, GEO.AS_WKT, (Value)POLY2, new Resource[]{CONTEXT_3});
        }
    }

    @After
    public void tearDown() throws IOException, RepositoryException {
        if (this.repository != null) {
            this.repository.shutDown();
        }
    }

    @Test
    public void testTriplesStored() throws Exception {
        this.checkPoints();
        this.checkPolygons();
    }

    protected void checkPoints() throws RepositoryException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_1, GEO.AS_WKT, (Value)EIFFEL_TOWER, false, new Resource[]{CONTEXT_1}));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_2, GEO.AS_WKT, (Value)ARC_TRIOMPHE, false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_3, GEO.AS_WKT, (Value)NOTRE_DAME, false, new Resource[]{CONTEXT_2}));
        }
    }

    protected void checkPolygons() throws RepositoryException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_4, GEO.AS_WKT, (Value)POLY1, false, new Resource[0]));
            Assert.assertTrue((boolean)connection.hasStatement((Resource)SUBJECT_5, GEO.AS_WKT, (Value)POLY2, false, new Resource[]{CONTEXT_3}));
        }
    }

    @Test
    public void testDistanceQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?toUri ?to where { ?toUri geo:asWKT ?to. filter(geof:distance(?from, ?to, ?units) < ?range) }";
            TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            query.setBinding("from", (Value)TEST_POINT);
            query.setBinding("units", (Value)GEOF.UOM_METRE);
            query.setBinding("range", (Value)this.sail.getValueFactory().createLiteral(1500.0));
            try (TupleQueryResult result = query.evaluate();){
                LinkedHashMap<IRI, Literal> expected = new LinkedHashMap<IRI, Literal>();
                expected.put(SUBJECT_1, EIFFEL_TOWER);
                expected.put(SUBJECT_2, ARC_TRIOMPHE);
                while (result.hasNext()) {
                    BindingSet bindings = (BindingSet)result.next();
                    IRI subj = (IRI)bindings.getValue("toUri");
                    IRI expectedUri = (IRI)expected.keySet().iterator().next();
                    Assert.assertEquals((Object)expectedUri, (Object)subj);
                    Literal location = (Literal)expected.remove(subj);
                    Assert.assertNotNull((Object)location);
                    Assert.assertEquals((Object)location, (Object)bindings.getValue("to"));
                }
                Assert.assertTrue((boolean)expected.isEmpty());
            }
        }
    }

    @Test
    public void testComplexDistanceQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?toUri ?dist ?g where { graph ?g {?toUri geo:asWKT ?to.} bind(geof:distance(?from, ?to, ?units) as ?dist) filter(?dist < ?range) }";
            TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            query.setBinding("from", (Value)TEST_POINT);
            query.setBinding("units", (Value)GEOF.UOM_METRE);
            query.setBinding("range", (Value)this.sail.getValueFactory().createLiteral(1500.0));
            try (TupleQueryResult result = query.evaluate();){
                LinkedHashMap<IRI, Literal> expected = new LinkedHashMap<IRI, Literal>();
                expected.put(SUBJECT_1, this.sail.getValueFactory().createLiteral(760.0));
                while (result.hasNext()) {
                    BindingSet bindings = (BindingSet)result.next();
                    IRI subj = (IRI)bindings.getValue("toUri");
                    IRI expectedUri = (IRI)expected.keySet().iterator().next();
                    Assert.assertEquals((Object)expectedUri, (Object)subj);
                    Literal dist = (Literal)expected.remove(subj);
                    Assert.assertNotNull((Object)dist);
                    Assert.assertEquals((double)dist.doubleValue(), (double)((Literal)bindings.getValue("dist")).doubleValue(), (double)2.0);
                    Assert.assertNotNull((Object)bindings.getValue("g"));
                }
                Assert.assertTrue((boolean)expected.isEmpty());
            }
        }
    }

    @Test
    public void testComplexDistanceQueryMathExpr() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?toUri ?dist ?g where { graph ?g {?toUri geo:asWKT ?to.} bind((geof:distance(?from, ?to, ?units) / 1000) as ?dist) filter(?dist < ?range) }";
            TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            query.setBinding("from", (Value)TEST_POINT);
            query.setBinding("units", (Value)GEOF.UOM_METRE);
            query.setBinding("range", (Value)this.sail.getValueFactory().createLiteral(1.5));
            List result = QueryResults.asList((Iteration)query.evaluate());
            LinkedHashMap<IRI, Literal> expected = new LinkedHashMap<IRI, Literal>();
            expected.put(SUBJECT_1, this.sail.getValueFactory().createLiteral(0.76));
            for (BindingSet bindings : result) {
                System.out.println(bindings);
                IRI subj = (IRI)bindings.getValue("toUri");
                IRI expectedUri = (IRI)expected.keySet().iterator().next();
                Assert.assertEquals((Object)expectedUri, (Object)subj);
                Literal dist = (Literal)expected.remove(subj);
                Assert.assertNotNull((Object)dist);
                Assert.assertEquals((double)dist.doubleValue(), (double)((Literal)bindings.getValue("dist")).doubleValue(), (double)2.0);
                Assert.assertNotNull((Object)bindings.getValue("g"));
            }
            Assert.assertTrue((boolean)expected.isEmpty());
        }
    }

    public void testIntersectionQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?matchUri ?match where { ?matchUri geo:asWKT ?match. filter(geof:sfIntersects(?pattern, ?match)) }";
            TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            query.setBinding("pattern", (Value)TEST_POLY);
            try (TupleQueryResult result = query.evaluate();){
                HashMap<IRI, Literal> expected = new HashMap<IRI, Literal>();
                expected.put(SUBJECT_4, POLY1);
                expected.put(SUBJECT_5, POLY2);
                while (result.hasNext()) {
                    BindingSet bindings = (BindingSet)result.next();
                    IRI subj = (IRI)bindings.getValue("matchUri");
                    Literal location = (Literal)expected.remove(subj);
                    Assert.assertNotNull((Object)location);
                    Assert.assertEquals((Object)location, (Object)bindings.getValue("match"));
                }
                Assert.assertTrue((boolean)expected.isEmpty());
            }
        }
    }

    public void testComplexIntersectionQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection connection = this.repository.getConnection();){
            String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?matchUri ?intersects ?g where { graph ?g {?matchUri geo:asWKT ?match.} bind(geof:sfIntersects(?pattern, ?match) as ?intersects) filter(?intersects) }";
            TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            query.setBinding("pattern", (Value)TEST_POLY);
            try (TupleQueryResult result = query.evaluate();){
                HashMap<IRI, Literal> expected = new HashMap<IRI, Literal>();
                expected.put(SUBJECT_5, this.sail.getValueFactory().createLiteral(true));
                while (result.hasNext()) {
                    BindingSet bindings = (BindingSet)result.next();
                    IRI subj = (IRI)bindings.getValue("matchUri");
                    Literal location = (Literal)expected.remove(subj);
                    Assert.assertNotNull((String)("Expected subject: " + subj), (Object)location);
                    Assert.assertEquals((Object)location.booleanValue(), (Object)((Literal)bindings.getValue("intersects")).booleanValue());
                    Assert.assertNotNull((Object)bindings.getValue("g"));
                }
                Assert.assertTrue((boolean)expected.isEmpty());
            }
        }
    }
}

