/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.resultio.text.csv.SPARQLResultsCSVWriter;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLuceneSailTupleFunctionTest {
    private Repository repository;
    private static final String DATA = "org/eclipse/rdf4j/sail/220-example.ttl";
    private RepositoryConnection connection;
    private static Logger log = LoggerFactory.getLogger(AbstractLuceneSailTupleFunctionTest.class);

    @Before
    public void setUp() throws Exception {
        MemoryStore store = new MemoryStore();
        LuceneSail lucene = new LuceneSail();
        this.configure(lucene);
        lucene.setBaseSail((Sail)store);
        this.repository = new SailRepository((Sail)lucene);
        this.repository.initialize();
        this.connection = this.repository.getConnection();
        this.populate(this.connection);
        int count = this.countStatements(this.connection);
        log.debug("storage contains {} triples", (Object)count);
        assert (count > 0);
    }

    @After
    public void tearDown() throws IOException, RepositoryException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        finally {
            if (this.repository != null) {
                this.repository.shutDown();
            }
        }
    }

    protected abstract void configure(LuceneSail var1);

    protected void populate(RepositoryConnection connection) throws Exception {
        try {
            URL resourceURL = AbstractLuceneSailTupleFunctionTest.class.getClassLoader().getResource(DATA);
            log.info("Resource URL: {}", (Object)resourceURL.toString());
            connection.begin();
            assert (resourceURL instanceof URL);
            connection.add(resourceURL.openStream(), resourceURL.toString(), RDFFormat.TURTLE, new Resource[0]);
        }
        catch (Exception e) {
            connection.rollback();
            throw e;
        }
        finally {
            connection.commit();
        }
    }

    @Test
    public void simpleTest() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ?s ?p ?o where { ?s ?p ?o } limit 10");
        try {
            this.connection.begin();
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, buffer.toString());
            try (TupleQueryResult res = query.evaluate();){
                int count = this.countTupleResults(res);
                log.info("count statements: {}", (Object)count);
                Assert.assertTrue((count > 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.commit();
        }
    }

    @Test
    public void simpleSearchTest() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ?pred ?score ?label where {\n");
        buffer.append("  ?pred <" + LuceneSailSchema.MATCHES + "> [\n");
        buffer.append("    <" + LuceneSailSchema.QUERY + ">  \"ornare\" ;\n");
        buffer.append("    <" + LuceneSailSchema.SCORE + "> ?score \n");
        buffer.append("  ] .\n");
        buffer.append("  ?pred rdfs:label ?label .\n");
        buffer.append("}\n");
        log.info("Request query: \n{}\n", (Object)buffer.toString());
        try {
            this.connection.begin();
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, buffer.toString());
            log.debug("query \n{}", (Object)query);
            this.printTupleResult(query);
            try (TupleQueryResult res = query.evaluate();){
                int count = this.countTupleResults(res);
                log.info("count statements: {}", (Object)count);
                Assert.assertTrue((count == 1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.commit();
        }
    }

    @Test
    public void test220Issue() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ?pred ?score ?query ?label where {\n");
        buffer.append("  bind(str(\"ornare\") as ?query) .\n");
        buffer.append("  ?pred <" + LuceneSailSchema.MATCHES + "> [\n");
        buffer.append("    <" + LuceneSailSchema.QUERY + ">   ?query ;\n");
        buffer.append("    <" + LuceneSailSchema.SCORE + "> ?score \n");
        buffer.append("  ] .\n");
        buffer.append("  ?pred rdfs:label ?label .\n");
        buffer.append("}\n");
        log.info("Request query: \n==================\n{}\n=======================\n", (Object)buffer.toString());
        try {
            this.connection.begin();
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, buffer.toString());
            this.printTupleResult(query);
            try (TupleQueryResult res = query.evaluate();){
                int count = this.countTupleResults(res);
                log.info("count statements: {}", (Object)count);
                Assert.assertTrue((count == 1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.commit();
        }
    }

    @Test
    public void test235Issue() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append(" construct {\n");
        buffer.append("  ?pred a <urn:ontology/Phrase> .\n");
        buffer.append("  ?pred <urn:ontology/label> ?label .\n");
        buffer.append("  ?pred <urn:ontology/score> ?score . \n");
        buffer.append(" } where {\n");
        buffer.append("  ?pred <" + LuceneSailSchema.MATCHES + "> [\n");
        buffer.append("     <" + LuceneSailSchema.QUERY + "> \"ornare\";\n");
        buffer.append("     <" + LuceneSailSchema.SCORE + "> ?score \n");
        buffer.append("     ] .\n");
        buffer.append("  ?pred rdfs:label ?label .\n");
        buffer.append(" }");
        log.info("Request query: \n{}\n", (Object)buffer.toString());
        try {
            this.connection.begin();
            GraphQuery query = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, buffer.toString());
            this.printGraphResult(query);
            try (GraphQueryResult res = query.evaluate();){
                int cnt = this.countGraphResults(res);
                log.info("+++++    count triples: {}", (Object)cnt);
                Assert.assertTrue((String)String.format("count triples: {}", cnt), (cnt == 3 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.commit();
        }
    }

    @Test
    public void testDistanceFunction() throws Exception {
        String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?toUri ?fromUri ?dist where {?toUri a <urn:geo/Landmark>; geo:asWKT ?to. ?fromUri geo:asWKT ?from; <urn:geo/maxDistance> ?range. bind(geof:distance(?from, ?to, ?units) as ?dist) filter(?dist < ?range) }";
        try {
            this.connection.begin();
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            query.setBinding("units", (Value)GEOF.UOM_METRE);
            this.printTupleResult(query);
            try (TupleQueryResult result = query.evaluate();){
                int count = this.countTupleResults(result);
                Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)2));
            }
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.commit();
        }
    }

    public int countStatements(RepositoryConnection con) throws Exception {
        try {
            this.connection.begin();
            RepositoryResult sts = this.connection.getStatements(null, null, null, new Resource[0]);
            int n = Iterations.asList((Iteration)sts).size();
            return n;
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.commit();
        }
    }

    public int countTupleResults(TupleQueryResult results) throws Exception {
        return Iterations.asList((Iteration)results).size();
    }

    public int countGraphResults(GraphQueryResult results) throws Exception {
        return Iterations.asList((Iteration)results).size();
    }

    protected void printGraphResult(GraphQuery query) {
        ByteArrayOutputStream resultoutput = new ByteArrayOutputStream();
        query.evaluate((RDFHandler)new TurtleWriter((OutputStream)resultoutput));
        log.info("graph result:");
        log.info("\n=============\n" + new String(resultoutput.toByteArray()) + "\n=============");
    }

    protected void printTupleResult(TupleQuery query) {
        ByteArrayOutputStream resultoutput = new ByteArrayOutputStream();
        query.evaluate((TupleQueryResultHandler)new SPARQLResultsCSVWriter((OutputStream)resultoutput));
        log.info("tuple result:");
        log.info("\n=============\n" + new String(resultoutput.toByteArray()) + "\n=============");
    }
}

