/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContextInitializer;
import org.eclipse.rdf4j.query.resultio.text.csv.SPARQLResultsCSVWriter;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchIndexQueryContextInitializer;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.spin.SpinSail;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLuceneSailSpinTest {
    private static final String DATA = "org/eclipse/rdf4j/sail/220-example.ttl";
    private static Logger log = LoggerFactory.getLogger(AbstractLuceneSailSpinTest.class);
    private Repository repository;
    private RepositoryConnection connection;
    private SearchIndex searchIndex;

    @Before
    public void setUp() throws Exception {
        MemoryStore store = new MemoryStore();
        SpinSail spin = new SpinSail((NotifyingSail)store);
        spin.setEvaluationMode(TupleFunctionEvaluationMode.TRIPLE_SOURCE);
        Properties parameters = new Properties();
        this.configure(parameters);
        this.searchIndex = LuceneSail.createSearchIndex((Properties)parameters);
        spin.addQueryContextInitializer((QueryContextInitializer)new SearchIndexQueryContextInitializer(this.searchIndex));
        this.repository = new SailRepository((Sail)spin);
        this.repository.initialize();
        this.connection = this.repository.getConnection();
        this.populate(this.connection, this.searchIndex);
        int count = this.countStatements(this.connection);
        log.info("storage contains {} triples", (Object)count);
        assert (count > 0);
    }

    @After
    public void tearDown() throws IOException, RepositoryException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        finally {
            try {
                if (this.repository != null) {
                    this.repository.shutDown();
                }
            }
            finally {
                if (this.searchIndex != null) {
                    this.searchIndex.shutDown();
                }
            }
        }
    }

    protected abstract void configure(Properties var1);

    protected void populate(RepositoryConnection repoConn, SearchIndex searchIndex) throws Exception {
        URL resourceURL = AbstractLuceneSailSpinTest.class.getClassLoader().getResource(DATA);
        log.info("Resource URL: {}", (Object)resourceURL.toString());
        Model model = Rio.parse((InputStream)resourceURL.openStream(), (String)resourceURL.toString(), (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
        searchIndex.begin();
        for (Statement stmt : model) {
            repoConn.add(stmt, new Resource[0]);
            searchIndex.addStatement(stmt);
        }
        searchIndex.commit();
    }

    @Test
    public void simpleTest() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ?s ?p ?o where { ?s ?p ?o } limit 10");
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, buffer.toString());
        try (TupleQueryResult res = query.evaluate();){
            int count = this.countTupleResults(res);
            log.info("count statements: {}", (Object)count);
            Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void simpleSearchTest() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ?predicate ?score ?subject where {\n");
        buffer.append("(\"ornare\" <" + LuceneSailSchema.ALL_MATCHES + "> <" + LuceneSailSchema.SCORE + ">) <" + LuceneSailSchema.SEARCH + ">  (?pred ?score) . \n");
        buffer.append("  ?pred <urn:test.org/onto#number> ?subject .\n");
        buffer.append("}\n");
        log.info("Request query: \n====================\n{}\n======================\n", (Object)buffer.toString());
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, buffer.toString());
        log.debug("query class: {}", query.getClass());
        try (TupleQueryResult res = query.evaluate();){
            int count = this.countTupleResults(res);
            log.info("count statements: {}", (Object)count);
            Assert.assertTrue((String)("count statements: " + count), (count > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test220Issue() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append("select ?pred ?score ?query ?label where {\n");
        buffer.append("  bind(str(\"ornare\") as ?query) .\n");
        buffer.append("  (?query <" + LuceneSailSchema.ALL_MATCHES + "> <" + LuceneSailSchema.SCORE + "> ) <" + LuceneSailSchema.SEARCH + ">  (?pred ?score) . \n");
        buffer.append("  ?pred rdfs:label ?label .\n");
        buffer.append("}\n");
        log.info("Request query: \n====================\n{}\n======================\n", (Object)buffer.toString());
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, buffer.toString());
        this.printTupleResult(query);
        try (TupleQueryResult res = query.evaluate();){
            int count = this.countTupleResults(res);
            log.info("count statements: {}", (Object)count);
            Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test235Issue() throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append(" construct {\n");
        buffer.append("  ?pred a <urn:ontology/Phrase> .\n");
        buffer.append("  ?pred <urn:ontology/label> ?label2 .\n");
        buffer.append("  ?pred <urn:ontology/score> ?score .\n");
        buffer.append(" } where {\n");
        buffer.append("  bind(str(\"ornare\") as ?query) .\n");
        buffer.append("  (?query <" + LuceneSailSchema.ALL_MATCHES + "> <" + LuceneSailSchema.SCORE + ">) <" + LuceneSailSchema.SEARCH + "> (?pred ?score) . \n");
        buffer.append("  ?pred rdfs:label ?label .\n");
        buffer.append("  bind(fn:upper-case(?label) as ?label2)\n");
        buffer.append(" }");
        log.info("Request query: \n====================\n{}\n======================\n", (Object)buffer.toString());
        GraphQuery query = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, buffer.toString());
        this.printGraphResult(query);
        try (GraphQueryResult res = query.evaluate();){
            int cnt = this.countGraphResults(res);
            Assert.assertTrue((String)String.format("count triples: ", cnt), (cnt > 2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDistanceFunction() throws Exception {
        String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>prefix search: <http://www.openrdf.org/contrib/lucenesail#>select ?toUri ?fromUri ?dist where {(?from ?range ?units geo:asWKT search:distance)search:withinDistance (?toUri ?to ?dist) .?toUri a <urn:geo/Landmark>. ?fromUri geo:asWKT ?from; <urn:geo/maxDistance> ?range.}";
        try {
            this.connection.begin();
            TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            query.setBinding("units", (Value)GEOF.UOM_METRE);
            this.printTupleResult(query);
            try (TupleQueryResult result = query.evaluate();){
                int count = this.countTupleResults(result);
                Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)2));
            }
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.commit();
        }
    }

    public int countStatements(RepositoryConnection con) throws Exception {
        RepositoryResult sts = this.connection.getStatements(null, null, null, new Resource[0]);
        return Iterations.asList((Iteration)sts).size();
    }

    public int countTupleResults(TupleQueryResult results) throws Exception {
        return Iterations.asList((Iteration)results).size();
    }

    public int countGraphResults(GraphQueryResult results) throws Exception {
        return Iterations.asList((Iteration)results).size();
    }

    protected void printGraphResult(GraphQuery query) {
        ByteArrayOutputStream resultoutput = new ByteArrayOutputStream();
        query.evaluate((RDFHandler)new TurtleWriter((OutputStream)resultoutput));
        log.info("graph result:");
        log.info("\n=============\n" + new String(resultoutput.toByteArray()) + "\n=============");
    }

    protected void printTupleResult(TupleQuery query) {
        ByteArrayOutputStream resultoutput = new ByteArrayOutputStream();
        query.evaluate((TupleQueryResultHandler)new SPARQLResultsCSVWriter((OutputStream)resultoutput));
        log.info("tuple result:");
        log.info("\n=============\n" + new String(resultoutput.toByteArray()) + "\n=============");
    }
}

