/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LiteralImpl;
import org.eclipse.rdf4j.model.impl.URIImpl;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractLuceneSailGeoSPARQLTest {
    public static final URI SUBJECT_1 = new URIImpl("urn:subject1");
    public static final URI SUBJECT_2 = new URIImpl("urn:subject2");
    public static final URI SUBJECT_3 = new URIImpl("urn:subject3");
    public static final URI SUBJECT_4 = new URIImpl("urn:subject4");
    public static final URI SUBJECT_5 = new URIImpl("urn:subject5");
    public static final URI CONTEXT_1 = new URIImpl("urn:context1");
    public static final URI CONTEXT_2 = new URIImpl("urn:context2");
    public static final URI CONTEXT_3 = new URIImpl("urn:context3");
    public static final Literal EIFFEL_TOWER = new LiteralImpl("POINT (2.2945 48.8582)", (URI)GEO.WKT_LITERAL);
    public static final Literal ARC_TRIOMPHE = new LiteralImpl("POINT (2.2950 48.8738)", (URI)GEO.WKT_LITERAL);
    public static final Literal NOTRE_DAME = new LiteralImpl("POINT (2.3465 48.8547)", (URI)GEO.WKT_LITERAL);
    public static final Literal POLY1 = new LiteralImpl("POLYGON ((2.3294 48.8726, 2.2719 48.8643, 2.3370 48.8398, 2.3294 48.8726))", (URI)GEO.WKT_LITERAL);
    public static final Literal POLY2 = new LiteralImpl("POLYGON ((2.3509 48.8429, 2.3785 48.8385, 2.3576 48.8487, 2.3509 48.8429))", (URI)GEO.WKT_LITERAL);
    public static final Literal TEST_POINT = new LiteralImpl("POINT (2.2871 48.8630)", (URI)GEO.WKT_LITERAL);
    public static final Literal TEST_POLY = new LiteralImpl("POLYGON ((2.315 48.855, 2.360 48.835, 2.370 48.850, 2.315 48.855))", (URI)GEO.WKT_LITERAL);
    private static final double ERROR = 2.0;
    protected LuceneSail sail;
    protected Repository repository;
    protected RepositoryConnection connection;

    protected abstract void configure(LuceneSail var1) throws IOException;

    @Before
    public void setUp() throws Exception {
        MemoryStore memoryStore = new MemoryStore();
        Properties.setLockTrackingEnabled((boolean)true);
        this.sail = new LuceneSail();
        this.configure(this.sail);
        this.sail.setBaseSail((Sail)memoryStore);
        this.repository = new SailRepository((Sail)this.sail);
        this.repository.initialize();
        this.connection = this.repository.getConnection();
        this.connection.begin();
        this.loadPoints();
        this.loadPolygons();
        this.connection.commit();
    }

    protected void loadPoints() throws RepositoryException {
        this.connection.add((Resource)SUBJECT_1, GEO.AS_WKT, (Value)EIFFEL_TOWER, new Resource[]{CONTEXT_1});
        this.connection.add((Resource)SUBJECT_2, GEO.AS_WKT, (Value)ARC_TRIOMPHE, new Resource[0]);
        this.connection.add((Resource)SUBJECT_3, GEO.AS_WKT, (Value)NOTRE_DAME, new Resource[]{CONTEXT_2});
    }

    protected void loadPolygons() throws RepositoryException {
        this.connection.add((Resource)SUBJECT_4, GEO.AS_WKT, (Value)POLY1, new Resource[0]);
        this.connection.add((Resource)SUBJECT_5, GEO.AS_WKT, (Value)POLY2, new Resource[]{CONTEXT_3});
    }

    @After
    public void tearDown() throws IOException, RepositoryException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        finally {
            if (this.repository != null) {
                this.repository.shutDown();
            }
        }
    }

    @Test
    public void testTriplesStored() throws Exception {
        this.checkPoints();
        this.checkPolygons();
    }

    protected void checkPoints() throws RepositoryException {
        Assert.assertTrue((boolean)this.connection.hasStatement((Resource)SUBJECT_1, GEO.AS_WKT, (Value)EIFFEL_TOWER, false, new Resource[]{CONTEXT_1}));
        Assert.assertTrue((boolean)this.connection.hasStatement((Resource)SUBJECT_2, GEO.AS_WKT, (Value)ARC_TRIOMPHE, false, new Resource[0]));
        Assert.assertTrue((boolean)this.connection.hasStatement((Resource)SUBJECT_3, GEO.AS_WKT, (Value)NOTRE_DAME, false, new Resource[]{CONTEXT_2}));
    }

    protected void checkPolygons() throws RepositoryException {
        Assert.assertTrue((boolean)this.connection.hasStatement((Resource)SUBJECT_4, GEO.AS_WKT, (Value)POLY1, false, new Resource[0]));
        Assert.assertTrue((boolean)this.connection.hasStatement((Resource)SUBJECT_5, GEO.AS_WKT, (Value)POLY2, false, new Resource[]{CONTEXT_3}));
    }

    @Test
    public void testDistanceQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?toUri ?to where { ?toUri geo:asWKT ?to. filter(geof:distance(?from, ?to, ?units) < ?range) }";
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
        query.setBinding("from", (Value)TEST_POINT);
        query.setBinding("units", (Value)GEOF.UOM_METRE);
        query.setBinding("range", (Value)this.sail.getValueFactory().createLiteral(1500.0));
        TupleQueryResult result = query.evaluate();
        LinkedHashMap<URI, Literal> expected = new LinkedHashMap<URI, Literal>();
        expected.put(SUBJECT_1, EIFFEL_TOWER);
        expected.put(SUBJECT_2, ARC_TRIOMPHE);
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            URI subj = (URI)bindings.getValue("toUri");
            URI expectedUri = (URI)expected.keySet().iterator().next();
            Assert.assertEquals((Object)expectedUri, (Object)subj);
            Literal location = (Literal)expected.remove(subj);
            Assert.assertNotNull((Object)location);
            Assert.assertEquals((Object)location, (Object)bindings.getValue("to"));
        }
        Assert.assertTrue((boolean)expected.isEmpty());
        result.close();
    }

    @Test
    public void testComplexDistanceQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?toUri ?dist ?g where { graph ?g {?toUri geo:asWKT ?to.} bind(geof:distance(?from, ?to, ?units) as ?dist) filter(?dist < ?range) }";
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
        query.setBinding("from", (Value)TEST_POINT);
        query.setBinding("units", (Value)GEOF.UOM_METRE);
        query.setBinding("range", (Value)this.sail.getValueFactory().createLiteral(1500.0));
        TupleQueryResult result = query.evaluate();
        LinkedHashMap<URI, Literal> expected = new LinkedHashMap<URI, Literal>();
        expected.put(SUBJECT_1, this.sail.getValueFactory().createLiteral(760.0));
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            URI subj = (URI)bindings.getValue("toUri");
            URI expectedUri = (URI)expected.keySet().iterator().next();
            Assert.assertEquals((Object)expectedUri, (Object)subj);
            Literal dist = (Literal)expected.remove(subj);
            Assert.assertNotNull((Object)dist);
            Assert.assertEquals((double)dist.doubleValue(), (double)((Literal)bindings.getValue("dist")).doubleValue(), (double)2.0);
            Assert.assertNotNull((Object)bindings.getValue("g"));
        }
        Assert.assertTrue((boolean)expected.isEmpty());
        result.close();
    }

    public void testIntersectionQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?matchUri ?match where { ?matchUri geo:asWKT ?match. filter(geof:sfIntersects(?pattern, ?match)) }";
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
        query.setBinding("pattern", (Value)TEST_POLY);
        TupleQueryResult result = query.evaluate();
        HashMap<URI, Literal> expected = new HashMap<URI, Literal>();
        expected.put(SUBJECT_4, POLY1);
        expected.put(SUBJECT_5, POLY2);
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            URI subj = (URI)bindings.getValue("matchUri");
            Literal location = (Literal)expected.remove(subj);
            Assert.assertNotNull((Object)location);
            Assert.assertEquals((Object)location, (Object)bindings.getValue("match"));
        }
        Assert.assertTrue((boolean)expected.isEmpty());
        result.close();
    }

    public void testComplexIntersectionQuery() throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String queryStr = "prefix geo:  <http://www.opengis.net/ont/geosparql#>prefix geof: <http://www.opengis.net/def/function/geosparql/>select ?matchUri ?intersects ?g where { graph ?g {?matchUri geo:asWKT ?match.} bind(geof:sfIntersects(?pattern, ?match) as ?intersects) filter(?intersects) }";
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
        query.setBinding("pattern", (Value)TEST_POLY);
        TupleQueryResult result = query.evaluate();
        HashMap<URI, Literal> expected = new HashMap<URI, Literal>();
        expected.put(SUBJECT_5, this.sail.getValueFactory().createLiteral(true));
        while (result.hasNext()) {
            BindingSet bindings = (BindingSet)result.next();
            URI subj = (URI)bindings.getValue("matchUri");
            Literal location = (Literal)expected.remove(subj);
            Assert.assertNotNull((String)("Expected subject: " + subj), (Object)location);
            Assert.assertEquals((Object)location.booleanValue(), (Object)((Literal)bindings.getValue("intersects")).booleanValue());
            Assert.assertNotNull((Object)bindings.getValue("g"));
        }
        Assert.assertTrue((boolean)expected.isEmpty());
        result.close();
    }
}

