/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.config.ConfigView;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class ConfigController
extends AbstractController {
    private RepositoryManager repositoryManager;
    private final ModelFactory modelFactory = new LinkedHashModelFactory();

    public ConfigController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "POST", "HEAD"});
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        switch (request.getMethod()) {
            case "GET": 
            case "HEAD": {
                return this.handleQuery(request, response);
            }
            case "POST": {
                return this.handleUpdate(request, response);
            }
        }
        throw new ClientHTTPException("unrecognized method " + request.getMethod());
    }

    private ModelAndView handleQuery(HttpServletRequest request, HttpServletResponse response) throws ClientHTTPException {
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)ProtocolUtil.getAcceptableService(request, response, RDFWriterRegistry.getInstance());
        String repId = RepositoryInterceptor.getRepositoryID(request);
        RepositoryConfig repositoryConfig = this.repositoryManager.getRepositoryConfig(repId);
        Model configData = this.modelFactory.createEmptyModel();
        String baseURI = request.getRequestURL().toString();
        IRI ctx = SimpleValueFactory.getInstance().createIRI(baseURI + "#" + repositoryConfig.getID());
        repositoryConfig.export(configData, (Resource)ctx);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("format", rdfWriterFactory.getRDFFormat());
        model.put("configData", configData);
        model.put("headersOnly", "HEAD".equals(request.getMethod()));
        return new ModelAndView((View)ConfigView.getInstance(), model);
    }

    private ModelAndView handleUpdate(HttpServletRequest request, HttpServletResponse response) throws RDFParseException, UnsupportedRDFormatException, IOException, HTTPException {
        String repId = RepositoryInterceptor.getRepositoryID(request);
        Model model = Rio.parse((InputStream)request.getInputStream(), (String)"", (RDFFormat)((RDFFormat)Rio.getParserFormatForMIMEType((String)request.getContentType()).orElseThrow(() -> new HTTPException(400, "unrecognized content type " + request.getContentType()))), (Resource[])new Resource[0]);
        RepositoryConfig config = RepositoryConfigUtil.getRepositoryConfig((Model)model, (String)repId);
        this.repositoryManager.addRepositoryConfig(config);
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }
}

